/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.intermediary;

import by.fxg.basicfml.configv2.intermediary.IntermediaryArray;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveBoolean;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveNumber;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveString;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.configv2.model.ConfigCompound;
import by.fxg.basicfml.configv2.model.ConfigWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class IntermediaryCompound
extends IntermediaryWrapper
implements ConfigCompound<IntermediaryWrapper, IntermediaryWrapper>,
Iterable<Map.Entry<String, IntermediaryWrapper>> {
    private Map<String, IntermediaryWrapper> map = new LinkedHashMap<String, IntermediaryWrapper>();

    public IntermediaryCompound() {
    }

    public IntermediaryCompound(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                IntermediaryWrapper wrapper;
                if (entry.getKey() == null || (wrapper = IntermediaryCompound.convertToWrapper(entry.getValue())) == null) continue;
                this.map.put(entry.getKey(), wrapper);
            }
        }
    }

    @Override
    public boolean hasNode(String name) {
        return this.map.containsKey(name);
    }

    public IntermediaryWrapper getNode(String name) {
        return this.map.get(name);
    }

    public IntermediaryArray getArray(String name) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryArray ? (IntermediaryArray)obj : null;
    }

    public IntermediaryCompound getCompound(String name) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryCompound ? (IntermediaryCompound)obj : null;
    }

    public IntermediaryPrimitive getPrimitive(String name) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? (IntermediaryPrimitive)obj : null;
    }

    public IntermediaryCompound appendNode(String name, ConfigWrapper<IntermediaryWrapper> node) {
        if (!(node instanceof IntermediaryWrapper)) {
            throw new IllegalArgumentException("Only IntermediaryWrapper itself or it siblings could be provided as argument");
        }
        this.map.put(name, (IntermediaryWrapper)node);
        return this;
    }

    public IntermediaryCompound appendNode(String name, ConfigWrapper<IntermediaryWrapper> node, String comment) {
        if (!(node instanceof IntermediaryWrapper)) {
            throw new IllegalArgumentException("Only IntermediaryWrapper itself or it siblings could be provided as argument");
        }
        this.map.put(name, ((IntermediaryWrapper)node).setComment(comment));
        return this;
    }

    public IntermediaryCompound append(String name, IntermediaryWrapper absNode) {
        this.map.put(name, absNode);
        return this;
    }

    public IntermediaryCompound append(String name, IntermediaryWrapper absNode, String comment) {
        this.map.put(name, absNode.setComment(comment));
        return this;
    }

    public IntermediaryCompound append(String name, boolean bool) {
        this.map.put(name, new IntermediaryPrimitiveBoolean(bool));
        return this;
    }

    public IntermediaryCompound append(String name, boolean bool, String comment) {
        this.map.put(name, new IntermediaryPrimitiveBoolean(bool).setComment(comment));
        return this;
    }

    public IntermediaryCompound append(String name, Number number) {
        this.map.put(name, new IntermediaryPrimitiveNumber(number));
        return this;
    }

    public IntermediaryCompound append(String name, Number number, String comment) {
        this.map.put(name, new IntermediaryPrimitiveNumber(number).setComment(comment));
        return this;
    }

    public IntermediaryCompound append(String name, String string) {
        this.map.put(name, new IntermediaryPrimitiveString(string));
        return this;
    }

    public IntermediaryCompound append(String name, String string, String comment) {
        this.map.put(name, new IntermediaryPrimitiveString(string).setComment(comment));
        return this;
    }

    public IntermediaryCompound appendEmpty(String key) {
        this.map.put(key, null);
        return this;
    }

    public IntermediaryCompound remove(String key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public boolean isBoolean(String name) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive && ((IntermediaryPrimitive)obj).isBoolean();
    }

    @Override
    public boolean isNumber(String name) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive && ((IntermediaryPrimitive)obj).isNumber();
    }

    @Override
    public boolean isLiteral(String name) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive && ((IntermediaryPrimitive)obj).isLiteral();
    }

    @Override
    public boolean getBoolean(String name, boolean fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getBoolean(fallback) : fallback;
    }

    @Override
    public Number getNumber(String name, Number fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? (Number)((IntermediaryPrimitive)obj).getNumber(fallback) : (Number)fallback;
    }

    @Override
    public byte getByte(String name, byte fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getByte(fallback) : fallback;
    }

    @Override
    public short getShort(String name, short fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getShort(fallback) : fallback;
    }

    @Override
    public int getInteger(String name, int fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getInteger(fallback) : fallback;
    }

    @Override
    public long getLong(String name, long fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getLong(fallback) : fallback;
    }

    @Override
    public float getFloat(String name, float fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getFloat(fallback) : fallback;
    }

    @Override
    public double getDouble(String name, double fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getDouble(fallback) : fallback;
    }

    @Override
    public char getChar(String name, char fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getChar(fallback) : fallback;
    }

    @Override
    public String getString(String name, String fallback) {
        IntermediaryWrapper obj = this.map.get(name);
        return obj instanceof IntermediaryPrimitive ? ((IntermediaryPrimitive)obj).getString(fallback) : fallback;
    }

    @Override
    public Map<String, IntermediaryWrapper> getValue() {
        return this.map;
    }

    @Override
    public Iterator<Map.Entry<String, IntermediaryWrapper>> iterator() {
        return this.map.entrySet().iterator();
    }

    private static IntermediaryWrapper convertToWrapper(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            IntermediaryCompound compound = new IntermediaryCompound();
            for (Map.Entry entry : map.entrySet()) {
                IntermediaryWrapper wrapper;
                if (!(entry.getKey() instanceof String) || (wrapper = IntermediaryCompound.convertToWrapper(entry.getValue())) == null) continue;
                compound.append((String)entry.getKey(), wrapper);
            }
            return compound;
        }
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            Iterator iterator = list.iterator();
            IntermediaryArray array = new IntermediaryArray();
            while (iterator.hasNext()) {
                IntermediaryWrapper wrapper = IntermediaryCompound.convertToWrapper(iterator.next());
                if (wrapper == null) continue;
                array.append(wrapper);
            }
            return array;
        }
        if (object instanceof Boolean) {
            return new IntermediaryPrimitiveBoolean((Boolean)object);
        }
        if (object instanceof Number) {
            return new IntermediaryPrimitiveNumber((Number)object);
        }
        if (object instanceof String) {
            return new IntermediaryPrimitiveString((String)object);
        }
        return null;
    }

    public static Map<String, Object> convertToMap(IntermediaryCompound compound) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, IntermediaryWrapper> entry : compound.map.entrySet()) {
            map.put(entry.getKey(), IntermediaryCompound.reverseObject(entry.getValue()));
        }
        return map;
    }

    private static Object reverseObject(IntermediaryWrapper wrapper) {
        if (wrapper instanceof IntermediaryCompound) {
            IntermediaryCompound compound = (IntermediaryCompound)wrapper;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, IntermediaryWrapper> entry : compound.map.entrySet()) {
                map.put(entry.getKey(), IntermediaryCompound.reverseObject(entry.getValue()));
            }
            return map;
        }
        if (wrapper instanceof IntermediaryArray) {
            IntermediaryArray array = (IntermediaryArray)wrapper;
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int index = 0; index < array.size(); ++index) {
                objects.add(IntermediaryCompound.reverseObject(array.getNodeAt(index)));
            }
            return objects;
        }
        if (wrapper instanceof IntermediaryPrimitive) {
            return wrapper.getValue();
        }
        return wrapper;
    }
}

