/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.io.toml;

import by.fxg.basicfml.configv2.intermediary.IntermediaryArray;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class TomlWriter {
    private static final String LINE_SEPARATOR_REGEX = "\r\n?|\n";
    private static final String COMMENT = "# ";
    private final Writer writer;
    private final int indentSize;
    private final char indentCharacter;
    private final String lineSeparator;
    private final LinkedList<String> tablesNames = new LinkedList();
    private int lineBreaks = 0;
    private int indentationLevel = -1;

    public TomlWriter(Writer writer) {
        this(writer, 1, false, System.lineSeparator());
    }

    public TomlWriter(Writer writer, int indentSize, boolean useIndentTabs) {
        this(writer, indentSize, useIndentTabs, System.lineSeparator());
    }

    public TomlWriter(Writer writer, int indentSize, boolean useIndentTabs, String lineSeparator) {
        this.writer = writer;
        this.indentSize = indentSize;
        this.indentCharacter = (char)(useIndentTabs ? 9 : 32);
        this.lineSeparator = lineSeparator;
    }

    public void write(IntermediaryCompound compound) throws IOException {
        this.writeTableContent(compound);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    private void writeTableName() throws IOException {
        Iterator it = this.tablesNames.iterator();
        while (it.hasNext()) {
            String namePart = (String)it.next();
            this.writeKey(namePart);
            if (!it.hasNext()) continue;
            this.write('.');
        }
    }

    private void writeTableContent(IntermediaryCompound compound) throws IOException {
        this.writeTableContent(compound, true);
        this.writeTableContent(compound, false);
    }

    private void writeTableContent(IntermediaryCompound content, boolean simpleValues) throws IOException {
        for (Map.Entry<String, IntermediaryWrapper> entry : content) {
            String name = entry.getKey();
            IntermediaryWrapper value = entry.getValue();
            if (value instanceof IntermediaryCompound) {
                IntermediaryCompound compound = (IntermediaryCompound)value;
                if (simpleValues) continue;
                this.tablesNames.addLast(name);
                ++this.indentationLevel;
                if (compound.hasComment()) {
                    this.writeComment(compound);
                }
                this.indent();
                this.write('[');
                this.writeTableName();
                this.write(']');
                this.newLine();
                this.writeTableContent(compound);
                --this.indentationLevel;
                this.tablesNames.removeLast();
            } else if (value instanceof IntermediaryArray) {
                IntermediaryArray array = (IntermediaryArray)value;
                if (array.containsCompounds()) {
                    if (simpleValues) continue;
                    this.tablesNames.addLast(name);
                    ++this.indentationLevel;
                    for (IntermediaryWrapper wrapper : array) {
                        if (!(wrapper instanceof IntermediaryCompound)) {
                            throw new IOException("TOML does NOT supports arrays of compounds with another elements, they're type-strict!");
                        }
                        IntermediaryCompound compound = (IntermediaryCompound)wrapper;
                        if (compound.hasComment()) {
                            this.writeComment(compound);
                        }
                        this.indent();
                        this.write("[[");
                        this.writeTableName();
                        this.write("]]\n");
                        this.writeTableContent(compound);
                    }
                    --this.indentationLevel;
                    this.tablesNames.removeLast();
                } else {
                    if (!simpleValues) continue;
                    if (array.hasComment()) {
                        this.writeComment(array);
                    }
                    this.indent();
                    this.writeKey(name);
                    this.write(" = ");
                    this.writeArray(array);
                }
            } else {
                if (!simpleValues) continue;
                if (value.hasComment()) {
                    this.writeComment(value);
                }
                this.indent();
                this.writeKey(name);
                this.write(" = ");
                this.writeValue(value);
            }
            this.newLine();
        }
        this.newLine();
    }

    private void writeComment(IntermediaryWrapper wrapper) throws IOException {
        String[] commentParts = wrapper.getComment().split(LINE_SEPARATOR_REGEX);
        for (int i = 0; i < commentParts.length; ++i) {
            this.write(COMMENT);
            this.write(commentParts[i]);
            this.newLine();
            this.indent();
        }
    }

    private void writeKey(String key) throws IOException {
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            this.writeString(key);
            return;
        }
        this.write(key);
    }

    private void writeString(String str) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            TomlWriter.addEscaped(c, sb);
        }
        sb.append('\"');
        this.write(sb.toString());
    }

    private void writeArray(IntermediaryArray array) throws IOException {
        this.write('[');
        for (IntermediaryWrapper wrapper : array) {
            if (wrapper instanceof IntermediaryCompound) {
                throw new IOException("TOML does NOT supports arrays of compounds with another elements, they're type-strict!");
            }
            this.writeValue(wrapper);
            this.write(", ");
        }
        this.write(']');
    }

    private void writeValue(IntermediaryWrapper wrapper) throws IOException {
        if (wrapper instanceof IntermediaryPrimitive) {
            IntermediaryPrimitive primitive = (IntermediaryPrimitive)wrapper;
            if (primitive.isLiteral()) {
                this.writeString(wrapper.getValue() instanceof String ? primitive.getString() : String.valueOf(primitive.getChar()));
            } else if (primitive.isNumber() || primitive.isBoolean()) {
                this.write(primitive.getValue().toString());
            }
        } else if (wrapper instanceof IntermediaryArray) {
            this.writeArray((IntermediaryArray)wrapper);
        } else {
            throw new IOException("Unexpected value " + wrapper);
        }
    }

    private void newLine() throws IOException {
        if (this.lineBreaks <= 1) {
            this.writer.write(this.lineSeparator);
            ++this.lineBreaks;
        }
    }

    private void write(char c) throws IOException {
        this.writer.write(c);
        this.lineBreaks = 0;
    }

    private void write(String str) throws IOException {
        this.writer.write(str);
        this.lineBreaks = 0;
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indentationLevel; ++i) {
            for (int j = 0; j < this.indentSize; ++j) {
                this.write(this.indentCharacter);
            }
        }
    }

    static void addEscaped(char c, StringBuilder sb) {
        switch (c) {
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }
}

