/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.io.yaml;

import by.fxg.basicfml.BasicFML;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.io.BasicConfigReader;
import by.fxg.basicfml.configv2.io.BasicConfigWriter;
import by.fxg.basicfml.configv2.io.yaml.YamlWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlIntermediaryReadWriter
implements BasicConfigReader<IntermediaryCompound>,
BasicConfigWriter<IntermediaryCompound> {
    private Yaml yaml;
    private boolean separateFirstLevelObjects = true;
    private boolean separateCommentsFromAbove = true;

    public YamlIntermediaryReadWriter(Yaml yaml) {
        this.yaml = yaml;
    }

    public YamlIntermediaryReadWriter() {
        this(BasicFML.YAML_INSTANCE);
    }

    public void setSeparateFirstLevelObjects(boolean value) {
        this.separateFirstLevelObjects = value;
    }

    public void setSeparateCommentsFromAbove(boolean value) {
        this.separateCommentsFromAbove = value;
    }

    @Override
    public boolean write(File file, IntermediaryCompound type) {
        if (file != null) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                YamlWriter writer = new YamlWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8)), 2, false);
                writer.setSeparateFirstCompounds(this.separateFirstLevelObjects);
                writer.setSeparateCommentsFromAbove(this.separateCommentsFromAbove);
                writer.write(type);
                writer.close();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public IntermediaryCompound read(File file) {
        if (file != null && file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                Map map = this.yaml.loadAs(reader, Map.class);
                ((Reader)reader).close();
                return new IntermediaryCompound(map);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }
}

