/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.objects;

import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveString;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.configv2.objects.ConfigCompoundEntry;
import by.fxg.basicfml.configv2.objects.InfoStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ConfigItemStack
extends ConfigCompoundEntry {
    private IntermediaryWrapper primitive;
    private InfoStack stack;

    public ConfigItemStack(InfoStack stack) {
        this.stack = stack == null ? new InfoStack() : stack;
    }

    public ConfigItemStack(ItemStack stack) {
        this(new InfoStack(stack));
    }

    public ConfigItemStack() {
        this(new InfoStack());
    }

    @Override
    public IntermediaryWrapper serialize() {
        if (this.primitive == null) {
            this.primitive = new IntermediaryPrimitiveString(this.stack.write());
        }
        return this.primitive;
    }

    @Override
    public void deserialize(IntermediaryWrapper wrapper) {
        IntermediaryPrimitive primitive;
        if (wrapper instanceof IntermediaryPrimitive && (primitive = (IntermediaryPrimitive)wrapper).isLiteral()) {
            this.primitive = primitive;
            this.stack.read(primitive.getString(), true);
        }
    }

    public boolean equals(ItemStack stack, boolean deep) {
        return this.stack.equalsStack(stack, deep);
    }

    public boolean equals(ItemStack stack, int meta, boolean deep) {
        return this.stack.equalsStack(stack, meta, deep);
    }

    public boolean equals(Item item) {
        return this.stack.equalsItem(item);
    }

    public boolean equals(Item item, int meta) {
        return this.stack.equalsItem(item, meta);
    }

    public ItemStack getStack() {
        return this.stack.getStack();
    }
}

