/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.objects;

import by.fxg.basicfml.BasicFML;
import by.fxg.basicfml.configv2.intermediary.IntermediaryArray;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.configv2.objects.ConfigCompoundEntry;
import by.fxg.basicfml.configv2.objects.InfoStack;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import scala.actors.threadpool.Arrays;

public final class ConfigItemStackList
extends ConfigCompoundEntry {
    private IntermediaryArray array = null;
    private List<InfoStack> stacks;

    public ConfigItemStackList() {
        this.stacks = new ArrayList<InfoStack>();
    }

    public ConfigItemStackList(List<InfoStack> stacks) {
        this.stacks = stacks;
    }

    public ConfigItemStackList(InfoStack ... stacks) {
        this.stacks = Arrays.asList((Object[])stacks);
    }

    @Override
    public IntermediaryWrapper serialize() {
        if (this.array == null) {
            this.array = new IntermediaryArray();
            for (InfoStack stack : this.stacks) {
                this.array.append(stack.write());
            }
        }
        return this.array;
    }

    @Override
    public void deserialize(IntermediaryWrapper element) {
        if (element instanceof IntermediaryArray) {
            this.array = (IntermediaryArray)element;
            this.stacks.clear();
            for (IntermediaryWrapper wrapper : this.array) {
                IntermediaryPrimitive primitive;
                if (!(wrapper instanceof IntermediaryPrimitive) || !(primitive = (IntermediaryPrimitive)wrapper).isLiteral()) continue;
                InfoStack stack = new InfoStack(primitive.getString(), true);
                if (stack.isValid()) {
                    this.stacks.add(stack);
                    continue;
                }
                BasicFML.LOGGER.log(Level.WARNING, "Unable to parse item `{}` in config", primitive.getString());
            }
        }
    }

    public boolean contains(ItemStack stack, boolean deep) {
        return stack != null ? this.contains(stack, stack.func_77960_j(), deep) : false;
    }

    public boolean contains(ItemStack stack, int meta, boolean deep) {
        if (stack != null) {
            for (int idx = 0; idx < this.stacks.size(); ++idx) {
                if (!this.stacks.get(idx).equalsStack(stack, meta, deep)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Item item) {
        return this.contains(item, 0);
    }

    public boolean contains(Item item, int meta) {
        if (item != null) {
            for (int idx = 0; idx < this.stacks.size(); ++idx) {
                if (!this.stacks.get(idx).equalsItem(item, meta)) continue;
                return true;
            }
        }
        return false;
    }

    public List<InfoStack> getStacks() {
        return this.stacks;
    }
}

