/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.objects;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.math.NumberUtils;

public final class InfoStack {
    private boolean isValid = false;
    protected ItemStack stack;
    protected boolean anyMeta;

    public InfoStack(ItemStack stack, boolean anyMeta) {
        this.stack = stack;
        this.anyMeta = anyMeta;
        this.isValid = this.invalidate();
    }

    public InfoStack(ItemStack stack) {
        this(stack, false);
    }

    public InfoStack(String string, boolean withFallback) {
        this.read(string, withFallback);
    }

    public InfoStack() {
        this((ItemStack)null, false);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean isAnyMeta() {
        return this.anyMeta;
    }

    public void setAnyMeta(boolean anyMeta) {
        this.anyMeta = anyMeta;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void read(String str, boolean withFallback) {
        ItemStack prevStack = this.stack;
        boolean prevAnyMeta = this.anyMeta;
        if (str.contains("<") && str.contains(">")) {
            String[] objects;
            String input = str.replaceAll("\\s+", "");
            int start = input.indexOf(60);
            int end = input.indexOf(62);
            if (end - start > 1 && (objects = input.substring(start + 1, end).split(":")) != null && objects.length > 1) {
                String sizeStr;
                int stackSize = 1;
                if (input.length() > end && (sizeStr = input.substring(end + 1)).startsWith("*")) {
                    stackSize = NumberUtils.toInt((String)sizeStr.substring(1), (int)stackSize);
                }
                int meta = objects.length > 2 ? NumberUtils.toInt((String)objects[2], (int)0) : 0;
                this.stack = GameRegistry.findItemStack((String)objects[0], (String)objects[1], (int)stackSize);
                if (this.stack != null && meta > -1) {
                    this.stack.func_77964_b(meta);
                } else if (meta == -1) {
                    this.anyMeta = true;
                }
            }
        }
        this.isValid = this.invalidate();
        if (!this.isValid) {
            if (withFallback) {
                this.stack = prevStack;
                this.anyMeta = prevAnyMeta;
                this.isValid = this.invalidate();
            } else {
                this.stack = null;
                this.anyMeta = false;
            }
        }
    }

    public String write() {
        if (this.stack != null && this.stack.func_77973_b() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append(Item.field_150901_e.func_148750_c((Object)this.stack.func_77973_b()));
            if (this.anyMeta) {
                builder.append(":*");
            } else if (this.stack.func_77960_j() != 0) {
                builder.append(":").append(this.stack.func_77960_j());
            }
            builder.append(">");
            if (this.stack.field_77994_a > 1) {
                builder.append(" * ").append(this.stack.field_77994_a);
            }
            return builder.toString();
        }
        return "<null>";
    }

    public boolean equalsInfo(InfoStack other, boolean deep) {
        if (other == null || !this.isValid || !other.isValid) {
            return false;
        }
        if ((this.anyMeta || other.anyMeta || this.stack.func_77960_j() == other.stack.func_77960_j()) && this.stack.func_77973_b() == other.stack.func_77973_b()) {
            return deep ? ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other.stack) : true;
        }
        return false;
    }

    public boolean equalsStack(ItemStack other, boolean deep) {
        return other != null ? Boolean.valueOf(this.equalsStack(other, other.func_77960_j(), deep)) : null;
    }

    public boolean equalsStack(ItemStack other, int meta, boolean deep) {
        if (!this.isValid || other == null) {
            return false;
        }
        if ((this.anyMeta || this.stack.func_77960_j() == meta) && this.stack.func_77973_b() == other.func_77973_b()) {
            return deep ? ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other) : true;
        }
        return false;
    }

    public boolean equalsItem(Item item) {
        return this.equalsItem(item, 0);
    }

    public boolean equalsItem(Item item, int meta) {
        if (!this.isValid || item == null) {
            return false;
        }
        return (this.anyMeta || this.stack.func_77960_j() == meta) && this.stack.func_77973_b() == item;
    }

    private boolean invalidate() {
        return this.stack != null && this.stack.field_77994_a > 0;
    }
}

