/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.inventory.FluidTank;
import by.fxg.basicfml.inventory.IFluidTankInventory;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class FluidTankInventory
implements IFluidTankInventory<FluidTank>,
Iterable<FluidTank> {
    public final FluidTank[] fluidTanks;
    protected FluidTankIterator iterator = null;

    public FluidTankInventory(int size) {
        this.fluidTanks = new FluidTank[size];
    }

    @Override
    public int getInventorySize() {
        return this.fluidTanks.length;
    }

    @Override
    public FluidTank getTankInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length ? this.fluidTanks[slot] : null;
    }

    @Override
    public Fluid getFluidInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getFluidObj() : null;
    }

    @Override
    public FluidStack getFluidStackInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getFluid() : null;
    }

    @Override
    public void setTankInSlot(int slot, FluidTank fluidTank) {
        if (slot > -1 && slot < this.fluidTanks.length) {
            this.fluidTanks[slot] = fluidTank;
        }
    }

    @Override
    public void setFluidStackInSlot(int slot, FluidStack fluidStack) {
        if (slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null) {
            this.fluidTanks[slot].setFluidStack(fluidStack);
        }
    }

    @Override
    public boolean isFluidValidForSlot(int slot, Fluid fluid) {
        return fluid != null && slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].isFluidValidForTank(fluid) : false;
    }

    @Override
    public boolean isFluidValidForSlot(int slot, FluidStack fluidStack) {
        return fluidStack != null && slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].isFluidValidForTank(fluidStack) : false;
    }

    @Override
    public boolean canFillTank(int slot, Fluid fluid) {
        return fluid != null && slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].canFill(fluid) : false;
    }

    @Override
    public boolean canDrainTank(int slot, Fluid fluid) {
        return fluid != null && slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].canDrain(fluid) : false;
    }

    @Override
    public int getFluidAmountInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getFluidAmount() : 0;
    }

    @Override
    public int getCapacityInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getCapacity() : 0;
    }

    @Override
    public boolean isTankFull(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].isFull() : false;
    }

    @Override
    public boolean isTankEmpty(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].isEmpty() : true;
    }

    @Override
    public FluidTankInfo[] getFluidTankInfo() {
        for (int i = 0; i != this.fluidTanks.length; ++i) {
            if (this.fluidTanks[i] == null) continue;
            TEMP_FLUIDTANKS_INFO.add(this.fluidTanks[i].getInfo());
        }
        FluidTankInfo[] infoArray = TEMP_FLUIDTANKS_INFO.toArray(new FluidTankInfo[TEMP_FLUIDTANKS_INFO.size()]);
        TEMP_FLUIDTANKS_INFO.clear();
        return infoArray;
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            FluidTank tank = this.getTankInSlot(i);
            if (tank == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            tank.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(name, (NBTBase)tagList);
    }

    public boolean readFromNBT(NBTTagCompound compound, String name) {
        if (!compound.func_74764_b(name)) {
            return false;
        }
        NBTTagList tagList = compound.func_150295_c(name, (int)compound.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot <= -1 || slot > this.getInventorySize()) continue;
            FluidTank tank = new FluidTank();
            tank.readFromNBT(tag);
            this.setTankInSlot(slot, tank);
        }
        return true;
    }

    @Override
    public Iterator<FluidTank> iterator() {
        if (this.iterator == null) {
            this.iterator = new FluidTankIterator(this);
        }
        this.iterator.prepare();
        return this.iterator;
    }

    public static class FluidTankIterator
    implements Iterator<FluidTank> {
        private final FluidTankInventory inventory;
        private int index = 0;

        public FluidTankIterator(FluidTankInventory inventory) {
            this.inventory = inventory;
        }

        public void prepare() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.inventory.fluidTanks.length > this.index;
        }

        @Override
        public FluidTank next() {
            return this.inventory.fluidTanks[this.index++];
        }

        @Override
        public void remove() {
            this.inventory.fluidTanks[this.index] = null;
        }
    }
}

