/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.inventory.IFluidTankInventory;
import java.util.Iterator;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.NotImplementedException;

public class GenericFluidTankInventory
implements IFluidTankInventory<IFluidTank>,
Iterable<IFluidTank> {
    public final IFluidTank[] fluidTanks;
    protected GenericFluidTankIterator iterator = null;

    public GenericFluidTankInventory(int size) {
        this.fluidTanks = new IFluidTank[size];
    }

    @Override
    public int getInventorySize() {
        return this.fluidTanks.length;
    }

    @Override
    public IFluidTank getTankInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length ? this.fluidTanks[slot] : null;
    }

    @Override
    public Fluid getFluidInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null && this.fluidTanks[slot].getFluid() != null ? this.fluidTanks[slot].getFluid().getFluid() : null;
    }

    @Override
    public FluidStack getFluidStackInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getFluid() : null;
    }

    @Override
    public void setTankInSlot(int slot, IFluidTank fluidTank) {
        if (slot > -1 && slot < this.fluidTanks.length) {
            this.fluidTanks[slot] = fluidTank;
        }
    }

    @Override
    @Deprecated
    public void setFluidStackInSlot(int slot, FluidStack fluidStack) {
        throw new NotImplementedException("Not implemented. (Impossible)");
    }

    @Override
    public boolean isFluidValidForSlot(int slot, Fluid fluid) {
        return true;
    }

    @Override
    public boolean isFluidValidForSlot(int slot, FluidStack fluidStack) {
        return true;
    }

    @Override
    public boolean canFillTank(int slot, Fluid fluid) {
        if (fluid != null && slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null && this.fluidTanks[slot].getFluid() != null) {
            return this.fluidTanks[slot].getFluid().getFluidID() == fluid.getID() && this.fluidTanks[slot].getFluidAmount() < this.fluidTanks[slot].getCapacity();
        }
        return false;
    }

    @Override
    public boolean canDrainTank(int slot, Fluid fluid) {
        if (fluid != null && slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null && this.fluidTanks[slot].getFluid() != null) {
            return this.fluidTanks[slot].getFluid().getFluidID() == fluid.getID() && this.fluidTanks[slot].getFluidAmount() > 0;
        }
        return false;
    }

    @Override
    public int getFluidAmountInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getFluidAmount() : 0;
    }

    @Override
    public int getCapacityInSlot(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getCapacity() : 0;
    }

    @Override
    public boolean isTankFull(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getFluidAmount() >= this.fluidTanks[slot].getCapacity() : false;
    }

    @Override
    public boolean isTankEmpty(int slot) {
        return slot > -1 && slot < this.fluidTanks.length && this.fluidTanks[slot] != null ? this.fluidTanks[slot].getCapacity() < 1 : true;
    }

    @Override
    public FluidTankInfo[] getFluidTankInfo() {
        for (int i = 0; i != this.fluidTanks.length; ++i) {
            if (this.fluidTanks[i] == null) continue;
            TEMP_FLUIDTANKS_INFO.add(this.fluidTanks[i].getInfo());
        }
        FluidTankInfo[] infoArray = TEMP_FLUIDTANKS_INFO.toArray(new FluidTankInfo[TEMP_FLUIDTANKS_INFO.size()]);
        TEMP_FLUIDTANKS_INFO.clear();
        return infoArray;
    }

    @Override
    public Iterator<IFluidTank> iterator() {
        if (this.iterator == null) {
            this.iterator = new GenericFluidTankIterator(this);
        }
        this.iterator.prepare();
        return this.iterator;
    }

    public static class GenericFluidTankIterator
    implements Iterator<IFluidTank> {
        private final GenericFluidTankInventory inventory;
        private int index = 0;

        public GenericFluidTankIterator(GenericFluidTankInventory inventory) {
            this.inventory = inventory;
        }

        public void prepare() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.inventory.fluidTanks.length > this.index;
        }

        @Override
        public IFluidTank next() {
            return this.inventory.fluidTanks[this.index++];
        }

        @Override
        public void remove() {
            this.inventory.fluidTanks[this.index] = null;
        }
    }
}

