/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.inventory;

import by.fxg.basicfml.inventory.Inventory;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.NotImplementedException;

public class InventoryCollection
extends Inventory
implements Collection<ItemStack> {
    public InventoryCollection(int size) {
        super(null, size);
    }

    public InventoryCollection(String name, int size) {
        super(name, size);
    }

    @Override
    public int size() {
        return this.stacks.length;
    }

    @Override
    public boolean isEmpty() {
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            if (this.stacks[slot] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof ItemStack) {
            int slot;
            for (slot = 0; slot != this.stacks.length; ++slot) {
                if (this.stacks[slot] != object) continue;
                return true;
            }
            for (slot = 0; slot != this.stacks.length; ++slot) {
                if (!ItemStack.func_77989_b((ItemStack)this.stacks[slot], (ItemStack)((ItemStack)object))) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack[] toArray() {
        return this.stacks;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new NotImplementedException("What in the hell you wanna do?");
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            if (this.stacks[slot] != null) continue;
            this.stacks[slot] = stack;
            return true;
        }
        boolean hasChanges = false;
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            ItemStack iterable = this.stacks[slot];
            if (iterable == null || iterable.field_77994_a >= iterable.func_77976_d() || !iterable.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)iterable, (ItemStack)stack)) continue;
            int decrStackSize = Math.min(iterable.func_77976_d() - iterable.field_77994_a, stack.field_77994_a);
            iterable.field_77994_a += decrStackSize;
            stack.field_77994_a -= decrStackSize;
            hasChanges = true;
            if (stack.field_77994_a < 1) break;
        }
        return hasChanges;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof ItemStack) {
            int slot;
            for (slot = 0; slot != this.stacks.length; ++slot) {
                if (this.stacks[slot] != object) continue;
                this.stacks[slot] = null;
                return true;
            }
            for (slot = 0; slot != this.stacks.length; ++slot) {
                if (!ItemStack.func_77989_b((ItemStack)this.stacks[slot], (ItemStack)((ItemStack)object))) continue;
                this.stacks[slot] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            if (collection.contains(this.stacks[slot])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ItemStack> collection) {
        boolean hasChanges = false;
        Iterator<? extends ItemStack> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            hasChanges = true;
        }
        return hasChanges;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean hasChanges = false;
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            if (!collection.contains(this.stacks[slot])) continue;
            this.stacks[slot] = null;
            hasChanges = true;
        }
        return hasChanges;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean hasChanges = false;
        for (int slot = 0; slot != this.stacks.length; ++slot) {
            if (collection.contains(this.stacks[slot])) continue;
            this.stacks[slot] = null;
            hasChanges = true;
        }
        return hasChanges;
    }
}

