/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.math;

import by.fxg.basicfml.math.Vector2;

public class Rectangle {
    public static final Rectangle tmp = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float width;
    public float height;

    public Rectangle() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Rectangle(Vector2 position, Vector2 size) {
        this(position.x, position.y, size.x, size.y);
    }

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle set(Vector2 position, Vector2 size) {
        return this.set(position.x, position.y, size.x, size.y);
    }

    public Rectangle set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public boolean overlaps(Rectangle rectangle) {
        return this.overlaps(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean overlaps(float x, float y, float width, float height) {
        return this.x < x + width && this.x + this.width > x && this.y < y + height && this.y + this.height > y;
    }

    public boolean overlaps(Vector2 vec) {
        return this.overlaps(vec.x, vec.y);
    }

    public boolean overlaps(float x, float y) {
        return this.x <= x && x <= this.x + this.width && this.y < y && y < this.y + this.height;
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(float x, float y, float width, float height) {
        return this.x < x && x < this.x + this.width && this.x < x + width && x + width < this.x + this.width && this.y < y && y < this.y + this.height && this.y < y + height && y + height < this.y + this.height;
    }

    public Vector2 extractPosition(Vector2 vec) {
        return vec.set(this.x, this.y);
    }

    public Vector2 extractSize(Vector2 vec) {
        return vec.set(this.width, this.height);
    }

    public Vector2 extractCenter(Vector2 vec) {
        return vec.set(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    public String toString() {
        return "Rectangle[" + this.x + ";" + this.y + ";" + this.width + ";" + this.height + "]";
    }
}

