/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.gui;

import betterachievements.api.components.achievement.ICustomBackgroundColour;
import betterachievements.api.components.achievement.ICustomIconRenderer;
import betterachievements.api.components.achievement.ICustomTooltip;
import betterachievements.api.components.page.ICustomArrows;
import betterachievements.api.components.page.ICustomBackground;
import betterachievements.api.components.page.ICustomPosition;
import betterachievements.api.components.page.ICustomScale;
import betterachievements.api.util.ColourHelper;
import betterachievements.gui.GuiAchievementsOld;
import betterachievements.handler.MessageHandler;
import betterachievements.handler.message.AchievementUnlockMessage;
import betterachievements.reference.Resources;
import betterachievements.registry.AchievementRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.AchievementPage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBetterAchievements
extends GuiScreen {
    private static final int blockSize = 16;
    private static final int maxTabs = 9;
    private static final int lineSize = 12;
    private static final int defaultTooltipWidth = 120;
    private static final int arrowHeadWidth = 11;
    private static final int arrowHeadHeight = 7;
    private static final int arrowOffset = 5;
    private static final int arrowRightX = 114;
    private static final int arrowRightY = 234;
    private static final int arrowLeftX = 107;
    private static final int arrowLeftY = 234;
    private static final int arrowDownX = 96;
    private static final int arrowDownY = 234;
    private static final int arrowUpX = 96;
    private static final int arrowUpY = 241;
    private static final int achievementX = 0;
    private static final int achievementY = 202;
    private static final int achievementTooltipOffset = 3;
    private static final int achievementTextureSize = 26;
    private static final int achievementOffset = 2;
    private static final int achievementSize = 24;
    private static final int achievementInnerSize = 22;
    private static final int buttonDone = 1;
    private static final int buttonOld = 2;
    private static final int buttonPrev = 3;
    private static final int buttonNext = 4;
    private static final int buttonOffsetX = 24;
    private static final int buttonOffsetY = 92;
    private static final int guiWidth = 252;
    private static final int guiHeight = 202;
    private static final int tabWidth = 28;
    private static final int tabHeight = 32;
    private static final int borderWidthX = 8;
    private static final int borderWidthY = 17;
    private static final int tabOffsetX = 0;
    private static final int tabOffsetY = -12;
    private static final int innerWidth = 228;
    private static final int innerHeight = 158;
    private static final int minDisplayColumn = AchievementList.field_76010_a * 24 - 240;
    private static final int minDisplayRow = AchievementList.field_76008_b * 24 - 240;
    private static final int maxDisplayColumn = AchievementList.field_76009_c * 24;
    private static final int maxDisplayRow = AchievementList.field_76006_d * 24;
    private static final float scaleJump = 0.25f;
    private static final float minZoom = 1.0f;
    private static final float maxZoom = 2.0f;
    private static final Random random = new Random();
    public static int colourUnlocked;
    public static int colourCanUnlock;
    public static int colourCantUnlock;
    public static boolean scrollButtons;
    public static boolean iconReset;
    public static boolean userColourOverride;
    public static boolean colourUnlockedRainbow;
    public static boolean colourCanUnlockRainbow;
    public static boolean colourCantUnlockRainbow;
    public static float[] colourUnlockedRainbowSettings;
    public static float[] colourCanUnlockRainbowSettings;
    public static float[] colourCantUnlockRainbowSettings;
    private GuiScreen prevScreen;
    private StatFileWriter statFileWriter;
    private int top;
    private int left;
    private float scale;
    private boolean pause;
    private boolean newDrag;
    private int prevMouseX;
    private int prevMouseY;
    private List<AchievementPage> pages;
    private int currentPage;
    private int tabsOffset;
    private static int lastPage;
    private int xPos;
    private int yPos;
    private Achievement hoveredAchievement;

    public GuiBetterAchievements(GuiScreen currentScreen, int page) {
        this.prevScreen = currentScreen;
        this.currentPage = page == 0 ? lastPage : page;
        this.statFileWriter = Minecraft.func_71410_x().field_71439_g.func_146107_m();
        this.pause = true;
    }

    public void func_73866_w_() {
        AchievementPage page;
        this.left = (this.field_146294_l - 252) / 2;
        this.top = (this.field_146295_m - 202) / 2;
        this.scale = 1.0f;
        this.xPos = 72;
        this.yPos = 24;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 24, this.field_146295_m / 2 + 92, 80, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.left + 24, this.field_146295_m / 2 + 92, 125, 20, I18n.func_135052_a((String)"betterachievements.gui.old", (Object[])new Object[0])));
        if (scrollButtons) {
            this.field_146292_n.add(new GuiButton(3, this.left - 24, this.top - 5, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(4, this.left + 256, this.top - 5, 20, 20, ">"));
        }
        this.hoveredAchievement = null;
        this.pages = AchievementRegistry.instance().getAllPages();
        int n = this.tabsOffset = this.currentPage < 6 ? 0 : this.currentPage - 6;
        if (this.tabsOffset < 0) {
            this.tabsOffset = 0;
        }
        if ((page = this.pages.get(this.currentPage)) instanceof ICustomScale) {
            this.scale = ((ICustomScale)page).setScale();
        }
        if (page instanceof ICustomPosition) {
            Achievement center = ((ICustomPosition)page).setPositionOnLoad();
            this.xPos = center.field_75993_a * 24 + 72;
            this.yPos = center.field_75991_b * 24 + 24;
        }
    }

    public void func_146281_b() {
        lastPage = this.currentPage;
    }

    protected void func_73869_a(char c, int i) {
        if (i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else if (i == 203) {
            --this.currentPage;
            if (this.currentPage < 0) {
                this.currentPage = this.pages.size() - 1;
                this.tabsOffset += this.pages.size() / 9 * 9;
            }
            if (this.currentPage - this.tabsOffset < 0) {
                this.tabsOffset -= 9;
            }
            if (this.tabsOffset < 0) {
                this.tabsOffset = 0;
            }
        } else if (i == 205) {
            ++this.currentPage;
            if (this.currentPage >= this.pages.size()) {
                this.currentPage = 0;
                this.tabsOffset = 0;
            }
            if (this.currentPage - this.tabsOffset >= 9) {
                this.tabsOffset += 9;
            }
            if (this.pages.size() <= this.tabsOffset) {
                this.tabsOffset = this.pages.size() - 1;
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiAchievementsOld(this.prevScreen, this.statFileWriter));
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a(this.prevScreen);
                break;
            }
            case 3: {
                this.tabsOffset -= 9;
                if (this.tabsOffset == -9) {
                    this.tabsOffset = this.pages.size() - 6;
                    break;
                }
                if (this.tabsOffset >= 0) break;
                this.tabsOffset = 0;
                break;
            }
            case 4: {
                this.tabsOffset += 9;
                if (this.tabsOffset > this.pages.size()) {
                    this.tabsOffset = 0;
                    break;
                }
                if (this.tabsOffset <= this.pages.size() - 6) break;
                this.tabsOffset = this.pages.size() - 6;
                break;
            }
        }
    }

    public boolean func_73868_f() {
        return this.pause;
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        this.func_146276_q_();
        AchievementPage page = this.pages.get(this.currentPage);
        this.handleMouseInput(mouseX, mouseY, page);
        this.drawUnselectedTabs(page);
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        this.drawAchievementsBackground(page);
        this.drawAchievements(page, mouseX, mouseY);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
        this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI.SPRITES);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.left, this.top + 16, 0, 0, 252, 202);
        this.drawCurrentTab(page);
        this.field_146289_q.func_78276_b(page.getName() + " " + I18n.func_135052_a((String)"gui.achievements", (Object[])new Object[0]), this.left + 15, this.top + 16 + 5, 0x404040);
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
        this.drawMouseOverAchievement(mouseX, mouseY);
        this.drawMouseOverTab(mouseX, mouseY);
    }

    private void handleMouseInput(int mouseX, int mouseY, AchievementPage page) {
        this.doDrag(mouseX, mouseY);
        if (this.onTab(mouseX, mouseY) != -1) {
            this.doTabScroll();
        } else {
            this.doZoom(page);
        }
        if (this.xPos < minDisplayColumn) {
            this.xPos = minDisplayColumn;
        }
        if (this.xPos > maxDisplayColumn) {
            this.xPos = maxDisplayColumn;
        }
        if (this.yPos < minDisplayRow) {
            this.yPos = minDisplayRow;
        }
        if (this.yPos > maxDisplayRow) {
            this.yPos = maxDisplayRow;
        }
        if (Mouse.isButtonDown((int)0)) {
            this.handleMouseClick(mouseX, mouseY);
        }
    }

    private void drawUnselectedTabs(AchievementPage selected) {
        for (int i = this.tabsOffset; i < 9 + this.tabsOffset && this.pages.size() > i; ++i) {
            AchievementPage page = this.pages.get(i);
            if (page == selected) continue;
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int j = (i - this.tabsOffset) * 28;
            this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI.TABS);
            this.func_73729_b(this.left + 0 + j, this.top + -12, j, 0, 28, 32);
            this.drawPageIcon(page, this.left + 0 + j, this.top + -12);
        }
    }

    private void drawCurrentTab(AchievementPage selected) {
        for (int i = this.tabsOffset; i < 9 + this.tabsOffset && this.pages.size() > i; ++i) {
            AchievementPage page = this.pages.get(i);
            if (page != selected) continue;
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int j = (i - this.tabsOffset) * 28;
            this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI.TABS);
            this.func_73729_b(this.left + 0 + j, this.top + -12, j, 32, 28, 32);
            this.drawPageIcon(page, this.left + 0 + j, this.top + -12);
        }
    }

    private void drawPageIcon(AchievementPage page, int tabLeft, int tabTop) {
        ItemStack itemStack = AchievementRegistry.instance().getItemStack(page);
        if (itemStack != null) {
            this.field_73735_i = 100.0f;
            GuiBetterAchievements.field_146296_j.field_77023_b = 100.0f;
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemStack, tabLeft + 6, tabTop + 9);
            GuiBetterAchievements.field_146296_j.field_77023_b = 0.0f;
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            this.field_73735_i = 0.0f;
        }
    }

    private void drawAchievementsBackground(AchievementPage page) {
        GL11.glTranslatef((float)this.left, (float)(this.top + 17), (float)-200.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        if (page instanceof ICustomBackground) {
            GL11.glPushMatrix();
            ((ICustomBackground)page).drawBackground(this.left, this.top, 236, 175, this.field_73735_i, this.scale);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            float scaleInverse = 1.0f / this.scale;
            GL11.glScalef((float)scaleInverse, (float)scaleInverse, (float)1.0f);
            float scale = 16.0f / this.scale;
            int dragX = this.xPos - minDisplayColumn >> 4;
            int dragY = this.yPos - minDisplayRow >> 4;
            int antiJumpX = (this.xPos - minDisplayColumn) % 16;
            int antiJumpY = (this.yPos - minDisplayRow) % 16;
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            int y = 1;
            while ((float)y * scale - (float)antiJumpY < 175.0f) {
                float darkness = 0.7f - (float)(dragY + y) / 80.0f;
                GL11.glColor4f((float)darkness, (float)darkness, (float)darkness, (float)1.0f);
                int x = 1;
                while ((float)x * scale - (float)antiJumpX < 236.0f) {
                    random.setSeed(this.field_146297_k.func_110432_I().func_148255_b().hashCode() + dragY + y + (dragX + x) * 16);
                    int r = random.nextInt(1 + dragY + y) + (dragY + y) / 2;
                    IIcon block = Blocks.field_150349_c.func_149691_a(0, 0);
                    if (r == 40) {
                        block = random.nextInt(3) == 0 ? Blocks.field_150482_ag.func_149691_a(0, 0) : Blocks.field_150450_ax.func_149691_a(0, 0);
                    } else if (r == 20) {
                        block = Blocks.field_150366_p.func_149691_a(0, 0);
                    } else if (r == 12) {
                        block = Blocks.field_150365_q.func_149691_a(0, 0);
                    } else if (r > 60) {
                        block = Blocks.field_150357_h.func_149691_a(0, 0);
                    } else if (r > 4) {
                        block = Blocks.field_150348_b.func_149691_a(0, 0);
                    } else if (r > 0) {
                        block = Blocks.field_150346_d.func_149691_a(0, 0);
                    }
                    this.func_94065_a(x * 16 - antiJumpX, y * 16 - antiJumpY, block, 16, 16);
                    ++x;
                }
                ++y;
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
    }

    private void drawArrow(Achievement achievement, int colourCantUnlock, int colourCanUnlock, int colourUnlocked) {
        int depth = this.statFileWriter.func_150874_c(achievement);
        if (depth < 5) {
            int achievementXPos = achievement.field_75993_a * 24 - this.xPos + 11;
            int achievementYPos = achievement.field_75991_b * 24 - this.yPos + 11;
            int parentXPos = achievement.field_75992_c.field_75993_a * 24 - this.xPos + 11;
            int parentYPos = achievement.field_75992_c.field_75991_b * 24 - this.yPos + 11;
            boolean unlocked = this.statFileWriter.func_77443_a(achievement);
            boolean canUnlock = this.statFileWriter.func_77442_b(achievement);
            int colour = colourCantUnlock;
            if (unlocked) {
                colour = colourUnlocked;
            } else if (canUnlock) {
                colour = colourCanUnlock;
            }
            this.func_73730_a(achievementXPos, parentXPos, achievementYPos, colour);
            this.func_73728_b(parentXPos, achievementYPos, parentYPos, colour);
            this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI.SPRITES);
            GL11.glEnable((int)3042);
            if (achievementXPos > parentXPos) {
                this.func_73729_b(achievementXPos - 11 - 7, achievementYPos - 5, 114, 234, 7, 11);
            } else if (achievementXPos < parentXPos) {
                this.func_73729_b(achievementXPos + 11, achievementYPos - 5, 107, 234, 7, 11);
            } else if (achievementYPos > parentYPos) {
                this.func_73729_b(achievementXPos - 5, achievementYPos - 11 - 7, 96, 234, 11, 7);
            } else if (achievementYPos < parentYPos) {
                this.func_73729_b(achievementXPos - 5, achievementYPos + 11, 96, 241, 11, 7);
            }
        }
    }

    private void drawAchievements(AchievementPage page, int mouseX, int mouseY) {
        int colourCanUnlock;
        int colourCantUnlock;
        LinkedList<Achievement> achievements = new LinkedList<Achievement>(AchievementRegistry.instance().getAchievements(page));
        boolean customColours = page instanceof ICustomArrows;
        int n = !userColourOverride && customColours ? ((ICustomArrows)page).getColourForCantUnlockArrow() : (colourCantUnlock = colourCantUnlockRainbow ? ColourHelper.getRainbowColour(colourCantUnlockRainbowSettings) : GuiBetterAchievements.colourCantUnlock);
        int n2 = !userColourOverride && customColours ? ((ICustomArrows)page).getColourForCanUnlockArrow() : (colourCanUnlock = colourCanUnlockRainbow ? ColourHelper.getRainbowColour(colourCanUnlockRainbowSettings) : GuiBetterAchievements.colourCanUnlock);
        int colourUnlocked = !userColourOverride && customColours ? ((ICustomArrows)page).getColourForUnlockedArrow() : (colourUnlockedRainbow ? ColourHelper.getRainbowColour(colourUnlockedRainbowSettings) : GuiBetterAchievements.colourUnlocked);
        Collections.reverse(achievements);
        GL11.glPushMatrix();
        float inverseScale = 1.0f / this.scale;
        GL11.glScalef((float)inverseScale, (float)inverseScale, (float)1.0f);
        for (Achievement achievement : achievements) {
            if (achievement.field_75992_c == null || !achievements.contains(achievement.field_75992_c)) continue;
            this.drawArrow(achievement, colourCantUnlock, colourCanUnlock, colourUnlocked);
        }
        for (Achievement achievement : achievements) {
            this.drawAchievement(achievement);
            if (!this.onAchievement(achievement, mouseX, mouseY)) continue;
            this.hoveredAchievement = achievement;
        }
        GL11.glPopMatrix();
    }

    private void drawAchievement(Achievement achievement) {
        float brightness;
        int achievementXPos = achievement.field_75993_a * 24 - this.xPos;
        int achievementYPos = achievement.field_75991_b * 24 - this.yPos;
        if (!this.onScreen(achievementXPos, achievementYPos)) {
            return;
        }
        int depth = this.statFileWriter.func_150874_c(achievement);
        boolean unlocked = this.statFileWriter.func_77443_a(achievement);
        boolean canUnlock = this.statFileWriter.func_77442_b(achievement);
        boolean special = achievement.func_75984_f();
        if (unlocked) {
            brightness = 0.75f;
        } else if (canUnlock) {
            brightness = 1.0f;
        } else if (depth < 3) {
            brightness = 0.3f;
        } else if (depth < 4) {
            brightness = 0.2f;
        } else if (depth < 5) {
            brightness = 0.1f;
        } else {
            return;
        }
        if (achievement instanceof ICustomBackgroundColour) {
            int colour = ((ICustomBackgroundColour)achievement).recolourBackground(brightness);
            GL11.glColor4f((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(Resources.GUI.SPRITES);
        GL11.glEnable((int)3042);
        if (special) {
            this.func_73729_b(achievementXPos - 2, achievementYPos - 2, 26, 202, 26, 26);
        } else {
            this.func_73729_b(achievementXPos - 2, achievementYPos - 2, 0, 202, 26, 26);
        }
        if (achievement instanceof ICustomIconRenderer) {
            GL11.glPushMatrix();
            ((ICustomIconRenderer)achievement).renderIcon(achievementXPos, achievementYPos);
            GL11.glPopMatrix();
        } else {
            RenderItem renderItem = new RenderItem();
            if (!canUnlock) {
                GL11.glColor4f((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
                renderItem.field_77024_a = false;
            }
            RenderHelper.func_74520_c();
            GL11.glEnable((int)2884);
            renderItem.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), achievement.field_75990_d, achievementXPos + 3, achievementYPos + 3);
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
    }

    private void drawMouseOverAchievement(int mouseX, int mouseY) {
        if (this.hoveredAchievement == null || !this.inInnerScreen(mouseX, mouseY)) {
            return;
        }
        if (Mouse.isButtonDown((int)1)) {
            this.pause = false;
            MessageHandler.INSTANCE.sendToServer((IMessage)new AchievementUnlockMessage(this.hoveredAchievement));
        } else {
            this.pause = true;
        }
        if (iconReset && Mouse.isButtonDown((int)2)) {
            AchievementRegistry.instance().registerIcon(this.pages.get(this.currentPage).getName(), this.hoveredAchievement.field_75990_d, true);
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 4;
        if (this.hoveredAchievement instanceof ICustomTooltip) {
            ((ICustomTooltip)this.hoveredAchievement).renderTooltip(mouseX, mouseY, this.statFileWriter);
        } else {
            String title = this.hoveredAchievement.func_150951_e().func_150260_c();
            String desc = this.hoveredAchievement.func_75989_e();
            int depth = this.statFileWriter.func_150874_c(this.hoveredAchievement);
            boolean unlocked = this.statFileWriter.func_77443_a(this.hoveredAchievement);
            boolean canUnlock = this.statFileWriter.func_77442_b(this.hoveredAchievement);
            boolean special = this.hoveredAchievement.func_75984_f();
            int tooltipWidth = 120;
            if (!canUnlock) {
                if (depth > 3) {
                    return;
                }
                desc = this.getChatComponentTranslation("achievement.requires", this.hoveredAchievement.field_75992_c.func_150951_e());
                if (depth == 3) {
                    title = I18n.func_135052_a((String)"achievement.unknown", (Object[])new Object[0]);
                }
            }
            tooltipWidth = Math.max(this.field_146289_q.func_78256_a(title), tooltipWidth);
            int tooltipHeight = this.field_146289_q.func_78267_b(desc, tooltipWidth);
            if (unlocked) {
                tooltipHeight += 12;
            }
            this.func_73733_a(tooltipX - 3, tooltipY - 3, tooltipX + tooltipWidth + 3, tooltipY + tooltipHeight + 3 + 12, -1073741824, -1073741824);
            this.field_146289_q.func_78261_a(title, tooltipX, tooltipY, canUnlock ? (special ? -128 : -1) : (special ? -8355776 : -8355712));
            this.field_146289_q.func_78279_b(desc, tooltipX, tooltipY + 12, tooltipWidth, -6250336);
            if (unlocked) {
                this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"achievement.taken", (Object[])new Object[0]), tooltipX, tooltipY + tooltipHeight + 4, -7302913);
            }
        }
        this.hoveredAchievement = null;
    }

    private void drawMouseOverTab(int mouseX, int mouseY) {
        int onTab = this.onTab(mouseX, mouseY);
        if (onTab == -1 || this.pages.size() <= onTab) {
            return;
        }
        AchievementPage page = this.pages.get(onTab);
        LinkedList<String> tooltip = new LinkedList<String>();
        tooltip.add(page.getName());
        this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
    }

    private void handleMouseClick(int mouseX, int mouseY) {
        int onTab = this.onTab(mouseX, mouseY);
        if (onTab == -1 || this.pages.size() <= onTab || this.currentPage == onTab) {
            return;
        }
        this.currentPage = onTab;
        AchievementPage page = this.pages.get(this.currentPage);
        if (page instanceof ICustomScale && ((ICustomScale)page).resetScaleOnLoad()) {
            this.scale = ((ICustomScale)page).setScale();
        }
        if (page instanceof ICustomPosition) {
            Achievement center = ((ICustomPosition)page).setPositionOnLoad();
            this.xPos = center.field_75993_a * 24 + 72;
            this.yPos = center.field_75991_b * 24 + 24;
        }
    }

    private void doTabScroll() {
        int dWheel = Mouse.getDWheel();
        if (dWheel < 0) {
            --this.tabsOffset;
        } else if (dWheel > 0) {
            ++this.tabsOffset;
        }
        if (this.tabsOffset > this.pages.size() - 6) {
            this.tabsOffset = this.pages.size() - 6;
        }
        if (this.tabsOffset < 0) {
            this.tabsOffset = 0;
        }
    }

    private void doZoom(AchievementPage page) {
        int dWheel = Mouse.getDWheel();
        float prevScale = this.scale;
        if (dWheel < 0) {
            this.scale += 0.25f;
        } else if (dWheel > 0) {
            this.scale -= 0.25f;
        }
        boolean customScale = page instanceof ICustomScale;
        float minZoom = customScale ? ((ICustomScale)page).getMinScale() : 1.0f;
        float maxZoom = customScale ? ((ICustomScale)page).getMaxScale() : 2.0f;
        this.scale = MathHelper.func_76131_a((float)this.scale, (float)minZoom, (float)maxZoom);
        if (this.scale != prevScale) {
            float prevScaledWidth = prevScale * (float)this.field_146294_l;
            float prevScaledHeight = prevScale * (float)this.field_146295_m;
            float newScaledWidth = this.scale * (float)this.field_146294_l;
            float newScaledHeight = this.scale * (float)this.field_146295_m;
            this.xPos = (int)((float)this.xPos - (newScaledWidth - prevScaledWidth) / 2.0f);
            this.yPos = (int)((float)this.yPos - (newScaledHeight - prevScaledHeight) / 2.0f);
        }
    }

    private void doDrag(int mouseX, int mouseY) {
        if (Mouse.isButtonDown((int)0)) {
            if (this.inInnerScreen(mouseX, mouseY)) {
                if (this.newDrag) {
                    this.newDrag = false;
                } else {
                    this.xPos = (int)((float)this.xPos - (float)(mouseX - this.prevMouseX) * this.scale);
                    this.yPos = (int)((float)this.yPos - (float)(mouseY - this.prevMouseY) * this.scale);
                }
                this.prevMouseX = mouseX;
                this.prevMouseY = mouseY;
            }
        } else {
            this.newDrag = true;
        }
    }

    private boolean inInnerScreen(int mouseX, int mouseY) {
        return mouseX > this.left + 8 && mouseX < this.left + 252 - 8 && mouseY > this.top + 17 && mouseY < this.top + 202 - 17;
    }

    private boolean onAchievement(Achievement achievement, int mouseX, int mouseY) {
        int achievementXPos = achievement.field_75993_a * 24 - this.xPos;
        int achievementYPos = achievement.field_75991_b * 24 - this.yPos + 22;
        return (float)mouseX > (float)this.left + (float)achievementXPos / this.scale && (float)mouseX < (float)this.left + (float)(achievementXPos + 22) / this.scale && (float)mouseY > (float)this.top + (float)achievementYPos / this.scale && (float)mouseY < (float)this.top + (float)(achievementYPos + 22) / this.scale;
    }

    private int onTab(int mouseX, int mouseY) {
        if (mouseX > this.left + 0 && mouseX < this.left + 252 && mouseY > this.top + -12 && mouseY < this.top + -12 + 32) {
            return (mouseX - (this.left + 0)) / 28 + this.tabsOffset;
        }
        return -1;
    }

    private boolean onScreen(int x, int y) {
        return x > 0 && (float)x < 252.0f * this.scale - 24.0f && y > 0 && (float)y < 202.0f * this.scale - 24.0f;
    }

    private String getChatComponentTranslation(String s, Object ... objects) {
        return new ChatComponentTranslation(s, objects).func_150261_e();
    }

    static {
        lastPage = 0;
    }
}

