/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.compat;

import codechicken.nei.api.GuiInfo;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.google.common.collect.Maps;
import com.pahimar.ee3.api.exchange.RecipeRegistryProxy;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import team.chisel.carving.Carving;
import team.chisel.client.gui.GuiChisel;
import team.chisel.utils.RecipeUtil;

public class Compatibility {
    public static String[] rockColorNames = new String[]{"gray", "lightgray", "brown", "tan", "reddish", "bluish", "greenish"};
    public static Map<Integer, String> tconMap = Maps.newHashMap();

    public static void init(FMLPostInitializationEvent event) {
        Compatibility.addSupport("ProjRed|Exploration", "projectred.exploration.stone", "marble", 0, 99);
        Compatibility.addSupport("ProjRed|Exploration", "projectred.exploration.stone", "marble", 1, 99);
        Compatibility.addSupport("bluepower", "marble", "marble", 0, 99);
        Compatibility.addSupport("Artifice", "artifice.marble", "marble", 0, 99);
        Compatibility.addSupport("Artifice", "artifice.marble.slab", "marble_slab", 0, 99);
        for (String s : rockColorNames) {
            Compatibility.addSupport("Artifice", "artifice.limestone." + s, "limestone", 0, 99);
        }
        Block block = GameRegistry.findBlock((String)"mariculture", (String)"limestone");
        if (block != null) {
            for (int i = 0; i < 16; ++i) {
                Compatibility.addSupport("limestone", block, i, 99);
            }
        }
        Compatibility.addSupport("PFAAGeologica", "strongStone", "marble", 5, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneSlab", "marbleSlab", 5, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneBrickStairs.marble", "marbleStairs", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStone", "limestone", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStoneSlab", "limestoneSlab", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "mediumStoneBrickStairs.limestone", "limestoneStairs", 0, 99);
        Compatibility.addSupport("PFAAGeologica", "strongStoneBrick", "stoneBrick", 3, 99);
        Compatibility.addSupport("PFAAGeologica", "strongCobble", "cobblestone", 3, 99);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            Compatibility.loadThaumcraftAspects();
        }
        for (Integer i : tconMap.keySet()) {
            Compatibility.addSupport("TConstruct", "decoration.multibrick", tconMap.get(i), i, 99);
            Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", tconMap.get(i), i, 99);
        }
        Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", "stonebricksmooth", 14, 99);
        Compatibility.addSupport("TConstruct", "decoration.multibrickfancy", "stonebricksmooth", 15, 99);
        Compatibility.addSupport("Botania", "endStoneBrick", "end_stone", 0, 0);
        Compatibility.addSupport("Botania", "endStoneBrick", "end_stone", 1, 0);
        if (Loader.isModLoaded((String)"EE3")) {
            Compatibility.loadEE3Values();
        }
        if (Loader.isModLoaded((String)"NotEnoughItems") && event.getSide() == Side.CLIENT) {
            GuiInfo.customSlotGuis.add(GuiChisel.class);
        }
    }

    public static void addSupport(String modname, String blockname, String name, int metadata, int order) {
        if (Loader.isModLoaded((String)modname) && GameRegistry.findBlock((String)modname, (String)blockname) != null) {
            Compatibility.addSupport(name, GameRegistry.findBlock((String)modname, (String)blockname), metadata, order);
        }
    }

    public static void addSupport(String name, Block block, int metadata, int order) {
        Carving.chisel.addVariation(name, block, metadata, order);
    }

    private static void loadThaumcraftAspects() {
    }

    private static void loadEE3Values() {
        for (String groupName : Carving.chisel.getSortedGroupNames()) {
            ICarvingGroup group = Carving.chisel.getGroup(groupName);
            ArrayList<ItemStack> baseStacks = new ArrayList<ItemStack>();
            for (ICarvingVariation variation : group.getVariations()) {
                if (!RecipeUtil.isCreatable(new ItemStack(variation.getBlock(), 1, variation.getBlockMeta()))) continue;
                baseStacks.add(new ItemStack(variation.getBlock(), 1, variation.getBlockMeta()));
            }
            for (ICarvingVariation variation : group.getVariations()) {
                ItemStack stack = new ItemStack(variation.getBlock(), 1, variation.getBlockMeta());
                for (ItemStack baseStack : baseStacks) {
                    RecipeRegistryProxy.addRecipe((Object)stack, Arrays.asList(baseStack));
                }
            }
        }
    }

    static {
        tconMap.put(0, "obsidian");
        tconMap.put(1, "sandstone");
        tconMap.put(2, "netherrack");
        tconMap.put(3, "stonebricksmooth");
        tconMap.put(12, "end_stone");
    }
}

