/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.asm;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.bugfix.SafeFMLLog;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class FMLLogTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (name.equals("cpw.mods.fml.common.FMLLog")) {
            return FMLLogTransformer.transformFMLLog(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformFMLLog(byte[] bytes) {
        CoreTweaks.LOGGER.info("Transforming FMLLog#log to fix ClassNotFoundError when logging throwables");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("log") || !m.desc.equals("(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V") && !m.desc.equals("(Lorg/apache/logging/log4j/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V")) continue;
            AbstractInsnNode injectionTarget = null;
            for (int i = 0; i < m.instructions.size(); ++i) {
                MethodInsnNode min;
                AbstractInsnNode ain = m.instructions.get(i);
                if (!(ain instanceof MethodInsnNode) || (min = (MethodInsnNode)ain).getOpcode() != 184 || !min.owner.equals("cpw/mods/fml/relauncher/FMLRelaunchLog") || !min.name.equals("log") || !min.desc.equals(m.desc)) continue;
                injectionTarget = ain;
                break;
            }
            if (injectionTarget == null) continue;
            m.instructions.insertBefore(injectionTarget, (AbstractInsnNode)new FieldInsnNode(178, "cpw/mods/fml/common/FMLLog", "coreLog", "Lcpw/mods/fml/relauncher/FMLRelaunchLog;"));
            m.instructions.set(injectionTarget, (AbstractInsnNode)new MethodInsnNode(184, "makamys/coretweaks/asm/FMLLogTransformer$Hooks", "redirectLog", m.desc.replace(")", "Lcpw/mods/fml/relauncher/FMLRelaunchLog;)"), false));
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static class Hooks {
        public static void redirectLog(String targetLog, Level level, Throwable ex, String format, Object[] data, FMLRelaunchLog coreLog) {
            SafeFMLLog.log(coreLog, targetLog, level, ex, format, data);
        }

        public static void redirectLog(Level level, Throwable ex, String format, Object[] data, FMLRelaunchLog coreLog) {
            SafeFMLLog.log(coreLog, level, ex, format, data);
        }
    }
}

