/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.asm;

import java.io.File;
import java.util.List;
import java.util.ListIterator;
import makamys.coretweaks.CoreTweaks;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ModDiscovererTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals("cpw.mods.fml.common.discovery.ModDiscoverer")) {
            basicClass = ModDiscovererTransformer.doTransform(basicClass);
        }
        return basicClass;
    }

    private static byte[] doTransform(byte[] bytes) {
        CoreTweaks.LOGGER.info("Transforming ModDiscoverer to skip known libraries");
        boolean found = false;
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            block2: for (MethodNode m : classNode.methods) {
                if (!m.name.equals("findClasspathMods")) continue;
                ListIterator it = m.instructions.iterator();
                AbstractInsnNode lastInsn = null;
                while (it.hasNext()) {
                    AbstractInsnNode i = (AbstractInsnNode)it.next();
                    if (i.getOpcode() == 185) {
                        MethodInsnNode im = (MethodInsnNode)i;
                        if (im.owner.equals("java/util/List") && im.name.equals("contains") && im.desc.equals("(Ljava/lang/Object;)Z") && lastInsn.getOpcode() == 182) {
                            MethodInsnNode lim = (MethodInsnNode)lastInsn;
                            if (lim.owner.equals("java/io/File") && lim.name.equals("getName") && lim.desc.equals("()Ljava/lang/String;")) {
                                m.instructions.insertBefore((AbstractInsnNode)lim, (AbstractInsnNode)new InsnNode(89));
                                InsnList callRedirectContains = new InsnList();
                                callRedirectContains.add((AbstractInsnNode)new InsnNode(95));
                                callRedirectContains.add((AbstractInsnNode)new MethodInsnNode(184, "makamys/coretweaks/asm/ModDiscovererTransformer", "redirectKnownLibrariesContains", "(Ljava/util/List;Ljava/lang/String;Ljava/io/File;)Z", false));
                                m.instructions.insertBefore((AbstractInsnNode)im, callRedirectContains);
                                it.remove();
                                found = true;
                                continue block2;
                            }
                        }
                    }
                    lastInsn = i;
                }
            }
            if (found) {
                ClassWriter writer = new ClassWriter(0);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            CoreTweaks.LOGGER.info("Couldn't find target instructions");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static boolean redirectKnownLibrariesContains(List<String> list, String obj, File file) {
        assert (file.getName().equals(obj));
        return list.contains(obj) || ModDiscovererTransformer.isDefaultLibrary(file);
    }

    private static boolean isDefaultLibrary(File file) {
        String[] prefixes;
        String home = System.getProperty("java.home");
        if (home != null && file.getAbsolutePath().startsWith(home)) {
            return true;
        }
        String name = file.getName();
        if (!name.endsWith(".jar")) {
            return false;
        }
        for (String s : prefixes = new String[]{"launchwrapper-", "asm-all-", "akka-actor_2.11-", "config-", "scala-", "jopt-simple-", "lzma-", "realms-", "httpclient-", "httpcore-", "vecmath-", "trove4j-", "icu4j-core-mojang-", "codecjorbis-", "codecwav-", "libraryjavawound-", "librarylwjglopenal-", "soundsystem-", "netty-all-", "guava-", "commons-lang3-", "commons-compress-", "commons-logging-", "commons-io-", "commons-codec-", "jinput-", "jutils-", "gson-", "authlib-", "log4j-api-", "log4j-core-", "lwjgl-", "lwjgl_util-", "twitch-", "jline-", "jna-", "platform-", "oshi-core-", "netty-", "libraryjavasound-", "fastutil-", "lombok-"}) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

