/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.ducks.optimization.IPendingBlockUpdatesWorldServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.NextTickListEntry;

public class ChunkPendingBlockUpdateMap {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("coretweaks.optimizeGetPendingBlockUpdates.debug", "false"));
    public static final boolean LENIENT_MODE = Boolean.parseBoolean(System.getProperty("coretweaks.optimizeGetPendingBlockUpdates.lenient", "false"));

    public static void add(IPendingBlockUpdatesWorldServer ws, NextTickListEntry e) {
        long key;
        Map<Long, Set<NextTickListEntry>> map = ws.crtw$getChunkPendingUpdatesMap();
        Set<NextTickListEntry> chunkSet = map.get(key = ChunkCoordIntPair.func_77272_a((int)(e.field_77183_a >> 4), (int)(e.field_77182_c >> 4)));
        if (chunkSet == null) {
            chunkSet = new TreeSet<NextTickListEntry>();
            map.put(key, chunkSet);
        }
        chunkSet.add(e);
    }

    public static void remove(IPendingBlockUpdatesWorldServer ws, NextTickListEntry o) {
        Map<Long, Set<NextTickListEntry>> map = ws.crtw$getChunkPendingUpdatesMap();
        NextTickListEntry e = o;
        long key = ChunkCoordIntPair.func_77272_a((int)(e.field_77183_a >> 4), (int)(e.field_77182_c >> 4));
        Set<NextTickListEntry> chunkSet = map.get(key);
        if (chunkSet != null) {
            chunkSet.remove(e);
            if (chunkSet.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public static Set<NextTickListEntry> get(IPendingBlockUpdatesWorldServer ws, int cx, int cz) {
        Map<Long, Set<NextTickListEntry>> map = ws.crtw$getChunkPendingUpdatesMap();
        long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
        return map.get(key);
    }

    public static void removeKey(IPendingBlockUpdatesWorldServer ws, int cx, int cz) {
        Map<Long, Set<NextTickListEntry>> map = ws.crtw$getChunkPendingUpdatesMap();
        long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
        map.remove(key);
    }

    public static boolean isEmpty(IPendingBlockUpdatesWorldServer ws) {
        Map<Long, Set<NextTickListEntry>> map = ws.crtw$getChunkPendingUpdatesMap();
        return map == null || map.isEmpty();
    }

    public static void onTick(IPendingBlockUpdatesWorldServer ws) {
        if (DEBUG) {
            Map<Long, Set<NextTickListEntry>> map = ws.crtw$getChunkPendingUpdatesMap();
            Iterator<Map.Entry<Long, Set<NextTickListEntry>>> it = map.entrySet().iterator();
            String debug = "";
            while (it.hasNext()) {
                Map.Entry<Long, Set<NextTickListEntry>> e = it.next();
                long k = e.getKey();
                int cx = ChunkPendingBlockUpdateMap.chunkCoordPairToX(k);
                int cz = ChunkPendingBlockUpdateMap.chunkCoordPairToZ(k);
                debug = debug + "(" + cx + ", " + cz + "), ";
            }
            if (map.size() > 0) {
                CoreTweaks.LOGGER.info(map.size() + ": " + debug);
            }
        }
    }

    private static int chunkCoordPairToX(long pair) {
        return (int)(pair & 0xFFFFFFFFL);
    }

    private static int chunkCoordPairToZ(long pair) {
        return (int)(pair >> 32 & 0xFFFFFFFFL);
    }

    public static void onError() {
        System.out.println("ERROR");
    }
}

