/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import cpw.mods.fml.common.discovery.asm.ASMModParser;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.IModEventListener;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Kryo;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Serializer;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Input;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Output;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.objenesis.strategy.StdInstantiatorStrategy;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeInput;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeOutput;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util.DefaultInstantiatorStrategy;
import makamys.coretweaks.util.Util;
import org.objectweb.asm.Type;

public class JarDiscovererCache
implements IModEventListener {
    public static JarDiscovererCache instance;
    private boolean hasLoaded;
    private Map<String, CachedModInfo> cache = new HashMap<String, CachedModInfo>();
    private int epoch;
    private final byte MAGIC_0 = 0;
    private final byte VERSION = (byte)2;
    private final File DAT_OLD = Util.childFile(CoreTweaks.CACHE_DIR, "jarDiscovererCache.dat");
    private final File DAT = Util.childFile(CoreTweaks.CACHE_DIR, "jarDiscoverer.cache");
    private final File DAT_ERRORED = Util.childFile(CoreTweaks.CACHE_DIR, "jarDiscoverer.cache.errored");
    private Kryo kryo;

    public void load() {
        CoreTweaks.LOGGER.info("Loading JarDiscovererCache");
        long t0 = System.nanoTime();
        this.kryo = new Kryo();
        this.kryo.setInstantiatorStrategy(new DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        this.kryo.register(Type.class, new TypeSerializer());
        this.kryo.register(ModAnnotation.class);
        this.kryo.register(int[].class);
        this.kryo.register(String[].class);
        this.kryo.register(float[].class);
        this.kryo.register(boolean[].class);
        this.kryo.register(byte[].class);
        this.kryo.register(char[].class);
        this.kryo.register(short[].class);
        this.kryo.register(long[].class);
        this.kryo.register(double[].class);
        this.kryo.register(ModAnnotation.EnumHolder.class);
        this.kryo.register(HashMap.class);
        this.kryo.register(CachedModInfo.class);
        this.kryo.register(HashSet.class);
        this.kryo.register(ASMModParser.class);
        this.kryo.register(LinkedList.class);
        this.kryo.register(JarDiscovererCache.classForNameOrException("cpw.mods.fml.common.discovery.asm.ASMModParser$AnnotationType"));
        this.kryo.register(ArrayList.class);
        if (this.DAT_OLD.exists() && !this.DAT.exists()) {
            CoreTweaks.LOGGER.info("Migrating jar discoverer cache: " + this.DAT_OLD + " -> " + this.DAT);
            this.DAT_OLD.renameTo(this.DAT);
        }
        if (this.DAT.exists()) {
            try (UnsafeInput is = new UnsafeInput(new BufferedInputStream(new FileInputStream(this.DAT)));){
                byte magic0 = this.kryo.readObject(is, Byte.TYPE);
                byte version = this.kryo.readObject(is, Byte.TYPE);
                this.epoch = this.kryo.readObject(is, Integer.TYPE);
                ++this.epoch;
                if (magic0 != 0 || version != 2) {
                    CoreTweaks.LOGGER.warn("Jar discoverer cache is either a different version or corrupted, discarding.");
                } else {
                    this.cache = this.returnVerifiedMap(this.kryo.readObject(is, HashMap.class));
                }
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.error("There was an error reading the jar discoverer cache. A new one will be created. The previous one has been saved as " + this.DAT_ERRORED.getName() + " for inspection.");
                this.DAT.renameTo(this.DAT_ERRORED);
                e.printStackTrace();
                this.cache.clear();
                this.epoch = 0;
            }
            long t1 = System.nanoTime();
            CoreTweaks.LOGGER.debug("Loaded jar discoverer cache with " + this.cache.size() + " entries in " + (double)(t1 - t0) / 1.0E9 + "s");
        } else {
            long t1 = System.nanoTime();
            CoreTweaks.LOGGER.debug("Created new jar discoverer cache in " + (double)(t1 - t0) / 1.0E9 + "s");
        }
        this.hasLoaded = true;
    }

    private static Class<?> classForNameOrException(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, CachedModInfo> returnVerifiedMap(Map<String, CachedModInfo> map) {
        if (map.containsKey(null)) {
            throw new RuntimeException("Map contains null key");
        }
        if (map.containsValue(null)) {
            throw new RuntimeException("Map contains null value");
        }
        return map;
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        this.finish();
    }

    public void finish() {
        if (!this.cache.isEmpty()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!JarDiscovererCache.this.DAT.exists()) {
                            JarDiscovererCache.this.DAT.getParentFile().mkdirs();
                            JarDiscovererCache.this.DAT.createNewFile();
                        }
                        JarDiscovererCache.this.cache.entrySet().removeIf(e -> JarDiscovererCache.this.epoch - ((CachedModInfo)e.getValue()).lastAccessed > Config.jarDiscovererCacheMaxAge);
                        try (UnsafeOutput output = new UnsafeOutput(new BufferedOutputStream(new FileOutputStream(JarDiscovererCache.this.DAT)));){
                            JarDiscovererCache.this.kryo.writeObject(output, (byte)0);
                            JarDiscovererCache.this.kryo.writeObject(output, (byte)2);
                            JarDiscovererCache.this.kryo.writeObject(output, JarDiscovererCache.this.epoch);
                            JarDiscovererCache.this.kryo.writeObject(output, JarDiscovererCache.this.cache);
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    JarDiscovererCache.this.cache = null;
                }
            }, "CoreTweaks JarDiscovererCache save thread").start();
        }
    }

    public CachedModInfo getCachedModInfo(String hash) {
        CachedModInfo cmi;
        if (!this.hasLoaded) {
            this.load();
        }
        if ((cmi = this.cache.get(hash)) == null) {
            cmi = new CachedModInfo(true);
            this.cache.put(hash, cmi);
        }
        cmi.lastAccessed = this.epoch;
        return cmi;
    }

    public static class TypeSerializer
    extends Serializer<Type> {
        @Override
        public void write(Kryo kryo, Output output, Type type) {
            output.writeByte(type.getSort());
            if (type.getSort() >= 9) {
                output.writeString(type.getInternalName());
            }
        }

        @Override
        public Type read(Kryo kryo, Input input, Class<? extends Type> type) {
            byte sort = input.readByte();
            String buf = sort >= 9 ? input.readString() : null;
            switch (sort) {
                case 0: {
                    return Type.VOID_TYPE;
                }
                case 1: {
                    return Type.BOOLEAN_TYPE;
                }
                case 2: {
                    return Type.CHAR_TYPE;
                }
                case 3: {
                    return Type.BYTE_TYPE;
                }
                case 4: {
                    return Type.SHORT_TYPE;
                }
                case 5: {
                    return Type.INT_TYPE;
                }
                case 6: {
                    return Type.FLOAT_TYPE;
                }
                case 7: {
                    return Type.LONG_TYPE;
                }
                case 8: {
                    return Type.DOUBLE_TYPE;
                }
                case 9: 
                case 10: {
                    return Type.getObjectType((String)buf);
                }
                case 11: {
                    return Type.getMethodType((String)buf);
                }
            }
            return null;
        }
    }

    public static class CachedModInfo {
        Map<String, ASMModParser> parserMap = new HashMap<String, ASMModParser>();
        Set<String> modClasses = new HashSet<String>();
        int lastAccessed;
        transient boolean dirty;

        public CachedModInfo(boolean dirty) {
            this.dirty = dirty;
        }

        public CachedModInfo() {
            this(false);
        }

        public ASMModParser getCachedParser(ZipEntry ze) {
            return this.parserMap.get(ze.getName());
        }

        public void putParser(ZipEntry ze, ASMModParser parser) {
            this.parserMap.put(ze.getName(), parser);
        }

        public int getCachedIsModClass(ZipEntry ze) {
            return this.dirty ? -1 : (this.modClasses.contains(ze.getName()) ? 1 : 0);
        }

        public void putIsModClass(ZipEntry ze, boolean value) {
            if (!this.dirty) {
                throw new IllegalStateException();
            }
            if (value) {
                this.modClasses.add(ze.getName());
            }
        }
    }
}

