/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.event;

import minetweaker.api.block.IBlock;
import minetweaker.api.item.IItemStack;
import minetweaker.api.player.IPlayer;
import minetweaker.api.world.IBlockGroup;
import minetweaker.api.world.IDimension;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="minetweaker.event.PlayerFillBucketEvent")
public class PlayerFillBucketEvent {
    private final IPlayer player;
    private final IBlockGroup blocks;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private IItemStack result;

    public PlayerFillBucketEvent(IPlayer player, IBlockGroup blocks, int x, int y, int z) {
        this.player = player;
        this.blocks = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.result = null;
    }

    @ZenMethod
    public void cancel() {
        this.canceled = true;
    }

    @ZenGetter(value="canceled")
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="result")
    public IItemStack getResult() {
        return this.result;
    }

    @ZenSetter(value="result")
    public void setResult(IItemStack result) {
        this.result = result;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="blocks")
    public IBlockGroup getBlocks() {
        return this.blocks;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.blocks.getBlock(this.x, this.y, this.z);
    }

    @ZenGetter(value="dimension")
    public IDimension getDimension() {
        return this.blocks.getDimension();
    }
}

