/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ConduitBundledRedstoneProvider
implements IBundledRedstoneProvider {
    public int getBundledRedstoneOutput(World world, int x, int y, int z, int side) {
        TileEntity inputTE = world.func_147438_o(x, y, z);
        if (inputTE != null && inputTE instanceof IConduitBundle) {
            IConduitBundle bundle = (IConduitBundle)inputTE;
            if (bundle.hasType(IInsulatedRedstoneConduit.class)) {
                IInsulatedRedstoneConduit conduit = bundle.getConduit(IInsulatedRedstoneConduit.class);
                Set<Signal> networkOutputs = conduit.getNetworkOutputs(ForgeDirection.UNKNOWN);
                int out = 0;
                for (Signal signal : networkOutputs) {
                    int index = signal.color.ordinal();
                    if (signal.strength == 0) continue;
                    out |= 1 << 15 - index;
                }
                return out;
            }
            return 0;
        }
        return -1;
    }

    public static void register() {
        ComputerCraftAPI.registerBundledRedstoneProvider((IBundledRedstoneProvider)new ConduitBundledRedstoneProvider());
    }
}

