/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.reservoir.BlockReservoir;
import crazypants.enderio.machine.reservoir.TileReservoir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ReservoirRenderer
extends TileEntitySpecialRenderer
implements IResourceManagerReloadListener {
    private ResourceLocation texName = null;
    private IIcon tex = null;
    private final BlockReservoir block;
    private Vector3d forward = new Vector3d();
    private Vector3d left = new Vector3d();
    private Vector3d up = new Vector3d();
    private Vector3d offset = new Vector3d();

    public ReservoirRenderer(BlockReservoir res) {
        this.block = res;
        RenderUtil.registerReloadListener((IResourceManagerReloadListener)this);
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        this.tex = null;
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileReservoir res = (TileReservoir)tileentity;
        if (res.haveRendered(tileentity.func_145831_w().func_82737_E(), f)) {
            return;
        }
        float fullness = res.getFilledRatio();
        if (fullness <= 0.0f && !res.isAutoEject()) {
            return;
        }
        float val = RenderUtil.claculateTotalBrightnessForLocation((World)tileentity.func_145831_w(), (int)tileentity.field_145851_c, (int)tileentity.field_145848_d, (int)tileentity.field_145849_e);
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vector3f offset = res.getOffsetFromController();
        GL11.glTranslatef((float)((float)x + offset.x), (float)((float)y + offset.y), (float)((float)z + offset.z));
        BoundingBox bb = res.getLiquidRenderBounds();
        if (res.isAutoEject()) {
            RenderUtil.bindBlockTexture();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78369_a(val, val, val, 1.0f);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.drawSwitch(dir, bb);
            }
            Tessellator.field_78398_a.func_78381_a();
        }
        if (fullness > 0.0f) {
            RenderUtil.bindTexture((ResourceLocation)this.getLiquidSheet());
            float margin = 0.01f;
            IIcon tex = this.getLiquidTexture();
            float maxV = tex.func_94206_g() + (tex.func_94210_h() - tex.func_94206_g()) * fullness;
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78369_a(val, val, val, 1.0f);
            CubeRenderer.render((BoundingBox)new BoundingBox(bb.minX + margin, bb.minY + margin, bb.minZ + margin, bb.maxX - margin, bb.minY + fullness * Math.abs(bb.maxY - bb.minY) - margin, bb.maxZ - margin), (float)tex.func_94209_e(), (float)tex.func_94212_f(), (float)tex.func_94206_g(), (float)maxV);
            Tessellator.field_78398_a.func_78381_a();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
    }

    private void drawSwitch(ForgeDirection dir, BoundingBox bb) {
        Tessellator tes = Tessellator.field_78398_a;
        Vector3d cent = bb.getCenter();
        this.offset.set(cent);
        boolean isUp = dir.offsetY != 0;
        this.forward.set((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
        this.forward.scale(0.5);
        this.forward.x *= (double)bb.sizeX();
        this.forward.y *= (double)bb.sizeY();
        this.forward.z *= (double)bb.sizeZ();
        this.offset.add(this.forward);
        if (dir.offsetY == 0) {
            this.offset.y += (double)bb.sizeY() * 0.25;
        }
        if (dir.offsetX == 0) {
            this.offset.x = this.offset.x - (double)((float)(isUp ? dir.offsetY : dir.offsetZ) * bb.sizeX()) * 0.25;
        }
        if (dir.offsetZ == 0) {
            this.offset.z = this.offset.z + (double)((float)(isUp ? -dir.offsetY : dir.offsetX) * bb.sizeZ()) * 0.25;
        }
        this.left.set(isUp ? (double)(-dir.offsetY) : (double)(-dir.offsetZ), 0.0, (double)dir.offsetX);
        if (isUp) {
            this.up.set(0.0, 0.0, -1.0);
        } else {
            this.up.set(0.0, 1.0, 0.0);
        }
        this.forward.scale(0.5);
        this.left.scale(0.125);
        this.up.scale(0.125);
        IIcon icon = this.block.switchIcon;
        tes.func_78374_a(this.offset.x + this.left.x - this.up.x, this.offset.y + this.left.y - this.up.y, this.offset.z + this.left.z - this.up.z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tes.func_78374_a(this.offset.x - this.left.x - this.up.x, this.offset.y - this.left.y - this.up.y, this.offset.z - this.left.z - this.up.z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tes.func_78374_a(this.offset.x - this.left.x + this.up.x, this.offset.y - this.left.y + this.up.y, this.offset.z - this.left.z + this.up.z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tes.func_78374_a(this.offset.x + this.left.x + this.up.x, this.offset.y + this.left.y + this.up.y, this.offset.z + this.left.z + this.up.z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
    }

    private ResourceLocation getLiquidSheet() {
        if (this.texName == null) {
            this.texName = TextureMap.field_110575_b;
        }
        return this.texName;
    }

    private IIcon getLiquidTexture() {
        if (this.tex == null) {
            this.tex = FluidRegistry.WATER.getStillIcon();
        }
        return this.tex;
    }
}

