/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import cofh.api.energy.IEnergyReceiver;
import crazypants.enderio.power.IPowerInterface;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyReceiverPI
implements IPowerInterface {
    private IEnergyReceiver rfPower;

    public EnergyReceiverPI(IEnergyReceiver powerReceptor) {
        this.rfPower = powerReceptor;
    }

    @Override
    public Object getDelegate() {
        return this.rfPower;
    }

    @Override
    public boolean canConduitConnect(ForgeDirection direction) {
        if (this.rfPower != null && direction != null) {
            return this.rfPower.canConnectEnergy(direction.getOpposite());
        }
        return false;
    }

    @Override
    public int getEnergyStored(ForgeDirection dir) {
        if (this.rfPower != null && dir != null) {
            return this.rfPower.getEnergyStored(dir);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection dir) {
        if (this.rfPower != null && dir != null) {
            return this.rfPower.getMaxEnergyStored(dir);
        }
        return 0;
    }

    @Override
    public int getPowerRequest(ForgeDirection dir) {
        if (this.rfPower != null && dir != null && this.rfPower.canConnectEnergy(dir)) {
            return this.rfPower.receiveEnergy(dir, 99999999, true);
        }
        return 0;
    }

    public static int getPowerRequest(ForgeDirection dir, IEnergyReceiver handler) {
        if (handler != null && dir != null && handler.canConnectEnergy(dir)) {
            return handler.receiveEnergy(dir, 99999999, true);
        }
        return 0;
    }

    @Override
    public int getMinEnergyReceived(ForgeDirection dir) {
        return 0;
    }

    @Override
    public int recieveEnergy(ForgeDirection opposite, int canOffer) {
        if (this.rfPower != null && opposite != null) {
            return this.rfPower.receiveEnergy(opposite, canOffer, false);
        }
        return 0;
    }

    @Override
    public boolean isOutputOnly() {
        return false;
    }

    @Override
    public boolean isInputOnly() {
        return true;
    }
}

