/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.CompatBaublesExpanded;
import ganymedes01.etfuturum.CompatTC;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModEnchantments;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.api.waila.WailaRegistrar;
import ganymedes01.etfuturum.blocks.BlockSculk;
import ganymedes01.etfuturum.blocks.BlockSculkCatalyst;
import ganymedes01.etfuturum.client.BuiltInResourcePack;
import ganymedes01.etfuturum.client.DynamicResourcePack;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.command.CommandFill;
import ganymedes01.etfuturum.configuration.ConfigBase;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.core.proxy.CommonProxy;
import ganymedes01.etfuturum.core.utils.BrewingFuelRegistry;
import ganymedes01.etfuturum.core.utils.CompostingRegistry;
import ganymedes01.etfuturum.core.utils.DeepslateOreRegistry;
import ganymedes01.etfuturum.core.utils.HoeRegistry;
import ganymedes01.etfuturum.core.utils.RawOreRegistry;
import ganymedes01.etfuturum.core.utils.StrippedLogRegistry;
import ganymedes01.etfuturum.entities.ModEntityList;
import ganymedes01.etfuturum.lib.Reference;
import ganymedes01.etfuturum.network.ArmourStandInteractHandler;
import ganymedes01.etfuturum.network.ArmourStandInteractMessage;
import ganymedes01.etfuturum.network.AttackYawHandler;
import ganymedes01.etfuturum.network.AttackYawMessage;
import ganymedes01.etfuturum.network.BlackHeartParticlesHandler;
import ganymedes01.etfuturum.network.BlackHeartParticlesMessage;
import ganymedes01.etfuturum.network.BoatMoveHandler;
import ganymedes01.etfuturum.network.BoatMoveMessage;
import ganymedes01.etfuturum.network.ChestBoatOpenInventoryHandler;
import ganymedes01.etfuturum.network.ChestBoatOpenInventoryMessage;
import ganymedes01.etfuturum.network.StartElytraFlyingHandler;
import ganymedes01.etfuturum.network.StartElytraFlyingMessage;
import ganymedes01.etfuturum.network.WoodSignOpenHandler;
import ganymedes01.etfuturum.network.WoodSignOpenMessage;
import ganymedes01.etfuturum.potion.ModPotions;
import ganymedes01.etfuturum.recipes.BlastFurnaceRecipes;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.recipes.SmithingTableRecipes;
import ganymedes01.etfuturum.recipes.SmokerRecipes;
import ganymedes01.etfuturum.repackage.makamys.mclib.core.MCLib;
import ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.ADConfig;
import ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.AssetDirectorAPI;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import ganymedes01.etfuturum.world.EtFuturumLateWorldGenerator;
import ganymedes01.etfuturum.world.EtFuturumWorldGenerator;
import ganymedes01.etfuturum.world.end.dimension.DimensionProviderEnd;
import ganymedes01.etfuturum.world.structure.OceanMonument;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockHay;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

@Mod(modid="etfuturum", name="Et Futurum Requiem", version="2.4.4", dependencies="required-after:Forge@[10.13.4.1558,);after:Thaumcraft@[4.2.3.5,);after:TwilightForest;after:HardcoreEnderExpansion;after:bluepower;after:MineTweaker3;", guiFactory="ganymedes01.etfuturum.configuration.ConfigGuiFactory")
public class EtFuturum {
    @Mod.Instance(value="etfuturum")
    public static EtFuturum instance;
    @SidedProxy(clientSide="ganymedes01.etfuturum.core.proxy.ClientProxy", serverSide="ganymedes01.etfuturum.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper networkWrapper;
    public static CreativeTabs creativeTabItems;
    public static CreativeTabs creativeTabBlocks;
    public static boolean netherAmbienceNetherlicious;
    public static boolean netherMusicNetherlicious;
    public static final boolean TESTING;
    public static final boolean DEV_ENVIRONMENT;
    public static boolean SNAPSHOT_BUILD;
    private static Side effectiveSide;
    static final Map<ItemStack, Integer> DEFAULT_COMPOST_CHANCES;
    static final String NETHER_FORTRESS = "netherFortress";
    private Field fortressWeightedField;
    public static final boolean hasEnderlicious;
    public static final boolean hasIronChest;
    public static final boolean hasNetherlicious;
    public static final boolean hasAetherLegacy;
    public static final boolean hasWaila;
    public static final boolean hasThaumcraft;
    public static final boolean hasBluePower;
    public static final boolean hasNP;
    public static final boolean hasBotania;
    public static final boolean hasHEE;
    public static final boolean hasIC2;
    public static final boolean hasSkinPort;
    public static final boolean hasEars;
    public static final boolean hasBaubles;
    public static final boolean hasBaublesExpanded;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        MCLib.init();
        ADConfig config = new ADConfig();
        EtFuturum.getSounds(config);
        AssetDirectorAPI.register(config);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File file;
        try {
            Field chestInfo = ChestGenHooks.class.getDeclaredField("chestInfo");
            chestInfo.setAccessible(true);
            if (!((HashMap)chestInfo.get(null)).containsKey(NETHER_FORTRESS)) {
                this.fortressWeightedField = Class.forName("net.minecraft.world.gen.structure.StructureNetherBridgePieces$Piece").getDeclaredField("field_111019_a");
                this.fortressWeightedField.setAccessible(true);
                ((HashMap)chestInfo.get(null)).put(NETHER_FORTRESS, new ChestGenHooks(NETHER_FORTRESS, (WeightedRandomChestContent[])this.fortressWeightedField.get(null), 2, 5));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get Nether fortress loot table:");
            e.printStackTrace();
        }
        ModBlocks.init();
        ModItems.init();
        ModEnchantments.init();
        ModPotions.init();
        SpectatorMode.init();
        if (event.getSide() == Side.CLIENT) {
            DynamicResourcePack.inject();
            if (ConfigFunctions.enableNewTextures) {
                BuiltInResourcePack.register("vanilla_overrides");
            }
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)EtFuturumWorldGenerator.INSTANCE, (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)EtFuturumLateWorldGenerator.INSTANCE, (int)Integer.MAX_VALUE);
        OceanMonument.makeMap();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("etfuturum");
        networkWrapper.registerMessage(ArmourStandInteractHandler.class, ArmourStandInteractMessage.class, 0, Side.SERVER);
        networkWrapper.registerMessage(BlackHeartParticlesHandler.class, BlackHeartParticlesMessage.class, 1, Side.CLIENT);
        networkWrapper.registerMessage(WoodSignOpenHandler.class, WoodSignOpenMessage.class, 3, Side.CLIENT);
        networkWrapper.registerMessage(BoatMoveHandler.class, BoatMoveMessage.class, 4, Side.SERVER);
        networkWrapper.registerMessage(ChestBoatOpenInventoryHandler.class, ChestBoatOpenInventoryMessage.class, 5, Side.SERVER);
        networkWrapper.registerMessage(StartElytraFlyingHandler.class, StartElytraFlyingMessage.class, 6, Side.SERVER);
        networkWrapper.registerMessage(AttackYawHandler.class, AttackYawMessage.class, 7, Side.CLIENT);
        if (hasNetherlicious && (file = new File(event.getModConfigurationDirectory() + "/Netherlicious/Biome_Sound_Configuration.cfg")).exists()) {
            Configuration netherliciousSoundConfig = new Configuration(file);
            netherAmbienceNetherlicious = netherliciousSoundConfig.get("1 nether ambience", "Allow Biome specific sounds to play", true).getBoolean();
            netherMusicNetherlicious = netherliciousSoundConfig.get("2 biome music", "1 Replace the Music System in the Nether, to allow Biome specific Music. Default Music will still play sometimes", true).getBoolean();
        }
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = "\u00a75\u00a7oEt Futurum Requiem";
        Reference.BUILD_VERSION = event.getModMetadata().version;
        SNAPSHOT_BUILD = Reference.BUILD_VERSION.toLowerCase().contains("snapshot") || Reference.BUILD_VERSION.toLowerCase().contains("beta") || Reference.BUILD_VERSION.toLowerCase().contains("rc");
        event.getModMetadata().version = "\u00a7e" + event.getModMetadata().version;
        event.getModMetadata().credits = "\u00a7bDelirusCrux, AstroTibs";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.addAll(Arrays.asList(Reference.AUTHOR_LIST));
        event.getModMetadata().url = "\u00a77https://www.curseforge.com/minecraft/mc-mods/et-futurum-requiem";
        event.getModMetadata().description = "\u00a79Brings the future to now, for real this time.";
        event.getModMetadata().logoFile = "assets/etfuturum/logo.png";
        if (ConfigModCompat.elytraBaublesExpandedCompat > 0 && hasBaublesExpanded) {
            CompatBaublesExpanded.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModRecipes.init();
        if (hasWaila) {
            WailaRegistrar.register();
        }
        proxy.registerEvents();
        proxy.registerEntities();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Item stoneTile;
        if (ConfigFunctions.enableUpdatedFoodValues) {
            ((ItemFood)Items.field_151172_bF).field_77853_b = 3;
            ((ItemFood)Items.field_151168_bH).field_77853_b = 5;
        }
        if (ConfigFunctions.enableUpdatedHarvestLevels) {
            Blocks.field_150403_cj.setHarvestLevel("pickaxe", 0);
            Blocks.field_150468_ap.setHarvestLevel("axe", 0);
            Blocks.field_150440_ba.setHarvestLevel("axe", 0);
        }
        if (ConfigFunctions.enableFloatingTrapDoors) {
            BlockTrapDoor.disableValidation = true;
        }
        if (hasThaumcraft) {
            CompatTC.doAspects();
        }
        Items.field_151072_bj.func_77664_n();
        Blocks.field_150447_bR.func_149647_a(CreativeTabs.field_78028_d);
        if (ConfigBlocksItems.enableOtherside) {
            ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.otherside_record, 0, 1, 1, 1));
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.otherside_record, 0, 1, 1, 1));
        }
        if (ConfigBlocksItems.enablePigstep) {
            ChestGenHooks.addItem((String)NETHER_FORTRESS, (WeightedRandomChestContent)new WeightedRandomChestContent(ModItems.pigstep_record, 0, 1, 1, 5));
            if (this.fortressWeightedField != null) {
                try {
                    Field contents = ChestGenHooks.class.getDeclaredField("contents");
                    contents.setAccessible(true);
                    ArrayList fortressContentList = (ArrayList)contents.get(ChestGenHooks.getInfo((String)NETHER_FORTRESS));
                    if (!fortressContentList.isEmpty()) {
                        WeightedRandomChestContent[] fortressChest = new WeightedRandomChestContent[fortressContentList.size()];
                        for (int i = 0; i < fortressContentList.size(); ++i) {
                            fortressChest[i] = (WeightedRandomChestContent)fortressContentList.get(i);
                        }
                        this.fortressWeightedField.set(null, fortressChest);
                    }
                }
                catch (Exception e) {
                    System.out.println("Failed to fill Nether fortress loot table:");
                    e.printStackTrace();
                }
            }
        }
        if (ConfigBlocksItems.enableSmoothStone && hasBluePower && (stoneTile = GameRegistry.findItem((String)"bluepower", (String)"stone_tile")) != null) {
            Item stoneItem = Item.func_150898_a((Block)Blocks.field_150348_b);
            Iterator furnaceRecipes = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
            while (furnaceRecipes.hasNext()) {
                Map.Entry recipe = furnaceRecipes.next();
                if (recipe.getValue() == null || ((ItemStack)recipe.getValue()).func_77973_b() != stoneTile || recipe.getKey() == null || ((ItemStack)recipe.getKey()).func_77973_b() != stoneItem) continue;
                furnaceRecipes.remove();
            }
        }
        if (ConfigModCompat.elytraBaublesExpandedCompat > 0 && hasBaublesExpanded) {
            CompatBaublesExpanded.postInit();
        }
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent e) {
        DeepslateOreRegistry.init();
        StrippedLogRegistry.init();
        RawOreRegistry.init();
        SmokerRecipes.init();
        BlastFurnaceRecipes.init();
        SmithingTableRecipes.init();
        CompostingRegistry.init();
        ConfigBase.postInit();
        if (ConfigSounds.newBlockSounds) {
            if (hasNP) {
                Blocks.field_150385_bj.func_149672_a(ModSounds.soundNetherBricks);
                Blocks.field_150386_bk.func_149672_a(ModSounds.soundNetherBricks);
                Blocks.field_150387_bl.func_149672_a(ModSounds.soundNetherBricks);
            }
            Blocks.field_150323_B.func_149672_a(Block.field_149766_f);
        }
        for (Block block : Block.field_149771_c) {
            String blockID;
            Block.SoundType sound;
            if (ConfigFunctions.enableHoeMining && (block instanceof BlockLeaves || block instanceof BlockHay || block instanceof BlockSponge || block instanceof BlockNetherWart || block instanceof BlockSculk || block instanceof BlockSculkCatalyst)) {
                HoeRegistry.addToHoeArray(block);
            }
            if (!ConfigSounds.newBlockSounds || (sound = this.getCustomStepSound(block, blockID = Block.field_149771_c.func_148750_c((Object)block).split(":")[1].toLowerCase())) == null) continue;
            block.func_149672_a(sound);
        }
        if (TESTING) {
            DimensionProviderEnd.init();
        }
    }

    public Block.SoundType getCustomStepSound(Block block, String namespace) {
        if (block.field_149762_H == Block.field_149780_i || block.field_149762_H == Block.field_149769_e) {
            if (namespace.contains("nether") && namespace.contains("brick")) {
                return ModSounds.soundNetherBricks;
            }
            if (namespace.contains("netherrack") || namespace.contains("hellfish")) {
                return ModSounds.soundNetherrack;
            }
            if (block == Blocks.field_150449_bY || namespace.contains("nether") && (block instanceof BlockOre || namespace.contains("ore"))) {
                return ModSounds.soundNetherOre;
            }
            if (namespace.contains("deepslate")) {
                return namespace.contains("brick") ? ModSounds.soundDeepslateBricks : ModSounds.soundDeepslate;
            }
            if (block instanceof BlockNetherWart || namespace.contains("nether") && namespace.contains("wart")) {
                return ModSounds.soundCropWarts;
            }
            if (namespace.contains("bone") || namespace.contains("ivory")) {
                return ModSounds.soundBoneBlock;
            }
            if (block instanceof BlockBed && (block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151580_n)) {
                block.func_149672_a(Block.field_149766_f);
            }
        }
        if (block.field_149762_H == Block.field_149779_h) {
            if (block instanceof BlockVine) {
                return ModSounds.soundVines;
            }
            if (block instanceof BlockLilyPad) {
                return ModSounds.soundWetGrass;
            }
        }
        if (block instanceof BlockCrops || block instanceof BlockStem) {
            return ModSounds.soundCrops;
        }
        if (block.field_149762_H == Block.field_149776_m && namespace.contains("soul") && namespace.contains("sand")) {
            return ModSounds.soundSoulSand;
        }
        if (block.field_149762_H == Block.field_149777_j && (namespace.contains("copper") || namespace.contains("tin"))) {
            return ModSounds.soundCopper;
        }
        if (block.func_149688_o() == Material.field_151573_f && block instanceof BlockHopper) {
            return Block.field_149777_j;
        }
        return null;
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.key.equals("register-brewing-fuel")) continue;
            NBTTagCompound nbt = message.getNBTValue();
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Fuel"));
            int brews = nbt.func_74762_e("Brews");
            BrewingFuelRegistry.registerFuel(stack, brews);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (ConfigFunctions.enableFillCommand) {
            event.registerServerCommand((ICommand)new CommandFill());
        }
    }

    public static void copyAttribs(Block to, Block from) {
        to.func_149711_c(from.field_149782_v);
        to.func_149752_b(from.field_149781_w);
        to.func_149663_c(from.func_149739_a().replace("tile.", ""));
        to.func_149647_a(from.field_149772_a);
        to.func_149672_a(from.field_149762_H);
        to.func_149658_d(from.field_149768_d);
        for (int i = 0; i < 16; ++i) {
            String tool = from.getHarvestTool(i);
            int level = from.getHarvestLevel(i);
            to.setHarvestLevel(tool, level, i);
        }
    }

    public static boolean stringListContainsPhrase(Set<String> set, String string) {
        for (String stringInSet : set) {
            if (!string.contains(stringInSet)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getOreStrings(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)oreID));
        }
        return list;
    }

    public static boolean hasDictTag(Block block, String ... tags) {
        return EtFuturum.hasDictTag(new ItemStack(block), tags);
    }

    public static boolean hasDictTag(Item item, String ... tags) {
        return EtFuturum.hasDictTag(new ItemStack(item), tags);
    }

    public static boolean hasDictTag(ItemStack stack, String ... tags) {
        for (String oreName : EtFuturum.getOreStrings(stack)) {
            if (!ArrayUtils.contains((Object[])tags, (Object)oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean dictTagsContain(Block block, String stringToFind) {
        return EtFuturum.dictTagsContain(new ItemStack(block), stringToFind);
    }

    public static boolean dictTagsContain(Item item, String stringToFind) {
        return EtFuturum.dictTagsContain(new ItemStack(item), stringToFind);
    }

    public static boolean dictTagsContain(ItemStack stack, String stringToFind) {
        for (String oreName : EtFuturum.getOreStrings(stack)) {
            if (!oreName.contains(stringToFind)) continue;
            return true;
        }
        return false;
    }

    public static PotionEffect getSuspiciousStewEffect(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150328_O)) {
            switch (stack.func_77960_j()) {
                default: {
                    return new PotionEffect(Potion.field_76439_r.field_76415_H, 100, 0);
                }
                case 1: {
                    return new PotionEffect(Potion.field_76443_y.field_76415_H, 7, 0);
                }
                case 2: {
                    return new PotionEffect(Potion.field_76426_n.field_76415_H, 80, 0);
                }
                case 3: {
                    return new PotionEffect(Potion.field_76440_q.field_76415_H, 160, 0);
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return new PotionEffect(Potion.field_76437_t.field_76415_H, 180, 0);
                }
                case 8: 
            }
            return new PotionEffect(Potion.field_76428_l.field_76415_H, 160, 0);
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150327_N)) {
            return new PotionEffect(Potion.field_76443_y.field_76415_H, 7, 0);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.cornflower)) {
            return new PotionEffect(Potion.field_76430_j.field_76415_H, 120, 0);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.lily_of_the_valley)) {
            return new PotionEffect(Potion.field_76436_u.field_76415_H, 240, 0);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.wither_rose)) {
            return new PotionEffect(Potion.field_82731_v.field_76415_H, 160, 0);
        }
        return null;
    }

    private static void getSounds(ADConfig config) {
        String ver = "minecraft_1.19.3".split("_")[1];
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave14.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave15.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave16.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave17.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave18.ogg");
        config.addObject(ver, "minecraft/sounds/ambient/cave/cave19.ogg");
        config.addSoundEvent(ver, "weather.rain", "weather");
        config.addSoundEvent(ver, "weather.rain.above", "weather");
        config.addSoundEvent(ver, "music.nether.nether_wastes", "music");
        config.addSoundEvent(ver, "ambient.nether_wastes.additions", "ambient");
        config.addSoundEvent(ver, "ambient.nether_wastes.loop", "ambient");
        config.addSoundEvent(ver, "ambient.nether_wastes.mood", "ambient");
        config.addSoundEvent(ver, "music_disc.pigstep", "record");
        config.addSoundEvent(ver, "music_disc.otherside", "record");
        config.addSoundEvent(ver, "item.elytra.flying", "player");
        config.addSoundEvent(ver, "enchant.thorns.hit", "player");
        config.addSoundEvent(ver, "entity.boat.paddle_land", "player");
        config.addSoundEvent(ver, "entity.boat.paddle_water", "player");
        config.addSoundEvent(ver, "entity.rabbit.ambient", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.jump", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.attack", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.hurt", "neutral");
        config.addSoundEvent(ver, "entity.rabbit.death", "neutral");
        config.addSoundEvent(ver, "entity.zombie_villager.ambient", "hostile");
        config.addSoundEvent(ver, "entity.zombie_villager.step", "hostile");
        config.addSoundEvent(ver, "entity.zombie_villager.hurt", "hostile");
        config.addSoundEvent(ver, "entity.zombie_villager.death", "hostile");
        config.addSoundEvent(ver, "entity.husk.ambient", "hostile");
        config.addSoundEvent(ver, "entity.husk.step", "hostile");
        config.addSoundEvent(ver, "entity.husk.hurt", "hostile");
        config.addSoundEvent(ver, "entity.husk.death", "hostile");
        config.addSoundEvent(ver, "entity.zombie.converted_to_drowned", "hostile");
        config.addSoundEvent(ver, "entity.husk.converted_to_zombie", "hostile");
        config.addSoundEvent(ver, "entity.stray.ambient", "hostile");
        config.addSoundEvent(ver, "entity.stray.step", "hostile");
        config.addSoundEvent(ver, "entity.stray.hurt", "hostile");
        config.addSoundEvent(ver, "entity.stray.death", "hostile");
        config.addSoundEvent(ver, "entity.skeleton.converted_to_stray", "hostile");
        config.addSoundEvent(ver, "entity.shulker_bullet.hurt", "hostile");
        config.addSoundEvent(ver, "entity.shulker_bullet.hit", "hostile");
        config.addSoundEvent(ver, "entity.shulker.ambient", "hostile");
        config.addSoundEvent(ver, "entity.shulker.open", "hostile");
        config.addSoundEvent(ver, "entity.shulker.close", "hostile");
        config.addSoundEvent(ver, "entity.shulker.shoot", "hostile");
        config.addSoundEvent(ver, "entity.shulker.hurt", "hostile");
        config.addSoundEvent(ver, "entity.shulker.hurt_closed", "hostile");
        config.addSoundEvent(ver, "entity.shulker.death", "hostile");
        config.addSoundEvent(ver, "entity.shulker.teleport", "hostile");
        config.addSoundEvent(ver, "entity.snow_golem.ambient", "neutral");
        config.addSoundEvent(ver, "entity.snow_golem.hurt", "neutral");
        config.addSoundEvent(ver, "entity.snow_golem.death", "neutral");
        config.addSoundEvent(ver, "entity.wither_skeleton.ambient", "hostile");
        config.addSoundEvent(ver, "entity.wither_skeleton.hurt", "hostile");
        config.addSoundEvent(ver, "entity.wither_skeleton.death", "hostile");
        config.addSoundEvent(ver, "entity.wither_skeleton.step", "hostile");
        config.addSoundEvent(ver, "entity.squid.ambient", "neutral");
        config.addSoundEvent(ver, "entity.squid.hurt", "neutral");
        config.addSoundEvent(ver, "entity.squid.death", "neutral");
        config.addSoundEvent(ver, "entity.squid.squirt", "neutral");
        config.addSoundEvent(ver, "entity.witch.ambient", "hostile");
        config.addSoundEvent(ver, "entity.witch.hurt", "hostile");
        config.addSoundEvent(ver, "entity.witch.death", "hostile");
        config.addSoundEvent(ver, "entity.witch.drink", "hostile");
        config.addSoundEvent(ver, "entity.item_frame.add_item", "player");
        config.addSoundEvent(ver, "entity.item_frame.break", "player");
        config.addSoundEvent(ver, "entity.item_frame.place", "player");
        config.addSoundEvent(ver, "entity.item_frame.remove_item", "player");
        config.addSoundEvent(ver, "entity.item_frame.rotate_item", "player");
        config.addSoundEvent(ver, "entity.painting.break", "player");
        config.addSoundEvent(ver, "entity.painting.place", "player");
        config.addSoundEvent(ver, "entity.leash_knot.break", "player");
        config.addSoundEvent(ver, "entity.leash_knot.place", "player");
        config.addSoundEvent(ver, "entity.ender_eye.death", "neutral");
        config.addSoundEvent(ver, "entity.ender_eye.launch", "neutral");
        config.addSoundEvent(ver, "entity.fishing_bobber.retrieve", "neutral");
        config.addSoundEvent(ver, "entity.fishing_bobber.throw", "neutral");
        config.addSoundEvent(ver, "entity.horse.eat", "neutral");
        config.addSoundEvent(ver, "entity.cow.milk", "neutral");
        config.addSoundEvent(ver, "entity.mooshroom.milk", "neutral");
        config.addSoundEvent(ver, "entity.mooshroom.convert", "neutral");
        config.addSoundEvent(ver, "entity.player.hurt_on_fire", "player");
        config.addSoundEvent(ver, "entity.player.hurt_drown", "player");
        config.addSoundEvent(ver, "entity.player.hurt_sweet_berry_bush", "player");
        config.addSoundEvent(ver, "entity.player.attack.crit", "player");
        config.addSoundEvent(ver, "entity.player.attack.knockback", "player");
        config.addSoundEvent(ver, "entity.player.attack.nodamage", "player");
        config.addSoundEvent(ver, "entity.player.attack.strong", "player");
        config.addSoundEvent(ver, "entity.player.attack.sweep", "player");
        config.addSoundEvent(ver, "entity.player.attack.weak", "player");
        config.addSoundEvent(ver, "entity.player.splash.high_speed", "player");
        config.addSoundEvent(ver, "item.axe.scrape", "player");
        config.addSoundEvent(ver, "item.axe.wax_off", "player");
        config.addSoundEvent(ver, "item.axe.strip", "player");
        config.addSoundEvent(ver, "item.hoe.till", "player");
        config.addSoundEvent(ver, "item.honeycomb.wax_on", "player");
        config.addSoundEvent(ver, "item.totem.use", "player");
        config.addSoundEvent(ver, "item.shovel.flatten", "player");
        config.addSoundEvent(ver, "item.chorus_fruit.teleport", "player");
        config.addSoundEvent(ver, "item.book.page_turn", "player");
        config.addSoundEvent(ver, "item.bucket.fill", "player");
        config.addSoundEvent(ver, "item.bucket.fill_lava", "player");
        config.addSoundEvent(ver, "item.bucket.empty", "player");
        config.addSoundEvent(ver, "item.bucket.empty_lava", "player");
        config.addSoundEvent(ver, "item.bottle.fill", "player");
        config.addSoundEvent(ver, "item.bottle.empty", "player");
        config.addSoundEvent(ver, "item.bone_meal.use", "player");
        config.addSoundEvent(ver, "item.armor.equip_leather", "player");
        config.addSoundEvent(ver, "item.armor.equip_gold", "player");
        config.addSoundEvent(ver, "item.armor.equip_chain", "player");
        config.addSoundEvent(ver, "item.armor.equip_iron", "player");
        config.addSoundEvent(ver, "item.armor.equip_diamond", "player");
        config.addSoundEvent(ver, "item.armor.equip_netherite", "player");
        config.addSoundEvent(ver, "item.armor.equip_turtle", "player");
        config.addSoundEvent(ver, "item.armor.equip_generic", "player");
        config.addSoundEvent(ver, "item.armor.equip_elytra", "player");
        config.addSoundEvent(ver, "block.note_block.banjo", "record");
        config.addSoundEvent(ver, "block.note_block.bell", "record");
        config.addSoundEvent(ver, "block.note_block.bit", "record");
        config.addSoundEvent(ver, "block.note_block.chime", "record");
        config.addSoundEvent(ver, "block.note_block.cow_bell", "record");
        config.addSoundEvent(ver, "block.note_block.didgeridoo", "record");
        config.addSoundEvent(ver, "block.note_block.flute", "record");
        config.addSoundEvent(ver, "block.note_block.guitar", "record");
        config.addSoundEvent(ver, "block.note_block.harp", "record");
        config.addSoundEvent(ver, "block.note_block.iron_xylophone", "record");
        config.addSoundEvent(ver, "block.note_block.xylophone", "record");
        config.addSoundEvent(ver, "block.barrel.open", "block");
        config.addSoundEvent(ver, "block.barrel.close", "block");
        config.addSoundEvent(ver, "block.chorus_flower.grow", "block");
        config.addSoundEvent(ver, "block.chorus_flower.death", "block");
        config.addSoundEvent(ver, "block.end_portal.spawn", "ambient");
        config.addSoundEvent(ver, "block.end_portal_frame.fill", "block");
        config.addSoundEvent(ver, "block.shulker_box.open", "block");
        config.addSoundEvent(ver, "block.shulker_box.close", "block");
        config.addSoundEvent(ver, "block.sweet_berry_bush.pick_berries", "player");
        config.addSoundEvent(ver, "block.brewing_stand.brew", "block");
        config.addSoundEvent(ver, "block.furnace.fire_crackle", "block");
        config.addSoundEvent(ver, "block.blastfurnace.fire_crackle", "block");
        config.addSoundEvent(ver, "block.smoker.smoke", "block");
        config.addSoundEvent(ver, "block.chest.close", "block");
        config.addSoundEvent(ver, "block.ender_chest.open", "block");
        config.addSoundEvent(ver, "block.ender_chest.close", "block");
        config.addSoundEvent(ver, "block.wooden_door.open", "block");
        config.addSoundEvent(ver, "block.wooden_door.close", "block");
        config.addSoundEvent(ver, "block.iron_door.open", "block");
        config.addSoundEvent(ver, "block.iron_door.close", "block");
        config.addSoundEvent(ver, "block.wooden_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.wooden_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.iron_trapdoor.open", "block");
        config.addSoundEvent(ver, "block.iron_trapdoor.close", "block");
        config.addSoundEvent(ver, "block.fence_gate.open", "block");
        config.addSoundEvent(ver, "block.fence_gate.close", "block");
        config.addSoundEvent(ver, "block.composter.empty", "block");
        config.addSoundEvent(ver, "block.composter.fill", "block");
        config.addSoundEvent(ver, "block.composter.fill_success", "block");
        config.addSoundEvent(ver, "block.composter.ready", "block");
        config.addSoundEvent(ver, "block.amethyst_block.hit", "block");
        config.addSoundEvent(ver, "block.amethyst_block.chime", "block");
        config.addSoundEvent(ver, "block.smithing_table.use", "player");
        config.addSoundEvent(ver, "block.enchantment_table.use", "player");
        config.addSoundEvent(ver, "block.wooden_button.click_off", "block");
        config.addSoundEvent(ver, "block.wooden_button.click_on", "block");
        config.addSoundEvent(ver, "block.wooden_pressure_plate.click_off", "block");
        config.addSoundEvent(ver, "block.wooden_pressure_plate.click_on", "block");
        config.addSoundEvent(ver, "block.metal_pressure_plate.click_off", "block");
        config.addSoundEvent(ver, "block.metal_pressure_plate.click_on", "block");
        config.addSoundEvent(ver, "block.beacon.activate", "block");
        config.addSoundEvent(ver, "block.beacon.ambient", "block");
        config.addSoundEvent(ver, "block.beacon.deactivate", "block");
        config.addSoundEvent(ver, "block.beacon.power_select", "block");
        config.addSoundEvent(ver, "item.crop.plant", "block");
        config.addSoundEvent(ver, "block.crop.break", "block");
        config.addSoundEvent(ver, "item.nether_wart.plant", "block");
        config.addSoundEvent(ver, "block.nether_wart.break", "block");
        config.addSoundEvent(ver, "block.lantern.step", "neutral");
        config.addSoundEvent(ver, "block.lantern.break", "block");
        config.addSoundEvent(ver, "block.lantern.place", "block");
        config.addSoundEvent(ver, "block.deepslate.step", "neutral");
        config.addSoundEvent(ver, "block.deepslate.break", "block");
        config.addSoundEvent(ver, "block.deepslate.place", "block");
        config.addSoundEvent(ver, "block.sweet_berry_bush.break", "block");
        config.addSoundEvent(ver, "block.sweet_berry_bush.place", "block");
        config.addSoundEvent(ver, "block.deepslate_bricks.step", "neutral");
        config.addSoundEvent(ver, "block.deepslate_bricks.break", "block");
        config.addSoundEvent(ver, "block.deepslate_tiles.step", "neutral");
        config.addSoundEvent(ver, "block.deepslate_tiles.break", "block");
        config.addSoundEvent(ver, "block.soul_sand.step", "neutral");
        config.addSoundEvent(ver, "block.soul_sand.break", "block");
        config.addSoundEvent(ver, "block.wart_block.step", "neutral");
        config.addSoundEvent(ver, "block.wart_block.break", "block");
        config.addSoundEvent(ver, "block.nether_bricks.step", "neutral");
        config.addSoundEvent(ver, "block.nether_bricks.break", "block");
        config.addSoundEvent(ver, "block.bone_block.step", "neutral");
        config.addSoundEvent(ver, "block.bone_block.break", "block");
        config.addSoundEvent(ver, "block.netherrack.step", "neutral");
        config.addSoundEvent(ver, "block.netherrack.break", "block");
        config.addSoundEvent(ver, "block.nether_ore.step", "neutral");
        config.addSoundEvent(ver, "block.nether_ore.break", "block");
        config.addSoundEvent(ver, "block.ancient_debris.step", "neutral");
        config.addSoundEvent(ver, "block.ancient_debris.break", "block");
        config.addSoundEvent(ver, "block.netherite_block.step", "neutral");
        config.addSoundEvent(ver, "block.netherite_block.break", "block");
        config.addSoundEvent(ver, "block.basalt.step", "neutral");
        config.addSoundEvent(ver, "block.basalt.break", "block");
        config.addSoundEvent(ver, "block.copper.step", "neutral");
        config.addSoundEvent(ver, "block.copper.break", "block");
        config.addSoundEvent(ver, "block.tuff.step", "neutral");
        config.addSoundEvent(ver, "block.tuff.break", "block");
        config.addSoundEvent(ver, "block.vine.step", "neutral");
        config.addSoundEvent(ver, "block.vine.break", "block");
        config.addSoundEvent(ver, "block.calcite.step", "neutral");
        config.addSoundEvent(ver, "block.calcite.break", "block");
        config.addSoundEvent(ver, "block.calcite.place", "block");
        config.addSoundEvent(ver, "block.amethyst_block.step", "neutral");
        config.addSoundEvent(ver, "block.amethyst_block.break", "block");
        config.addSoundEvent(ver, "block.amethyst_block.place", "block");
        config.addSoundEvent(ver, "block.small_amethyst_bud.break", "block");
        config.addSoundEvent(ver, "block.small_amethyst_bud.place", "block");
        config.addSoundEvent(ver, "block.medium_amethyst_bud.break", "block");
        config.addSoundEvent(ver, "block.medium_amethyst_bud.place", "block");
        config.addSoundEvent(ver, "block.large_amethyst_bud.break", "block");
        config.addSoundEvent(ver, "block.large_amethyst_bud.place", "block");
        config.addSoundEvent(ver, "block.amethyst_cluster.step", "neutral");
        config.addSoundEvent(ver, "block.amethyst_cluster.break", "block");
        config.addSoundEvent(ver, "block.amethyst_cluster.place", "block");
        config.addSoundEvent(ver, "block.lodestone.step", "neutral");
        config.addSoundEvent(ver, "block.lodestone.break", "block");
        config.addSoundEvent(ver, "block.lodestone.place", "block");
        config.addSoundEvent(ver, "block.dripstone_block.step", "neutral");
        config.addSoundEvent(ver, "block.dripstone_block.break", "block");
        config.addSoundEvent(ver, "block.pointed_dripstone.step", "neutral");
        config.addSoundEvent(ver, "block.pointed_dripstone.break", "block");
        config.addSoundEvent(ver, "block.wet_grass.step", "neutral");
        config.addSoundEvent(ver, "block.wet_grass.break", "block");
        config.addSoundEvent(ver, "block.wet_grass.place", "block");
        config.addSoundEvent(ver, "block.lily_pad.place", "block");
        config.addSoundEvent(ver, "block.sculk.break", "block");
        config.addSoundEvent(ver, "block.sculk.place", "block");
        config.addSoundEvent(ver, "block.sculk.step", "neutral");
        config.addSoundEvent(ver, "block.sculk_catalyst.break", "block");
        config.addSoundEvent(ver, "block.sculk_catalyst.place", "block");
        config.addSoundEvent(ver, "block.sculk_catalyst.step", "neutral");
        config.addSoundEvent(ver, "block.fungus.step", "neutral");
        config.addSoundEvent(ver, "block.stem.step", "neutral");
        config.addSoundEvent(ver, "block.stem.break", "block");
        config.addSoundEvent(ver, "block.azalea.step", "neutral");
        config.addSoundEvent(ver, "block.azalea.break", "block");
        config.addSoundEvent(ver, "block.azalea_leaves.step", "neutral");
        config.addSoundEvent(ver, "block.azalea_leaves.break", "block");
        config.addSoundEvent(ver, "block.hanging_roots.step", "neutral");
        config.addSoundEvent(ver, "block.hanging_roots.break", "block");
        config.addSoundEvent(ver, "block.rooted_dirt.step", "neutral");
        config.addSoundEvent(ver, "block.rooted_dirt.break", "block");
        config.addSoundEvent(ver, "block.moss.step", "neutral");
        config.addSoundEvent(ver, "block.moss.break", "block");
        config.addSoundEvent(ver, "block.moss_carpet.step", "neutral");
        config.addSoundEvent(ver, "block.moss_carpet.break", "block");
    }

    static {
        creativeTabItems = new CreativeTabs("etfuturum.items"){

            public Item func_78016_d() {
                return ConfigBlocksItems.enableNetherite ? ModItems.netherite_scrap : (ConfigBlocksItems.enablePrismarine ? ModItems.prismarine_shard : Items.field_151064_bs);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(List p_78018_1_) {
                for (int i : ModEntityList.eggIDs) {
                    p_78018_1_.add(new ItemStack(Items.field_151063_bx, 1, i));
                }
                super.func_78018_a(p_78018_1_);
            }
        };
        creativeTabBlocks = new CreativeTabs("etfuturum.blocks"){

            public Item func_78016_d() {
                return ConfigBlocksItems.enableSmoker ? Item.func_150898_a((Block)ModBlocks.smoker) : (ConfigBlocksItems.enableChorusFruit ? Item.func_150898_a((Block)ModBlocks.chorus_flower) : Item.func_150898_a((Block)Blocks.field_150477_bB));
            }
        };
        TESTING = Boolean.parseBoolean(System.getProperty("etfuturum.testing"));
        DEV_ENVIRONMENT = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        SNAPSHOT_BUILD = false;
        DEFAULT_COMPOST_CHANCES = new LinkedHashMap<ItemStack, Integer>();
        hasEnderlicious = Loader.isModLoaded((String)"enderlicious");
        hasIronChest = Loader.isModLoaded((String)"IronChest");
        hasNetherlicious = Loader.isModLoaded((String)"netherlicious");
        hasAetherLegacy = Loader.isModLoaded((String)"aether_legacy");
        hasWaila = Loader.isModLoaded((String)"Waila");
        hasThaumcraft = Loader.isModLoaded((String)"Thaumcraft");
        hasBluePower = Loader.isModLoaded((String)"bluepower");
        hasNP = Loader.isModLoaded((String)"netheriteplus");
        hasBotania = Loader.isModLoaded((String)"Botania");
        hasHEE = Loader.isModLoaded((String)"HardcoreEnderExpansion");
        hasIC2 = Loader.isModLoaded((String)"IC2");
        hasSkinPort = Loader.isModLoaded((String)"skinport");
        hasEars = Loader.isModLoaded((String)"ears");
        hasBaubles = Loader.isModLoaded((String)"Baubles");
        hasBaublesExpanded = Loader.isModLoaded((String)"Baubles|Expanded");
    }
}

