/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ganymedes01.etfuturum.client.gui.inventory.GuiBlastFurnace;
import ganymedes01.etfuturum.client.gui.inventory.GuiSmoker;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.recipes.BlastFurnaceRecipes;
import ganymedes01.etfuturum.recipes.SmokerRecipes;
import java.awt.Rectangle;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class NEI_EtFuturum_Config
implements IConfigureNEI {
    public void loadConfig() {
        FurnaceRecipeHandler handler;
        if (ConfigBlocksItems.enableSmoker) {
            handler = new NEI_Recipes_Smoker();
            GuiCraftingRecipe.craftinghandlers.add(handler);
            GuiUsageRecipe.usagehandlers.add(handler);
        }
        if (ConfigBlocksItems.enableBlastFurnace) {
            handler = new NEI_Recipes_BlastFurnace();
            GuiCraftingRecipe.craftinghandlers.add(handler);
            GuiUsageRecipe.usagehandlers.add(handler);
        }
    }

    public String getName() {
        return "Et Futurum Requiem NEI Plugin";
    }

    public String getVersion() {
        return "2.4.4";
    }

    public static class NEI_Recipes_BlastFurnace
    extends FurnaceRecipeHandler {
        public void loadTransferRects() {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), this.getOverlayIdentifier(), new Object[0]));
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        }

        public void loadCraftingRecipes(String outputId, Object ... results) {
            if (outputId.equals(this.getOverlayIdentifier())) {
                Map<ItemStack, ItemStack> recipes = BlastFurnaceRecipes.smelting().getSmeltingList();
                for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                    this.arecipes.add(new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, recipe.getKey(), recipe.getValue()));
                }
            } else {
                super.loadCraftingRecipes(outputId, results);
            }
        }

        public void loadCraftingRecipes(ItemStack result) {
            Map<ItemStack, ItemStack> recipes = BlastFurnaceRecipes.smelting().getSmeltingList();
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getValue(), (ItemStack)result)) continue;
                this.arecipes.add(new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, recipe.getKey(), recipe.getValue()));
            }
        }

        public void loadUsageRecipes(ItemStack ingredient) {
            Map<ItemStack, ItemStack> recipes = BlastFurnaceRecipes.smelting().getSmeltingList();
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getKey(), (ItemStack)ingredient)) continue;
                FurnaceRecipeHandler.SmeltingPair arecipe = new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, recipe.getKey(), recipe.getValue());
                this.arecipes.add(arecipe);
            }
        }

        public String getRecipeName() {
            return StatCollector.func_74838_a((String)"tile.etfuturum.blast_furnace.name");
        }

        public String getOverlayIdentifier() {
            return "etfuturum.blastfurnace";
        }

        public Class<? extends GuiContainer> getGuiClass() {
            return GuiBlastFurnace.class;
        }
    }

    public static class NEI_Recipes_Smoker
    extends FurnaceRecipeHandler {
        public void loadTransferRects() {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), this.getOverlayIdentifier(), new Object[0]));
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        }

        public void loadCraftingRecipes(String outputId, Object ... results) {
            if (outputId.equals(this.getOverlayIdentifier())) {
                Map<ItemStack, ItemStack> recipes = SmokerRecipes.smelting().getSmeltingList();
                for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                    this.arecipes.add(new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, recipe.getKey(), recipe.getValue()));
                }
            } else {
                super.loadCraftingRecipes(outputId, results);
            }
        }

        public void loadCraftingRecipes(ItemStack result) {
            Map<ItemStack, ItemStack> recipes = SmokerRecipes.smelting().getSmeltingList();
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getValue(), (ItemStack)result)) continue;
                this.arecipes.add(new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, recipe.getKey(), recipe.getValue()));
            }
        }

        public void loadUsageRecipes(ItemStack ingredient) {
            Map<ItemStack, ItemStack> recipes = SmokerRecipes.smelting().getSmeltingList();
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getKey(), (ItemStack)ingredient)) continue;
                FurnaceRecipeHandler.SmeltingPair arecipe = new FurnaceRecipeHandler.SmeltingPair((FurnaceRecipeHandler)this, recipe.getKey(), recipe.getValue());
                this.arecipes.add(arecipe);
            }
        }

        public String getRecipeName() {
            return StatCollector.func_74838_a((String)"tile.etfuturum.smoker.name");
        }

        public String getOverlayIdentifier() {
            return "etfuturum.smoker";
        }

        public Class<? extends GuiContainer> getGuiClass() {
            return GuiSmoker.class;
        }
    }
}

