/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.ExternalContent;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChorusPlant
extends Block
implements IConfigurable {
    public BlockChorusPlant() {
        super(Material.field_151585_k);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149766_f);
        this.func_149658_d("chorus_plant");
        this.func_149663_c(Utils.getUnlocalisedName("chorus_plant"));
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityDragon);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float down = this.canConnectTo(world, x, y - 1, z) ? 0.0f : 0.1875f;
        float up = this.canConnectTo(world, x, y + 1, z) ? 1.0f : 0.8125f;
        float west = this.canConnectTo(world, x - 1, y, z) ? 0.0f : 0.1875f;
        float east = this.canConnectTo(world, x + 1, y, z) ? 1.0f : 0.8125f;
        float north = this.canConnectTo(world, x, y, z - 1) ? 0.0f : 0.1875f;
        float south = this.canConnectTo(world, x, y, z + 1) ? 1.0f : 0.8125f;
        this.func_149676_a(west, down, north, east, up, south);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float down = this.canConnectTo((IBlockAccess)world, x, y - 1, z) ? 0.0f : 0.1875f;
        float up = this.canConnectTo((IBlockAccess)world, x, y + 1, z) ? 1.0f : 0.8125f;
        float west = this.canConnectTo((IBlockAccess)world, x - 1, y, z) ? 0.0f : 0.1875f;
        float east = this.canConnectTo((IBlockAccess)world, x + 1, y, z) ? 1.0f : 0.8125f;
        float north = this.canConnectTo((IBlockAccess)world, x, y, z - 1) ? 0.0f : 0.1875f;
        float south = this.canConnectTo((IBlockAccess)world, x, y, z + 1) ? 1.0f : 0.8125f;
        return AxisAlignedBB.func_72330_a((double)((float)x + west), (double)((float)y + down), (double)((float)z + north), (double)((float)x + east), (double)((float)y + up), (double)((float)z + south));
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.func_149668_a(world, x, y, z);
    }

    public boolean canConnectTo(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == this || block == ModBlocks.chorus_flower || BlockChorusPlant.canPlaceOn(block);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) || this.canSurviveAt(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!this.canSurviveAt(world, x, y, z)) {
            world.func_147480_a(x, y, z, true);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block p_149695_5_) {
        if (!this.canSurviveAt(world, x, y, z)) {
            world.func_147464_a(x, y, z, (Block)this, 1);
        }
    }

    public boolean canSurviveAt(World world, int x, int y, int z) {
        boolean flag = world.func_147437_c(x, y + 1, z);
        boolean flag1 = world.func_147437_c(x, y - 1, z);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            Block block;
            if (enumfacing.func_96559_d() != 0 || (block = world.func_147439_a(x + enumfacing.func_82601_c(), y, z + enumfacing.func_82599_e())) != this) continue;
            if (!flag && !flag1) {
                return false;
            }
            Block block1 = world.func_147439_a(x + enumfacing.func_82601_c(), y - 1, z + enumfacing.func_82599_e());
            if (block1 != this && !BlockChorusPlant.canPlaceOn(block1)) continue;
            return true;
        }
        Block block2 = world.func_147439_a(x, y - 1, z);
        return block2 == this || BlockChorusPlant.canPlaceOn(block2);
    }

    public static boolean canPlaceOn(Block block) {
        return block == Blocks.field_150377_bs || block == ExternalContent.enderlicious_end_rock || block == ExternalContent.hee_end_stone;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.CHORUS_PLANT;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return ModItems.chorus_fruit;
    }

    @Override
    public boolean isEnabled() {
        return ConfigBlocksItems.enableChorusFruit;
    }
}

