/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.api.IBlockObserver;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.ducks.IObserverWorldExtension;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockObserver
extends Block
implements IConfigurable,
IBlockObserver {
    @SideOnly(value=Side.CLIENT)
    private IIcon observerFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon observerBack;
    @SideOnly(value=Side.CLIENT)
    private IIcon observerTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon observerBackLit;

    public BlockObserver() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(3.0f);
        this.func_149663_c(Utils.getUnlocalisedName("observer"));
        this.func_149658_d("observer");
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int topSide;
        boolean powered;
        int k = BlockPistonBase.func_150076_b((int)meta);
        boolean bl = powered = (meta & 8) != 0;
        if (side == k) {
            return this.observerFront;
        }
        if (side == Facing.field_71588_a[k]) {
            return powered ? this.observerBackLit : this.observerBack;
        }
        switch (k) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                topSide = 1;
                break;
            }
            default: {
                topSide = 2;
            }
        }
        return side == topSide || side == Facing.field_71588_a[topSide] ? this.observerTop : this.field_149761_L;
    }

    public void func_149689_a(World p_149689_1_, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        int l = BlockPistonBase.func_150071_a((World)p_149689_1_, (int)p_149689_2_, (int)p_149689_3_, (int)p_149689_4_, (EntityLivingBase)p_149689_5_);
        p_149689_1_.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, Facing.field_71588_a[l], 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a("observer_side");
        this.observerFront = p_149651_1_.func_94245_a("observer_front");
        this.observerTop = p_149651_1_.func_94245_a("observer_top");
        this.observerBack = p_149651_1_.func_94245_a("observer_back");
        this.observerBackLit = p_149651_1_.func_94245_a("observer_back_lit");
    }

    public int func_149645_b() {
        return RenderIDs.OBSERVER;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return ConfigMixins.enableObservers;
    }

    @Override
    public void observedNeighborChange(World world, int observerX, int observerY, int observerZ, Block changedBlock, int changedX, int changedY, int changedZ) {
        if (world.field_72995_K) {
            return;
        }
        int myMeta = world.func_72805_g(observerX, observerY, observerZ);
        int facing = BlockPistonBase.func_150076_b((int)myMeta);
        int observedX = observerX + Facing.field_71586_b[facing];
        int observedY = observerY + Facing.field_71587_c[facing];
        int observedZ = observerZ + Facing.field_71585_d[facing];
        if (observedX == changedX && observedY == changedY && observedZ == changedZ && (myMeta & 8) == 0 && !((IObserverWorldExtension)world).etfu$hasScheduledUpdate(observerX, observerY, observerZ, this)) {
            world.func_147464_a(observerX, observerY, observerZ, (Block)this, 2);
        }
    }

    protected void updateNeighborsInFront(World worldIn, int x, int y, int z) {
        int facing = BlockPistonBase.func_150076_b((int)worldIn.func_72805_g(x, y, z));
        int opposite = Facing.field_71588_a[facing];
        int newX = x + Facing.field_71586_b[opposite];
        int newY = y + Facing.field_71587_c[opposite];
        int newZ = z + Facing.field_71585_d[opposite];
        worldIn.func_147460_e(newX, newY, newZ, (Block)this);
        worldIn.func_147441_b(newX, newY, newZ, (Block)this, facing);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) != 0) {
            world.func_72921_c(x, y, z, meta & 7, 2);
        } else {
            world.func_72921_c(x, y, z, meta | 8, 2);
            world.func_147464_a(x, y, z, (Block)this, 2);
        }
        this.updateNeighborsInFront(world, x, y, z);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess p_149748_1_, int p_149748_2_, int p_149748_3_, int p_149748_4_, int p_149748_5_) {
        return this.func_149709_b(p_149748_1_, p_149748_2_, p_149748_3_, p_149748_4_, p_149748_5_);
    }

    public int func_149709_b(IBlockAccess p_149709_1_, int p_149709_2_, int p_149709_3_, int p_149709_4_, int p_149709_5_) {
        int metadata = p_149709_1_.func_72805_g(p_149709_2_, p_149709_3_, p_149709_4_);
        if ((metadata & 8) == 0) {
            return 0;
        }
        return BlockPistonBase.func_150076_b((int)metadata) == p_149709_5_ ? 15 : 0;
    }
}

