/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BlockCauldronTileEntity;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.client.DynamicResourcePack;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import ganymedes01.etfuturum.tileentities.TileEntityCauldronColoredWater;
import ganymedes01.etfuturum.tileentities.TileEntityCauldronPotion;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockPotionCauldron
extends BlockCauldronTileEntity
implements ModBlocks.ISubBlocksBlock,
IConfigurable {
    public BlockPotionCauldron() {
        super(Material.field_151573_f);
        this.func_149672_a(Blocks.field_150383_bp.field_149762_H);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_149663_c(Utils.getUnlocalisedName("potion_cauldron"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(30) == 0) {
            int color = ((TileEntityCauldronColoredWater)world.func_147438_o(x, y, z)).getWaterColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float min = 0.1875f;
            float max = 0.8125f;
            double d0 = (float)x + (min + random.nextFloat() * (max - min));
            double d1 = (float)z + (min + random.nextFloat() * (max - min));
            world.func_72869_a("mobSpell", d0, (double)((float)y + BlockCauldron.func_150025_c((int)(world.func_72805_g(x, y, z) + 1))), d1, (double)r, (double)g, (double)b);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        ItemStack stack = entityPlayer.func_70694_bm();
        if (stack != null) {
            Item item = stack.func_77973_b();
            TileEntityCauldronPotion potionCauldron = (TileEntityCauldronPotion)world.func_147438_o(x, y, z);
            if (item == Items.field_151068_bn) {
                boolean shouldFill = true;
                if (potionCauldron.potion == null) {
                    potionCauldron.potion = stack;
                    potionCauldron.potion.field_77994_a = 1;
                    potionCauldron.potion.func_135074_t();
                    shouldFill = false;
                }
                boolean flag = false;
                int meta = world.func_72805_g(x, y, z);
                ItemStack bottle = new ItemStack(Items.field_151069_bo);
                List effects = ((ItemPotion)item).func_77832_l(stack);
                if (effects == null || !effects.equals(((ItemPotion)potionCauldron.potion.func_77973_b()).func_77832_l(potionCauldron.potion))) {
                    EnumCauldronFillAction.EVAPORATE.getAction(world, x, y, z, false);
                    world.func_147465_d(x, y, z, (Block)Blocks.field_150383_bp, 0, 3);
                    flag = true;
                } else if (meta < 2) {
                    EnumCauldronFillAction.CHANGE_LEVEL.getAction(world, x, y, z, true);
                    if (shouldFill) {
                        world.func_72921_c(x, y, z, meta + 1, 3);
                    }
                    flag = true;
                }
                if (flag && !entityPlayer.field_71075_bZ.field_75098_d) {
                    if (stack.field_77994_a <= 1) {
                        entityPlayer.func_70062_b(0, bottle);
                    } else {
                        entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                        if (!entityPlayer.field_71071_by.func_70441_a(bottle)) {
                            entityPlayer.func_71019_a(bottle, false);
                        }
                    }
                }
                return flag;
            }
            if (item == Items.field_151069_bo) {
                ItemStack newPotion = potionCauldron.potion.func_77946_l();
                if (stack.field_77994_a <= 1 && !entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.func_70062_b(0, newPotion);
                } else {
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                    }
                    if (!entityPlayer.field_71071_by.func_70441_a(newPotion)) {
                        entityPlayer.func_71019_a(newPotion, false);
                    }
                }
                EnumCauldronFillAction.CHANGE_LEVEL.getAction(world, x, y, z, false);
                if (world.func_72805_g(x, y, z) <= 0) {
                    world.func_147465_d(x, y, z, (Block)Blocks.field_150383_bp, 0, 3);
                } else {
                    world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) - 1, 3);
                }
                return true;
            }
            if (item == Items.field_151032_g) {
                int setMeta;
                int meta = world.func_72805_g(x, y, z);
                int tipmax = meta == 0 ? 16 : (meta == 1 ? 32 : 64);
                ItemStack tippedArrow = new ItemStack(ModItems.tipped_arrow, Math.min(stack.field_77994_a, tipmax), potionCauldron.potion.func_77960_j());
                int n = tippedArrow.field_77994_a >= tipmax ? -1 : (setMeta = meta - (tippedArrow.field_77994_a < 32 ? 1 : 2));
                if (!Items.field_151068_bn.func_77832_l(potionCauldron.potion).isEmpty() && potionCauldron.potion.func_77942_o() && potionCauldron.potion.func_77978_p().func_150297_b("CustomPotionEffects", 9)) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74782_a("CustomPotionEffects", potionCauldron.potion.func_77978_p().func_150295_c("CustomPotionEffects", 10).func_74737_b());
                    tippedArrow.func_77982_d(tag);
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d && tippedArrow.field_77994_a == stack.field_77994_a) {
                    entityPlayer.func_70062_b(0, tippedArrow);
                } else {
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, tipmax);
                    }
                    if (!entityPlayer.field_71071_by.func_70441_a(tippedArrow)) {
                        entityPlayer.func_71019_a(tippedArrow, false);
                    }
                }
                if (setMeta < 0) {
                    world.func_147465_d(x, y, z, (Block)Blocks.field_150383_bp, 0, 3);
                } else {
                    world.func_72921_c(x, y, z, setMeta, 3);
                }
                return true;
            }
        }
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.COLORED_CAULDRON;
    }

    public IIcon grayscaleWaterIcon() {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(DynamicResourcePack.createGrayscaleName("water_still", DynamicResourcePack.GrayscaleType.TINT_INVERSE));
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityCauldronPotion();
    }

    @Override
    public boolean isEnabled() {
        return ConfigBlocksItems.enablePotionCauldron;
    }

    static float getRenderLiquidLevel(int p_150025_0_) {
        int j = MathHelper.func_76125_a((int)p_150025_0_, (int)0, (int)3);
        return (float)(6 + 3 * j) / 16.0f;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return null;
    }

    public static enum EnumCauldronFillAction {
        CHANGE_LEVEL{

            @Override
            public void getAction(World world, int x, int y, int z, boolean filling) {
                int color = ((TileEntityCauldronColoredWater)world.func_147438_o(x, y, z)).getWaterColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                float liquidLevel = (float)y + BlockPotionCauldron.getRenderLiquidLevel(world.func_72805_g(x, y, z) + 1);
                if (ConfigSounds.fluidInteract) {
                    world.func_72908_a((double)x + 0.5, (double)liquidLevel, (double)z + 0.5, "minecraft_1.19.3:item.bottle." + (filling ? "fill" : "empty"), 1.0f, 1.0f);
                }
                for (int i = 0; i < world.field_73012_v.nextInt(4) + 4; ++i) {
                    world.func_72869_a("mobSpell", (double)this.getParticleXYCoord(x, world.field_73012_v), (double)liquidLevel, (double)this.getParticleXYCoord(z, world.field_73012_v), (double)r, (double)g, (double)b);
                }
            }
        }
        ,
        EVAPORATE{

            @Override
            public void getAction(World world, int x, int y, int z, boolean filling) {
                float min = 0.25f;
                float max = BlockPotionCauldron.getRenderLiquidLevel(world.func_72805_g(x, y, z) + 1);
                float liquidLevel = (float)y + (min + world.field_73012_v.nextFloat() * (max - min));
                world.func_72980_b((double)x + 0.5, (double)liquidLevel, (double)z + 0.5, "random.fizz", 0.3f, world.field_73012_v.nextFloat() * 0.6f + 0.4f, false);
                for (int i = 0; i < world.field_73012_v.nextInt(4) + 4; ++i) {
                    world.func_72869_a("explode", (double)this.getParticleXYCoord(x, world.field_73012_v), (double)liquidLevel, (double)this.getParticleXYCoord(z, world.field_73012_v), 0.0, 0.0, 0.0);
                }
            }
        };


        public abstract void getAction(World var1, int var2, int var3, int var4, boolean var5);

        protected float getParticleXYCoord(int coordinate, Random rand) {
            float min = 0.1875f;
            float max = 0.8125f;
            return (float)coordinate + (min + rand.nextFloat() * (max - min));
        }
    }
}

