/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTarget
extends Block
implements IConfigurable {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;

    public BlockTarget() {
        super(Material.field_151576_e);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.5f);
        this.func_149672_a(field_149780_i);
        this.func_149658_d("target");
        this.func_149663_c(Utils.getUnlocalisedName("target"));
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
        this.func_149672_a(field_149779_h);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a("target_side");
        this.topIcon = p_149651_1_.func_94245_a("target_top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : this.field_149761_L;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (world.field_72995_K) {
            return;
        }
        int power = world.func_72805_g(x, y, z);
        if (power == 0 && e instanceof IProjectile) {
            int newMeta = BlockTarget.determinePower(world, x, y, z, e);
            world.func_72921_c(x, y, z, newMeta, 3);
            int delay = e instanceof EntityArrow ? 20 : 8;
            world.func_147464_a(x, y, z, (Block)this, delay);
        }
    }

    private static int findSideHit(int p_150071_1_, int p_150071_2_, int p_150071_3_, Entity p_150071_4_) {
        int l;
        if (MathHelper.func_76135_e((float)((float)p_150071_4_.field_70165_t - (float)p_150071_1_)) < 2.0f && MathHelper.func_76135_e((float)((float)p_150071_4_.field_70161_v - (float)p_150071_3_)) < 2.0f) {
            double d0 = p_150071_4_.field_70163_u + 1.82 - (double)p_150071_4_.field_70129_M;
            if (d0 - (double)p_150071_2_ > 2.0) {
                return 1;
            }
            if ((double)p_150071_2_ - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(p_150071_4_.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0)));
    }

    private static double fractionalPos(double n) {
        return n - (double)MathHelper.func_76128_c((double)n);
    }

    private static int determinePower(World world, int x, int y, int z, Entity e) {
        MovingObjectPosition hit = world.func_147447_a(Vec3.func_72443_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v), Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5)), true, false, false);
        if (hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            double finalDiff;
            double xDiff = Math.abs(BlockTarget.fractionalPos(hit.field_72307_f.field_72450_a) - 0.5);
            double yDiff = Math.abs(BlockTarget.fractionalPos(hit.field_72307_f.field_72448_b) - 0.5);
            double zDiff = Math.abs(BlockTarget.fractionalPos(hit.field_72307_f.field_72449_c) - 0.5);
            switch (hit.field_72310_e) {
                default: {
                    finalDiff = Math.max(xDiff, zDiff);
                    break;
                }
                case 2: 
                case 3: {
                    finalDiff = Math.max(xDiff, yDiff);
                    break;
                }
                case 4: 
                case 5: {
                    finalDiff = Math.max(yDiff, zDiff);
                }
            }
            return Math.max(1, MathHelper.func_76143_f((double)(15.0 * MathHelper.func_151237_a((double)((0.5 - finalDiff) / 0.5), (double)0.0, (double)1.0))));
        }
        return 0;
    }

    public void func_149674_a(World p_149674_1_, int p_149674_2_, int p_149674_3_, int p_149674_4_, Random p_149674_5_) {
        p_149674_1_.func_72921_c(p_149674_2_, p_149674_3_, p_149674_4_, 0, 3);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess p_149748_1_, int p_149748_2_, int p_149748_3_, int p_149748_4_, int p_149748_5_) {
        return this.func_149709_b(p_149748_1_, p_149748_2_, p_149748_3_, p_149748_4_, p_149748_5_);
    }

    public int func_149709_b(IBlockAccess p_149709_1_, int p_149709_2_, int p_149709_3_, int p_149709_4_, int p_149709_5_) {
        return p_149709_1_.func_72805_g(p_149709_2_, p_149709_3_, p_149709_4_);
    }

    @Override
    public boolean isEnabled() {
        return ConfigBlocksItems.enableTarget;
    }
}

