/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.math.NumberUtils;

public class DynamicResourcePack
implements IResourcePack {
    private static final String GRAYSCALE_SUFFIX = "_grayscale";
    private static final HashMap<String, GrayscaleType> grayscaleTypes = new HashMap();

    public Set<String> func_110587_b() {
        return ImmutableSet.of((Object)"minecraft");
    }

    public InputStream func_110590_a(ResourceLocation resLoc) throws IOException {
        InputStream original = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.toNonGrayscaleLocation(resLoc)).func_110527_b();
        if (resLoc.func_110623_a().endsWith(".png")) {
            BufferedImage image = ImageIO.read(original);
            String[] fileName = resLoc.func_110623_a().split("/");
            image = DynamicResourcePack.convertImageToGrayscale(image, grayscaleTypes.get(fileName[fileName.length - 1].replace(".png", "")));
            byte[] data = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, "png", os);
                data = os.toByteArray();
            }
            return new ByteArrayInputStream(data);
        }
        return original;
    }

    private static BufferedImage convertImageToGrayscale(BufferedImage image, GrayscaleType type) {
        int referenceRGB = type == GrayscaleType.TINT_INVERSE ? DynamicResourcePack.findMaxRGB(image) : 0;
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                int a = DynamicResourcePack.rgbaToA(rgb);
                int r = DynamicResourcePack.rgbaToR(rgb);
                int g = DynamicResourcePack.rgbaToG(rgb);
                int b = DynamicResourcePack.rgbaToB(rgb);
                switch (type) {
                    case TINT_INVERSE: {
                        float referenceRelativeR = (float)r / (float)DynamicResourcePack.rgbaToR(referenceRGB);
                        float referenceRelativeG = (float)g / (float)DynamicResourcePack.rgbaToG(referenceRGB);
                        float referenceRelativeB = (float)b / (float)DynamicResourcePack.rgbaToB(referenceRGB);
                        float referenceRelativeLuma = Math.min(1.0f, referenceRelativeR * 0.299f + referenceRelativeG * 0.587f + referenceRelativeB * 0.114f);
                        g = b = (int)(referenceRelativeLuma * 255.0f);
                        r = b;
                        break;
                    }
                    case AVERAGE: {
                        g = b = (r + g + b) / 3;
                        r = b;
                        break;
                    }
                    case LIGHTNESS: {
                        g = b = (NumberUtils.min((int)r, (int)g, (int)b) + NumberUtils.max((int)r, (int)g, (int)b)) / 2;
                        r = b;
                        break;
                    }
                    default: {
                        r = (int)((double)r * 0.299);
                        g = (int)((double)g * 0.587);
                        b = (int)((double)b * 0.114);
                        g = b = r + g + b;
                        r = b;
                    }
                }
                copy.setRGB(x, y, DynamicResourcePack.toRGBA(r, g, b, a));
            }
        }
        return copy;
    }

    private static int findMaxRGB(BufferedImage image) {
        int maxR = 0;
        int maxG = 0;
        int maxB = 0;
        int max = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                int r = DynamicResourcePack.rgbaToR(rgb);
                int g = DynamicResourcePack.rgbaToG(rgb);
                int b = DynamicResourcePack.rgbaToB(rgb);
                int maxOfThis = Math.max(Math.max(r, g), b);
                if (maxOfThis <= max) continue;
                maxR = r;
                maxG = g;
                maxB = b;
                max = maxOfThis;
            }
        }
        return DynamicResourcePack.toRGBA(maxR, maxG, maxB, 0);
    }

    public boolean func_110589_b(ResourceLocation resLoc) {
        if (resLoc.func_110623_a().startsWith("textures/blocks") && resLoc.func_110623_a().contains("_grayscale.png")) {
            return this.resourceExistsSomewhere(this.toNonGrayscaleLocation(resLoc));
        }
        return false;
    }

    private boolean resourceExistsSomewhere(ResourceLocation resLoc) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private ResourceLocation toNonGrayscaleLocation(ResourceLocation resLoc) {
        return new ResourceLocation(resLoc.func_110624_b(), resLoc.func_110623_a().replaceFirst("_grayscale.png", ".png"));
    }

    public static String createGrayscaleName(String name) {
        return DynamicResourcePack.createGrayscaleName(name, GrayscaleType.LUMINOSITY);
    }

    public static String createGrayscaleName(String name, GrayscaleType type) {
        grayscaleTypes.put(name + GRAYSCALE_SUFFIX, type);
        return name + GRAYSCALE_SUFFIX;
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "Et Futurum Requiem dynamic resources";
    }

    public static void inject() {
        DynamicResourcePack dynamicResourcePack = new DynamicResourcePack();
        Minecraft.func_71410_x().field_110449_ao.add(dynamicResourcePack);
        IResourceManager resMan = Minecraft.func_71410_x().func_110442_L();
        if (resMan instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resMan).func_110545_a((IResourcePack)dynamicResourcePack);
        }
    }

    private static int rgbaToR(int rgba) {
        return rgba >> 16 & 0xFF;
    }

    private static int rgbaToG(int rgba) {
        return rgba >> 8 & 0xFF;
    }

    private static int rgbaToB(int rgba) {
        return rgba >> 0 & 0xFF;
    }

    private static int rgbaToA(int rgba) {
        return rgba >> 24 & 0xFF;
    }

    private static int toRGBA(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static enum GrayscaleType {
        LIGHTNESS,
        AVERAGE,
        LUMINOSITY,
        TINT_INVERSE;

    }
}

