/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.subtitle;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import org.lwjgl.opengl.GL11;

public class GuiSubtitles
extends Gui {
    public static GuiSubtitles INSTANCE;
    private final Minecraft mc;
    private final List<Subtitle> subtitles = new ArrayList<Subtitle>();
    private final Pattern subtitleBlacklistPattern;
    private static final Pattern MOB_SOUND;
    private static final Pattern FALL_SOUND;
    private static final HashMap<String, String> ENTITY_SOUND_NAME_TRANSLATION_MAP;

    public GuiSubtitles(Minecraft mc) {
        this.mc = mc;
        this.subtitleBlacklistPattern = Pattern.compile(ConfigFunctions.subtitleBlacklist);
    }

    private String smartTranslation(String key) {
        Matcher matcher = MOB_SOUND.matcher(key);
        if (matcher.matches()) {
            String mobId = ENTITY_SOUND_NAME_TRANSLATION_MAP.computeIfAbsent(matcher.group(1), id -> {
                for (String possible : EntityList.field_75625_b.keySet()) {
                    if (!id.equalsIgnoreCase(possible)) continue;
                    return possible;
                }
                return null;
            });
            if (mobId == null) {
                return null;
            }
            String soundType = matcher.group(2);
            String mobKey = "subtitle.mob." + soundType;
            String translated = StatCollector.func_74837_a((String)mobKey, (Object[])new Object[]{StatCollector.func_74838_a((String)("entity." + mobId + ".name"))});
            if (translated.equals(mobKey)) {
                return null;
            }
            return translated;
        }
        matcher = FALL_SOUND.matcher(key);
        if (matcher.matches()) {
            return StatCollector.func_74838_a((String)("subtitle.fall." + matcher.group(1)));
        }
        return null;
    }

    private String getSubtitleText(ISound sound, String name) {
        String key;
        String translated;
        if (this.subtitleBlacklistPattern.matcher(name).matches()) {
            return null;
        }
        if (name.startsWith("step.") || name.endsWith(".step")) {
            name = "footsteps";
        }
        if (name.endsWith(".place")) {
            name = "block.placed";
        }
        if (name.contains("\\.dig\\.") || name.endsWith(".break")) {
            name = "block.destroyed";
        }
        if ((translated = I18n.func_135052_a((String)(key = "subtitle." + name), (Object[])new Object[0])).equals(key)) {
            translated = this.smartTranslation(name);
            if (translated != null) {
                return translated;
            }
        } else {
            return translated;
        }
        return key;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRender(RenderGameOverlayEvent.Pre e) {
        if (e.type == RenderGameOverlayEvent.ElementType.CHAT) {
            this.renderSubtitles(new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d));
        }
    }

    @SubscribeEvent
    public void onPlaySound(SoundEvent.SoundSourceEvent e) {
        String s = this.getSubtitleText(e.sound, e.name.toLowerCase());
        if (s == null || e.sound.func_147656_j() == ISound.AttenuationType.NONE) {
            return;
        }
        Vec3 soundVec = Vec3.func_72443_a((double)e.sound.func_147649_g(), (double)e.sound.func_147654_h(), (double)e.sound.func_147651_i());
        if (!this.subtitles.isEmpty()) {
            for (Subtitle sub : this.subtitles) {
                if (!sub.getString().equals(s)) continue;
                sub.refresh(soundVec);
                return;
            }
        }
        this.subtitles.add(new Subtitle(s, soundVec));
    }

    public void renderSubtitles(ScaledResolution resolution) {
        if (!this.subtitles.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Vec3 vec3d = Vec3.func_72443_a((double)this.mc.field_71439_g.field_70165_t, (double)(this.mc.field_71439_g.field_70163_u + (double)this.mc.field_71439_g.func_70047_e()), (double)this.mc.field_71439_g.field_70161_v);
            Vec3 vec3d1 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)-1.0);
            vec3d1.func_72440_a(-this.mc.field_71439_g.field_70125_A * ((float)Math.PI / 180));
            vec3d1.func_72442_b(-this.mc.field_71439_g.field_70177_z * ((float)Math.PI / 180));
            Vec3 vec3d2 = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
            vec3d2.func_72440_a(-this.mc.field_71439_g.field_70125_A * ((float)Math.PI / 180));
            vec3d2.func_72442_b(-this.mc.field_71439_g.field_70177_z * ((float)Math.PI / 180));
            Vec3 vec3d3 = vec3d1.func_72431_c(vec3d2);
            int i = 0;
            int j = 0;
            Iterator<Subtitle> iterator = this.subtitles.iterator();
            while (iterator.hasNext()) {
                Subtitle sub = iterator.next();
                if (sub.getStartTime() + 3000L <= Minecraft.func_71386_F()) {
                    iterator.remove();
                    continue;
                }
                j = Math.max(j, this.mc.field_71466_p.func_78256_a(sub.getString()));
            }
            j = j + this.mc.field_71466_p.func_78256_a("<") + this.mc.field_71466_p.func_78256_a(" ") + this.mc.field_71466_p.func_78256_a(">") + this.mc.field_71466_p.func_78256_a(" ");
            for (Subtitle sub : this.subtitles) {
                int k = 255;
                String s = sub.getString();
                Vec3 vec3d4 = sub.getLocation().func_72444_a(vec3d).func_72432_b();
                double d0 = vec3d3.func_72430_b(vec3d4);
                double d1 = vec3d1.func_72430_b(vec3d4);
                boolean flag = d1 > 0.5;
                int l = j / 2;
                int i1 = this.mc.field_71466_p.field_78288_b;
                int j1 = i1 / 2;
                float f = 1.0f;
                int k1 = this.mc.field_71466_p.func_78256_a(s);
                double timeFactorSlide = (float)(Minecraft.func_71386_F() - sub.getStartTime()) / 3000.0f;
                if (timeFactorSlide < 0.0) {
                    timeFactorSlide = 0.0;
                } else if (timeFactorSlide > 1.0) {
                    timeFactorSlide = 1.0;
                }
                double timeFactor = 255.0 + -180.0 * timeFactorSlide;
                int l1 = MathHelper.func_76128_c((double)timeFactor);
                int i2 = l1 << 16 | l1 << 8 | l1;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)resolution.func_78326_a() - (float)l - 2.0f), (float)((float)(resolution.func_78328_b() - 30) - (float)(i * (i1 + 1))), (float)0.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GuiSubtitles.func_73734_a((int)(-l - 1), (int)(-j1 - 1), (int)(l + 1), (int)(j1 + 1), (int)-872415232);
                GL11.glEnable((int)3042);
                if (!flag) {
                    if (d0 > 0.0) {
                        this.mc.field_71466_p.func_78276_b(">", l - this.mc.field_71466_p.func_78256_a(">"), -j1, i2 + -16777216);
                    } else if (d0 < 0.0) {
                        this.mc.field_71466_p.func_78276_b("<", -l, -j1, i2 + -16777216);
                    }
                }
                this.mc.field_71466_p.func_78276_b(s, -k1 / 2, -j1, i2 + -16777216);
                GL11.glPopMatrix();
                ++i;
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    static {
        MOB_SOUND = Pattern.compile("mob\\.([a-zA-Z]+)\\.([a-zA-Z]+)$");
        FALL_SOUND = Pattern.compile("game\\.[a-zA-Z]+\\.hurt\\.fall\\.(small|big)");
        ENTITY_SOUND_NAME_TRANSLATION_MAP = new HashMap();
    }

    public static class Subtitle {
        private final String subtitle;
        private long startTime;
        private Vec3 location;

        public Subtitle(String subtitleIn, Vec3 locationIn) {
            this.subtitle = subtitleIn;
            this.location = locationIn;
            this.startTime = Minecraft.func_71386_F();
        }

        public String getString() {
            return this.subtitle;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Vec3 getLocation() {
            return this.location;
        }

        public void refresh(Vec3 locationIn) {
            this.location = locationIn;
            this.startTime = Minecraft.func_71386_F();
        }
    }
}

