/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.EtFuturumMixinPlugin;
import ganymedes01.etfuturum.api.elytra.IElytraPlayer;
import ganymedes01.etfuturum.blocks.BlockShulkerBox;
import ganymedes01.etfuturum.blocks.IMultiStepSound;
import ganymedes01.etfuturum.client.OpenGLHelper;
import ganymedes01.etfuturum.client.gui.GuiConfigWarning;
import ganymedes01.etfuturum.client.gui.GuiGamemodeSwitcher;
import ganymedes01.etfuturum.client.sound.ElytraSound;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.client.sound.NetherAmbienceLoop;
import ganymedes01.etfuturum.client.sound.NetherAmbienceSound;
import ganymedes01.etfuturum.configuration.ConfigBase;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.entities.EntityNewBoatWithChest;
import ganymedes01.etfuturum.network.ChestBoatOpenInventoryMessage;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import ganymedes01.etfuturum.tileentities.TileEntityShulkerBox;
import java.io.File;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.lwjgl.input.Keyboard;

public class ClientEventHandler {
    public static final ClientEventHandler INSTANCE = new ClientEventHandler();
    private Random rand = new Random();
    private boolean showedDebugWarning;
    public static boolean showDebugWarning;
    private int currPage;
    private static final Map<Entity, MutablePair<Float, Integer>> AMETHYST_CHIME_CACHE;
    private static final ItemStack STORAGE_STACK;
    private static final boolean forceHideSnapshotWarning;
    @SideOnly(value=Side.CLIENT)
    NetherAmbienceLoop ambienceLoop = null;
    @SideOnly(value=Side.CLIENT)
    int ticksToNextAmbience = this.rand.nextInt(80) + 1;
    @SideOnly(value=Side.CLIENT)
    BiomeGenBase ambienceBiome = null;
    private boolean wasShowingDebugInfo;
    private boolean wasShowingProfiler;
    private boolean pressedF3;
    private boolean eligibleForDebugInfoSwap = false;
    PositionedSound netherMusic;
    private float prevYOffset;
    public static int main_menu_display_count;

    private ClientEventHandler() {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ConfigFunctions.enableNewF3Behavior) {
            int key;
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (Keyboard.getEventKey() == 61) {
                this.pressedF3 = Keyboard.getEventKeyState();
                if (this.pressedF3) {
                    this.eligibleForDebugInfoSwap = true;
                }
                if (!this.pressedF3 && this.eligibleForDebugInfoSwap) {
                    mc.field_71474_y.field_74330_P = !mc.field_71474_y.field_74330_P;
                    mc.field_71474_y.field_74329_Q = GuiScreen.func_146272_n();
                }
            } else if (Keyboard.getEventKeyState() && (key = Keyboard.getEventKey()) != 42 && key != 54) {
                this.eligibleForDebugInfoSwap = false;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClientPlayerEntity();
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (world == null || event.phase == TickEvent.Phase.START || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (!EtFuturum.DEV_ENVIRONMENT && EtFuturum.SNAPSHOT_BUILD && !this.showedDebugWarning && player.field_70173_aa == 40) {
            if (!forceHideSnapshotWarning) {
                ChatComponentText text = new ChatComponentText("\u00a7c\u00a7l[Debug]: \u00a7rYou are using a pre-release version of \u00a7bEt \u00a7bFuturum \u00a7bRequiem\u00a7r. This version might not be stable, click here to go to GitHub to report bugs.");
                text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Roadhog360/Et-Futurum-Requiem/issues"));
                player.func_146105_b((IChatComponent)text);
            } else {
                System.out.println("WARNING: a pre-release version of Et Futurum Requiem is in use! This build may not be stable, expect more bugs than usual.");
                System.out.println("Be sure to report bugs at https://github.com/Roadhog360/Et-Futurum-Requiem/issues");
            }
            this.showedDebugWarning = true;
        }
        if (ConfigSounds.netherAmbience && !EtFuturum.netherAmbienceNetherlicious && player.field_71093_bK == -1) {
            Chunk chunk = world.func_72938_d(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v));
            if (!chunk.field_76636_d) {
                if (this.ambienceLoop != null && FMLClientHandler.instance().getClient().func_147118_V().func_147692_c((ISound)this.ambienceLoop)) {
                    FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.ambienceLoop);
                }
                this.ambienceLoop = null;
                this.ambienceBiome = null;
                return;
            }
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            this.ambienceBiome = world.func_72807_a(x, z);
            String soundLoc = "";
            if (this.ambienceLoop != null) {
                soundLoc = this.ambienceLoop.func_147650_b().func_110624_b() + ":" + this.ambienceLoop.func_147650_b().func_110623_a();
            }
            if (this.getAmbienceLoop(this.ambienceBiome) != null && !mc.func_147118_V().func_147692_c((ISound)this.ambienceLoop)) {
                Boolean flag = this.ambienceLoop == null || this.ambienceLoop.func_147653_e() <= 0.0f;
                this.ambienceLoop = new NetherAmbienceLoop(this.getAmbienceLoop(this.ambienceBiome));
                mc.func_147118_V().func_147682_a((ISound)this.ambienceLoop);
                if (flag.booleanValue()) {
                    this.ambienceLoop.fadeIn();
                }
            } else if (this.ambienceBiome == null || this.getAmbienceLoop(this.ambienceBiome) == null || !soundLoc.equals(this.getAmbienceLoop(this.ambienceBiome))) {
                this.ambienceLoop.stop();
            } else if (mc.func_147118_V().func_147692_c((ISound)this.ambienceLoop) && this.ambienceLoop.isStopping && soundLoc.equals(this.getAmbienceLoop(this.ambienceBiome))) {
                this.ambienceLoop.isStopping = false;
            }
            if (this.getAmbienceAdditions(this.ambienceBiome) != null && this.ambienceLoop != null && this.ticksToNextAmbience-- <= 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new NetherAmbienceSound(new ResourceLocation(this.getAmbienceAdditions(this.ambienceBiome))));
                this.ticksToNextAmbience = 50 + this.rand.nextInt(30) + 1;
            }
        }
        if (ConfigFunctions.enableGamemodeSwitcher && Keyboard.isCreated() && Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)62) && mc.field_71462_r == null) {
            mc.func_147108_a((GuiScreen)new GuiGamemodeSwitcher());
        }
        if (ConfigFunctions.enableNewF3Behavior && mc.field_71474_y.field_74330_P != this.wasShowingDebugInfo && Keyboard.isKeyDown((int)61)) {
            mc.field_71474_y.field_74330_P = this.wasShowingDebugInfo;
            mc.field_71474_y.field_74329_Q = this.wasShowingProfiler;
        }
        this.wasShowingDebugInfo = mc.field_71474_y.field_74330_P;
        this.wasShowingProfiler = mc.field_71474_y.field_74329_Q;
        if (mc.field_71462_r == null && this.currPage > -1) {
            this.currPage = -1;
        }
    }

    private String getStringFor(BiomeGenBase biome) {
        if (biome == null) {
            return null;
        }
        return "nether_wastes";
    }

    private String getAmbience(BiomeGenBase biome) {
        if (biome == null) {
            return null;
        }
        return "minecraft_1.19.3:ambient." + this.getStringFor(biome);
    }

    private String getAmbienceLoop(BiomeGenBase biome) {
        if (biome == null) {
            return null;
        }
        return this.getAmbience(biome) + ".loop";
    }

    private String getAmbienceMood(BiomeGenBase biome) {
        if (biome == null) {
            return null;
        }
        return this.getAmbience(biome) + ".mood";
    }

    private String getAmbienceAdditions(BiomeGenBase biome) {
        if (biome == null) {
            return null;
        }
        return this.getAmbience(biome) + ".additions";
    }

    private String getMusic(BiomeGenBase biome) {
        if (biome == null) {
            return null;
        }
        return "minecraft_1.19.3:music.nether." + this.getStringFor(biome);
    }

    @SubscribeEvent
    public void toolTipEvent(ItemTooltipEvent event) {
        if (ConfigFunctions.enableExtraF3HTooltips && event.showAdvancedItemTooltips) {
            event.toolTip.add("\u00a78" + Item.field_150901_e.func_148750_c((Object)event.itemStack.func_77973_b()));
            if (event.itemStack.field_77990_d != null && !event.itemStack.field_77990_d.func_82582_d()) {
                event.toolTip.add("\u00a78NBT: " + event.itemStack.field_77990_d.func_150296_c().size() + " Tag(s)");
            }
        }
    }

    @SubscribeEvent
    public void renderPlayerEventPre(RenderPlayerEvent.Pre event) {
        if (ConfigFunctions.enableTransparentAmour) {
            OpenGLHelper.enableBlend();
            OpenGLHelper.blendFunc(770, 771);
        }
    }

    @SubscribeEvent
    public void renderPlayerSetArmour(RenderPlayerEvent.SetArmorModel event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.result = 0;
        } else if (ConfigFunctions.enableTransparentAmour) {
            OpenGLHelper.enableBlend();
            OpenGLHelper.blendFunc(770, 771);
        }
    }

    @SubscribeEvent
    public void renderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (ConfigFunctions.enableTransparentAmour) {
            OpenGLHelper.disableBlend();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent17 event) {
        if (event.sound != null && event.name != null && FMLClientHandler.instance().getWorldClient() != null) {
            String s;
            WorldClient world = FMLClientHandler.instance().getWorldClient();
            float soundX = event.sound.func_147649_g();
            float soundY = event.sound.func_147654_h();
            float soundZ = event.sound.func_147651_i();
            int x = MathHelper.func_76141_d((float)soundX);
            int y = MathHelper.func_76141_d((float)soundY);
            int z = MathHelper.func_76141_d((float)soundZ);
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (event.sound.func_147655_f() < 1.0f && world.func_147439_a(x, y, z) instanceof IMultiStepSound && (!((IMultiStepSound)block).requiresNewBlockSounds() || ConfigSounds.newBlockSounds)) {
                IMultiStepSound multiSoundBlock = (IMultiStepSound)block;
                Block.SoundType newSound = multiSoundBlock.getStepSound((IBlockAccess)world, x, y, z, meta);
                if (newSound == null) {
                    return;
                }
                Block.SoundType blockSound = block.field_149762_H;
                String newSoundString = null;
                String[][] blockSounds = new String[][]{{blockSound.func_150498_e(), blockSound.func_150495_a(), blockSound.func_150496_b()}, {newSound.func_150498_e(), newSound.func_150495_a(), newSound.func_150496_b()}};
                for (int i = 0; i < blockSounds[0].length; ++i) {
                    String currentSound = blockSounds[0][i];
                    int index = currentSound.indexOf(58);
                    if (index != -1) {
                        currentSound = currentSound.substring(index + 1);
                    }
                    if (!event.name.equals(currentSound)) continue;
                    newSoundString = blockSounds[1][i];
                    break;
                }
                if (newSoundString != null) {
                    float soundVol = (block.field_149762_H.func_150497_c() + 1.0f) / (event.name.contains("step") ? 8.0f : 2.0f);
                    float soundPit = block.field_149762_H.func_150494_d() * (event.name.contains("step") ? 0.5f : 0.8f);
                    event.result = new PositionedSoundRecord(new ResourceLocation(newSoundString), soundVol, soundPit, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                }
                return;
            }
            String[] eventwithprefix = event.name.split("\\.");
            if (ConfigSounds.newBlockSounds && eventwithprefix.length > 1 && eventwithprefix[1].equals(Blocks.field_150348_b.field_149762_H.field_150501_a) && event.sound.func_147655_f() < 1.0f) {
                String blockName = "";
                Item item = Item.func_150898_a((Block)block);
                if (item != null && item.func_77614_k()) {
                    try {
                        STORAGE_STACK.func_150996_a(item);
                        STORAGE_STACK.func_77964_b(world.func_72805_g(x, y, z) % 8);
                        blockName = item.func_77667_c(STORAGE_STACK).toLowerCase();
                    }
                    catch (Exception newSoundString) {
                        // empty catch block
                    }
                }
                if (blockName.equals("")) {
                    blockName = block.func_149739_a().toLowerCase();
                }
                if (blockName.contains("slab") && blockName.contains("nether") && blockName.contains("brick")) {
                    float soundVol = (block.field_149762_H.func_150497_c() + 1.0f) / (eventwithprefix[0].contains("step") ? 8.0f : 2.0f);
                    float soundPit = block.field_149762_H.func_150494_d() * (eventwithprefix[0].contains("step") ? 0.5f : 0.8f);
                    boolean step = event.name.contains("step");
                    event.result = new PositionedSoundRecord(new ResourceLocation(step ? ModSounds.soundNetherBricks.func_150498_e() : ModSounds.soundNetherBricks.func_150495_a()), soundVol, soundPit, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                    return;
                }
            }
            if (ConfigSounds.doorOpenClose && event.name.contains("random.door")) {
                event.result = new PositionedSoundRecord(new ResourceLocation(this.getReplacementDoorSound(block, event.name)), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                return;
            }
            if (ConfigSounds.chestOpenClose && event.name.contains("random.chest")) {
                s = event.name;
                String blockID = Block.field_149771_c.func_148750_c((Object)block).split(":")[1].toLowerCase();
                if (blockID.contains("chest") && (event.name.contains("open") || event.name.contains("close"))) {
                    if (blockID.contains("ender") && block.func_149688_o().equals(Material.field_151576_e)) {
                        s = "minecraft_1.19.3:block.ender_chest." + (event.name.contains("close") ? "close" : "open");
                    } else if (block.func_149688_o().equals(Material.field_151575_d) && event.name.contains("close")) {
                        s = "minecraft_1.19.3:block.chest.close";
                    }
                }
                if (!s.equals(event.name)) {
                    event.result = new PositionedSoundRecord(new ResourceLocation(s), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                    return;
                }
            }
            if (ConfigSounds.pressurePlateButton) {
                if (block instanceof BlockButton && (block.field_149762_H == Block.field_149766_f || block.getClass().getSimpleName().toLowerCase().contains("wood")) && event.name.equals("random.click")) {
                    s = "minecraft_1.19.3:block.wooden_button.click_" + (meta > 7 ? "on" : "off");
                    event.result = new PositionedSoundRecord(new ResourceLocation(s), event.sound.func_147653_e(), event.sound.func_147655_f(), soundX, soundY, soundZ);
                    return;
                }
                if (block instanceof BlockBasePressurePlate && (block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151573_f) && event.name.equals("random.click")) {
                    String material = block.func_149688_o() == Material.field_151575_d ? "wooden" : "metal";
                    String s2 = "minecraft_1.19.3:block." + material + "_pressure_plate.click_" + (meta == 1 ? "on" : "off");
                    float soundAddition = meta == 1 && block.func_149688_o() == Material.field_151573_f ? 0.25f : 0.2f;
                    event.result = new PositionedSoundRecord(new ResourceLocation(s2), event.sound.func_147653_e(), event.sound.func_147655_f() + soundAddition, soundX, soundY, soundZ);
                    return;
                }
            }
            if (ConfigSounds.noteBlockNotes && world.func_147439_a(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY), MathHelper.func_76141_d((float)soundZ)) instanceof BlockNote && (event.name.equals("note.harp") || event.name.equals("note.snare") || event.name.equals("note.hat") || event.name.equals("note.bd"))) {
                String instrumentToPlay = event.name;
                String blockName = "";
                Block blockBeneath = world.func_147439_a(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY) - 1, MathHelper.func_76141_d((float)soundZ));
                Item item = Item.func_150898_a((Block)blockBeneath);
                if (item != null && item.func_77614_k()) {
                    try {
                        STORAGE_STACK.func_150996_a(item);
                        STORAGE_STACK.func_77964_b(world.func_72805_g(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY), MathHelper.func_76141_d((float)soundZ)));
                        blockName = item.func_77667_c(STORAGE_STACK).toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (blockName.equals("")) {
                    blockName = blockBeneath.func_149739_a().toLowerCase();
                }
                if (blockBeneath == Blocks.field_150425_aM) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.cow_bell";
                } else if (blockName.contains("hay")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.banjo";
                } else if (EtFuturum.hasDictTag(blockBeneath, "blockGold")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.bell";
                } else if (EtFuturum.hasDictTag(blockBeneath, "blockEmerald")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.bit";
                } else if (blockName.contains("packed") && blockName.contains("ice")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.chime";
                } else if (blockName.contains("pumpkin")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.didgeridoo";
                } else if (blockBeneath.func_149688_o() == Material.field_151571_B) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.flute";
                } else if (EtFuturum.hasDictTag(blockBeneath, "blockIron")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.iron_xylophone";
                } else if (blockBeneath.func_149688_o() == Material.field_151580_n) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.guitar";
                } else if (blockName.contains("bone") || blockName.contains("ivory")) {
                    instrumentToPlay = "minecraft_1.19.3:block.note_block.xylophone";
                }
                if (event.name.equals(instrumentToPlay)) {
                    return;
                }
                event.result = new PositionedSoundRecord(new ResourceLocation(instrumentToPlay), instrumentToPlay.equals("minecraft_1.19.3:block.note_block.iron_xylophone") ? 1.0f : event.sound.func_147653_e(), event.sound.func_147655_f(), soundX, soundY, soundZ);
                return;
            }
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiScreenBook && event.name.equals("gui.button.press")) {
                GuiScreenBook gui = (GuiScreenBook)Minecraft.func_71410_x().field_71462_r;
                if (gui.field_146484_x != this.currPage) {
                    this.currPage = gui.field_146484_x;
                    EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                    player.func_85030_a("minecraft_1.19.3:item.book.page_turn", 1.0f, 1.0f);
                    event.result = null;
                    return;
                }
            }
            if (!EtFuturum.netherMusicNetherlicious) {
                Minecraft mc = FMLClientHandler.instance().getClient();
                if (mc.field_71439_g.field_71093_bK == -1 && event.name.equals("music.game.nether")) {
                    if (this.netherMusic == null || !mc.func_147118_V().func_147692_c((ISound)this.netherMusic)) {
                        String music = this.getMusic(mc.field_71441_e.func_72938_d((int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70161_v).func_76591_a((int)mc.field_71439_g.field_70165_t & 0xF, (int)mc.field_71439_g.field_70161_v & 0xF, mc.field_71441_e.func_72959_q()));
                        if (music != null) {
                            this.netherMusic = PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation(music));
                            event.result = this.netherMusic;
                        }
                    } else {
                        event.result = null;
                    }
                }
            }
            if (ConfigSounds.rainSounds) {
                if (event.name.equals("ambient.weather.rain")) {
                    event.result = new PositionedSoundRecord(new ResourceLocation("minecraft_1.19.3:weather.rain" + (event.sound.func_147655_f() < 1.0f ? ".above" : "")), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                } else if (event.name.equals("ambient.cave.cave")) {
                    if (ConfigSounds.netherAmbience && FMLClientHandler.instance().getClientPlayerEntity().field_71093_bK == -1) {
                        BiomeGenBase biome = FMLClientHandler.instance().getWorldClient().func_72938_d(x, z).func_76591_a(x & 0xF, z & 0xF, FMLClientHandler.instance().getWorldClient().func_72959_q());
                        event.result = this.getAmbienceMood(biome) != null ? new PositionedSoundRecord(new ResourceLocation(this.getAmbienceMood(biome)), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f) : null;
                    } else if (new Random().nextInt(19) >= 13) {
                        event.result = new PositionedSoundRecord(new ResourceLocation("etfuturum:ambient.cave"), event.sound.func_147653_e(), event.sound.func_147655_f(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (event.name == null) {
            return;
        }
        Entity entity = event.entity;
        if (!event.entity.field_70170_p.field_72995_K) {
            if (ConfigSounds.horseEatCowMilk && event.entity instanceof EntityHorse && event.name.equals("eating")) {
                event.name = "minecraft_1.19.3:entity.horse.eat";
            }
            return;
        }
        if (ConfigSounds.heavyWaterSplashing && event.name.equals("game.player.swim.splash")) {
            float doWaterSplashEffect_f1 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w * (double)0.2f + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y * (double)0.2f)) * (entity.field_70153_n == null ? 0.2f : 0.9f);
            if (doWaterSplashEffect_f1 > 1.0f) {
                doWaterSplashEffect_f1 = 1.0f;
            }
            if ((double)doWaterSplashEffect_f1 >= 0.25) {
                event.name = "minecraft_1.19.3:entity.player.splash.high_speed";
                return;
            }
        }
        if (event.name != null) {
            int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)(event.entity.field_70163_u - (double)0.2f - (double)event.entity.field_70129_M));
            int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
            WorldClient world = FMLClientHandler.instance().getWorldClient();
            Block block = world.func_147439_a(x, y, z);
            if (world.func_147439_a(x, y, z) instanceof IMultiStepSound && (!((IMultiStepSound)block).requiresNewBlockSounds() || ConfigSounds.newBlockSounds)) {
                Block.SoundType stepSound = ((IMultiStepSound)block).getStepSound((IBlockAccess)world, x, y, z, world.func_72805_g(x, y, z));
                if (stepSound == null) {
                    return;
                }
                String stepSoundString = block.field_149762_H.func_150498_e();
                int index = stepSoundString.indexOf(58);
                if (index != -1) {
                    stepSoundString = stepSoundString.substring(index + 1);
                }
                if (event.name.equals(stepSoundString)) {
                    event.name = stepSound.func_150498_e();
                    return;
                }
            } else if (ConfigSounds.newBlockSounds) {
                if (event.name.equals(Block.field_149780_i.func_150498_e())) {
                    String[] eventwithprefix = event.name.split("\\.");
                    if (eventwithprefix.length > 1) {
                        String blockName = "";
                        Item item = Item.func_150898_a((Block)block);
                        if (item != null && item.func_77614_k()) {
                            try {
                                STORAGE_STACK.func_150996_a(item);
                                STORAGE_STACK.func_77964_b(world.func_72805_g(x, y, z) % 8);
                                blockName = item.func_77667_c(STORAGE_STACK).toLowerCase();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (blockName.equals("")) {
                            blockName = block.func_149739_a().toLowerCase();
                        }
                        if (blockName.contains("slab") && blockName.contains("nether") && blockName.contains("brick")) {
                            event.name = ModSounds.soundNetherBricks.func_150498_e();
                            return;
                        }
                    }
                } else if (ModSounds.soundAmethystBlock.func_150498_e().equals(event.name)) {
                    MutablePair pair = AMETHYST_CHIME_CACHE.get(event.entity);
                    if (pair == null) {
                        pair = new MutablePair((Object)Float.valueOf(0.0f), (Object)0);
                    }
                    float field_26997 = ((Float)pair.getLeft()).floatValue();
                    int lastChimeAge = (Integer)pair.getRight();
                    if (event.entity.field_70173_aa >= lastChimeAge + 20) {
                        field_26997 = (float)((double)field_26997 * Math.pow(0.997f, event.entity.field_70173_aa - lastChimeAge));
                        field_26997 = Math.min(1.0f, field_26997 + 0.07f);
                        float f = 0.5f + field_26997 * event.entity.field_70170_p.field_73012_v.nextFloat() * 1.2f;
                        float g = 0.1f + field_26997 * 1.2f;
                        event.entity.func_85030_a("minecraft_1.19.3:block.amethyst_block.chime", g, f);
                        lastChimeAge = event.entity.field_70173_aa;
                        pair.setLeft((Object)Float.valueOf(field_26997));
                        pair.setRight((Object)lastChimeAge);
                        AMETHYST_CHIME_CACHE.put(event.entity, (MutablePair<Float, Integer>)pair);
                    }
                }
            }
        }
    }

    private String getReplacementDoorSound(Block block, String string) {
        String closeOrOpen;
        Random random = new Random();
        String string2 = closeOrOpen = random.nextBoolean() ? "open" : "close";
        if (block instanceof BlockDoor) {
            if (block.func_149688_o() == Material.field_151575_d) {
                return "minecraft_1.19.3:block.wooden_door." + closeOrOpen;
            }
            if (block.func_149688_o() == Material.field_151573_f) {
                return "minecraft_1.19.3:block.iron_door." + closeOrOpen;
            }
        }
        if (block instanceof BlockTrapDoor) {
            if (block.func_149688_o() == Material.field_151575_d) {
                return "minecraft_1.19.3:block.wooden_trapdoor." + closeOrOpen;
            }
            if (block.func_149688_o() == Material.field_151573_f) {
                return "minecraft_1.19.3:block.iron_trapdoor." + closeOrOpen;
            }
        }
        if (block instanceof BlockFenceGate && block.func_149688_o() == Material.field_151575_d) {
            return "minecraft_1.19.3:block.fence_gate." + closeOrOpen;
        }
        return string;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ConfigMixins.enableElytra) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (!(player instanceof IElytraPlayer)) {
            return;
        }
        if (((IElytraPlayer)player).etfu$isElytraFlying()) {
            if (event.phase == TickEvent.Phase.START) {
                this.prevYOffset = player.field_70129_M;
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    player.field_70129_M = 3.02f;
                }
            } else {
                player.field_70129_M = this.prevYOffset;
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        TileEntityShulkerBox TE;
        int z;
        int y;
        int x;
        IElytraPlayer e;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (ConfigMixins.enableElytra && entity instanceof EntityPlayerSP && (e = (IElytraPlayer)entity).etfu$isElytraFlying() && !e.etfu$lastElytraFlying()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ElytraSound((EntityPlayerSP)entity));
        }
        if (entity.field_70122_E && (entity.field_70159_w != 0.0 || entity.field_70179_y != 0.0) && entity.field_70170_p.func_147439_a(x = MathHelper.func_76128_c((double)entity.field_70165_t), y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M)), z = MathHelper.func_76128_c((double)entity.field_70161_v)) instanceof BlockShulkerBox && (TE = (TileEntityShulkerBox)entity.field_70170_p.func_147438_o(x, y, z)) != null && world.field_72995_K && entity.func_70051_ag() && !entity.func_70090_H()) {
            EntityDiggingFX dig = new EntityDiggingFX(world, entity.field_70165_t + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.field_70121_D.field_72338_b + 0.1, entity.field_70161_v + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, TE.func_145838_q(), 0);
            dig.func_110125_a(((BlockShulkerBox)TE.func_145838_q()).colorIcons[TE.color]);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)dig.func_70596_a(x, y, z));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void openMainMenu(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu) {
            this.showedDebugWarning = false;
            if (EtFuturumMixinPlugin.launchConfigWarning && main_menu_display_count++ < 20) {
                EtFuturumMixinPlugin.launchConfigWarning = false;
                Configuration oldConfig = new Configuration(new File(Launch.minecraftHome, ConfigBase.PATH));
                oldConfig.setCategoryComment("warned", "This is added if we've warned you this file exists.\nUsed by versions that split the config into different files, rendering this file unused.\nThis was done because the current file was becoming difficult to navigate.");
                if (!oldConfig.getBoolean("configWarningShown", "warned", false, "")) {
                    event.gui = new GuiConfigWarning(event.gui, oldConfig);
                }
                oldConfig.getCategory((String)"warned").get((String)"configWarningShown").comment = "";
                oldConfig.save();
            }
        } else if (ConfigBlocksItems.enableNewBoats && event.gui instanceof GuiInventory && Minecraft.func_71410_x().field_71439_g.field_70154_o instanceof EntityNewBoatWithChest) {
            event.setCanceled(true);
            EtFuturum.networkWrapper.sendToServer((IMessage)new ChestBoatOpenInventoryMessage());
        }
    }

    static {
        AMETHYST_CHIME_CACHE = new WeakHashMap<Entity, MutablePair<Float, Integer>>();
        STORAGE_STACK = new ItemStack((Item)null, 1, 0);
        forceHideSnapshotWarning = Boolean.parseBoolean(System.getProperty("etfuturum.hideSnapshotWarning"));
        main_menu_display_count = 0;
    }
}

