/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import com.google.common.collect.ImmutableList;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CompostingRegistry {
    private static final Map<ItemStack, Integer> COMPOSTING_REGISTRY = new HashMap<ItemStack, Integer>();

    public static Map.Entry<ItemStack, Integer> getEntry(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, Integer> entry : COMPOSTING_REGISTRY.entrySet()) {
            if (entry.getKey().func_77973_b() != stack.func_77973_b() || entry.getKey().func_77960_j() != Short.MAX_VALUE && entry.getKey().func_77960_j() != stack.func_77960_j()) continue;
            return entry;
        }
        return null;
    }

    public static void removeCompostingResult(ItemStack stack) {
        Map.Entry<ItemStack, Integer> entry = CompostingRegistry.getEntry(stack);
        if (entry != null) {
            CompostingRegistry.getCompostingRegistry().remove(entry.getKey());
            return;
        }
        Logger.error("Mod " + Utils.getModContainer() + " tried to remove " + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + ":" + stack.func_77960_j() + " but it was not registered to the composter?");
    }

    public static int getCompostingPercent(ItemStack stack) {
        Map.Entry<ItemStack, Integer> entry = CompostingRegistry.getEntry(stack);
        if (entry != null) {
            return entry.getValue();
        }
        return 0;
    }

    public static void registerComposting(Object itemObj, int percent) {
        if (percent <= 0 || percent > 100) {
            throw new IllegalArgumentException("Mod " + Utils.getModContainer() + " tried to add a composter entry with percent value " + percent + " which is not allowed, should be above 0 and equal to or below 100!");
        }
        if (itemObj instanceof ItemStack) {
            COMPOSTING_REGISTRY.put(((ItemStack)itemObj).func_77946_l(), percent);
        } else if (itemObj instanceof String) {
            for (ItemStack oreStack : OreDictionary.getOres((String)((String)itemObj))) {
                COMPOSTING_REGISTRY.put(oreStack.func_77946_l(), percent);
            }
        } else if (itemObj instanceof Item) {
            COMPOSTING_REGISTRY.put(new ItemStack((Item)itemObj, 1, Short.MAX_VALUE), percent);
        } else if (itemObj instanceof Block && Item.func_150898_a((Block)((Block)itemObj)) != null) {
            COMPOSTING_REGISTRY.put(new ItemStack(Item.func_150898_a((Block)((Block)itemObj)), 1, Short.MAX_VALUE), percent);
        }
    }

    public static void registerComposting(List<Object> list, int percent) {
        list.forEach(o -> CompostingRegistry.registerComposting(o, percent));
    }

    public static Map<ItemStack, Integer> getCompostingRegistry() {
        return COMPOSTING_REGISTRY;
    }

    public static void init() {
        CompostingRegistry.registerComposting((List<Object>)ImmutableList.of((Object)new ItemStack(ModItems.beetroot_seeds), (Object)new ItemStack((Block)Blocks.field_150329_H, 1, 1), (Object)new ItemStack((Block)Blocks.field_150362_t, 1, Short.MAX_VALUE), (Object)new ItemStack(Items.field_151081_bc), (Object)new ItemStack(Items.field_151080_bb), (Object)"treeSapling", (Object)"treeLeaves", (Object)new ItemStack(Items.field_151014_N), (Object)new ItemStack(ModItems.sweet_berries)), 30);
        CompostingRegistry.registerComposting((List<Object>)ImmutableList.of((Object)new ItemStack(Blocks.field_150434_aF), (Object)new ItemStack(Items.field_151127_ba), (Object)new ItemStack(Items.field_151120_aE), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 2), (Object)new ItemStack(Blocks.field_150395_bd)), 50);
        CompostingRegistry.registerComposting((List<Object>)ImmutableList.of((Object)new ItemStack(Items.field_151034_e), (Object)new ItemStack(ModItems.beetroot), (Object)"cropCarrot", (Object)new ItemStack(Blocks.field_150375_by), (Object)new ItemStack((Block)Blocks.field_150329_H, 1, 2), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 3), BlockFlower.class, BlockLilyPad.class, (Object)new ItemStack(Blocks.field_150440_ba), (Object)new ItemStack((Block)Blocks.field_150338_P), (Object)new ItemStack((Block)Blocks.field_150337_Q), (Object)new ItemStack(Items.field_151075_bm), (Object[])new Object[]{"cropPotato", new ItemStack(Blocks.field_150423_aK), "cropWheat"}), 65);
        CompostingRegistry.registerComposting((List<Object>)ImmutableList.of((Object)new ItemStack(Items.field_151168_bH), (Object)new ItemStack(Items.field_151025_P), (Object)new ItemStack(Items.field_151106_aX), (Object)new ItemStack(Blocks.field_150407_cf), (Object)new ItemStack(Blocks.field_150419_aX, 1, Short.MAX_VALUE), (Object)new ItemStack(Blocks.field_150420_aW, 1, Short.MAX_VALUE)), 85);
        CompostingRegistry.registerComposting((List<Object>)ImmutableList.of((Object)new ItemStack(Items.field_151105_aU), (Object)new ItemStack(Items.field_151158_bO)), 100);
    }

    public void printCompostingRegistry() {
        CompostingRegistry.getCompostingRegistry().forEach((key, value) -> Logger.info("Composter entry: " + Item.field_150901_e.func_148750_c((Object)key.func_77973_b()) + " Meta: " + (key.func_77960_j() == Short.MAX_VALUE ? "any" : Integer.valueOf(key.func_77960_j()))));
    }
}

