/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.helpers.BlockAndMetadataMapping;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StrippedLogRegistry {
    private static final Map<BlockAndMetadataMapping, BlockAndMetadataMapping> strippedLogs = new HashMap<BlockAndMetadataMapping, BlockAndMetadataMapping>();

    public static void addLog(Block from, int fromMeta, Block to, int toMeta) {
        StrippedLogRegistry.addLog(new BlockAndMetadataMapping(from, fromMeta % 4), new BlockAndMetadataMapping(to, toMeta % 4));
    }

    private static void addLog(BlockAndMetadataMapping from, BlockAndMetadataMapping to) {
        strippedLogs.put(from, to);
    }

    public static boolean hasLog(Block block, int meta) {
        return StrippedLogRegistry.hasLog(new BlockAndMetadataMapping(block, meta % 4));
    }

    private static boolean hasLog(BlockAndMetadataMapping map) {
        return strippedLogs.containsKey(map);
    }

    public static BlockAndMetadataMapping getLog(Block block, int meta) {
        return StrippedLogRegistry.getLog(new BlockAndMetadataMapping(block, meta % 4));
    }

    private static BlockAndMetadataMapping getLog(BlockAndMetadataMapping map) {
        return strippedLogs.get(map);
    }

    public static Map<BlockAndMetadataMapping, BlockAndMetadataMapping> getLogMap() {
        return strippedLogs;
    }

    public static void init() {
        if (ConfigBlocksItems.enableStrippedLogs) {
            strippedLogs.put(new BlockAndMetadataMapping(Blocks.field_150364_r, 0), new BlockAndMetadataMapping(ModBlocks.log_stripped, 0));
            strippedLogs.put(new BlockAndMetadataMapping(Blocks.field_150364_r, 1), new BlockAndMetadataMapping(ModBlocks.log_stripped, 1));
            strippedLogs.put(new BlockAndMetadataMapping(Blocks.field_150364_r, 2), new BlockAndMetadataMapping(ModBlocks.log_stripped, 2));
            strippedLogs.put(new BlockAndMetadataMapping(Blocks.field_150364_r, 3), new BlockAndMetadataMapping(ModBlocks.log_stripped, 3));
            strippedLogs.put(new BlockAndMetadataMapping(Blocks.field_150363_s, 0), new BlockAndMetadataMapping(ModBlocks.log2_stripped, 0));
            strippedLogs.put(new BlockAndMetadataMapping(Blocks.field_150363_s, 1), new BlockAndMetadataMapping(ModBlocks.log2_stripped, 1));
            if (ConfigBlocksItems.enableBarkLogs) {
                strippedLogs.put(new BlockAndMetadataMapping(ModBlocks.log_bark, 0), new BlockAndMetadataMapping(ModBlocks.wood_stripped, 0));
                strippedLogs.put(new BlockAndMetadataMapping(ModBlocks.log_bark, 1), new BlockAndMetadataMapping(ModBlocks.wood_stripped, 1));
                strippedLogs.put(new BlockAndMetadataMapping(ModBlocks.log_bark, 2), new BlockAndMetadataMapping(ModBlocks.wood_stripped, 2));
                strippedLogs.put(new BlockAndMetadataMapping(ModBlocks.log_bark, 3), new BlockAndMetadataMapping(ModBlocks.wood_stripped, 3));
                strippedLogs.put(new BlockAndMetadataMapping(ModBlocks.log2_bark, 0), new BlockAndMetadataMapping(ModBlocks.wood2_stripped, 0));
                strippedLogs.put(new BlockAndMetadataMapping(ModBlocks.log2_bark, 1), new BlockAndMetadataMapping(ModBlocks.wood2_stripped, 1));
            }
        }
    }
}

