/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.versioning.ComparableVersion;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.lib.Reference;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import org.apache.commons.io.IOUtils;

public class VersionChecker
extends Thread {
    public static final VersionChecker instance = new VersionChecker();
    private static boolean isLatestVersion = false;
    private static boolean warnaboutfailure = false;
    private static String latestVersion = "";
    private static boolean isUpdateCheckFinished = false;
    private static boolean quitChecking = false;
    private static boolean hasThreadStarted = false;
    private static List<String> downloadURLs = new LinkedList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream in;
        block10: {
            in = null;
            try {
                URL url = new URL(Reference.VERSION_URL);
                in = url.openStream();
            }
            catch (Exception e) {
                if (warnaboutfailure) break block10;
                Logger.error("Could not connect with server to compare Et Futurum Requiem version");
                Logger.error("Check for new versions at the following websites:");
                Logger.error("https://modrinth.com/mod/etfuturum");
                Logger.error("https://www.curseforge.com/minecraft/mc-mods/et-futurum-requiem");
                Logger.error("https://github.com/Roadhog360/Et-Futurum-Requiem");
                warnaboutfailure = true;
            }
        }
        try {
            List lines = IOUtils.readLines((InputStream)in, (Charset)Charset.defaultCharset());
            latestVersion = (String)lines.get(0);
            for (int i = 1; i < lines.size(); ++i) {
                if (((String)lines.get(i)).startsWith("#") || !((String)lines.get(i)).contains("|")) continue;
                downloadURLs.add((String)lines.get(i));
            }
        }
        catch (Exception e) {
            if (!warnaboutfailure) {
                Logger.error("Failed to compare Et Futurum Requiem version");
                Logger.error("https://modrinth.com/mod/etfuturum");
                Logger.error("https://www.curseforge.com/minecraft/mc-mods/et-futurum-requiem");
                Logger.error("https://github.com/Roadhog360/Et-Futurum-Requiem");
                warnaboutfailure = true;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        boolean bl = isLatestVersion = new ComparableVersion("2.4.4").compareTo(new ComparableVersion(latestVersion)) >= 0;
        if (!(this.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null))) {
            Logger.info("This version of Et Futurum Requiem (2.4.4) differs from the latest version: " + latestVersion);
        }
        isUpdateCheckFinished = true;
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!(latestVersion != null && !latestVersion.equals("") || warnaboutfailure || hasThreadStarted)) {
            this.start();
            hasThreadStarted = true;
        }
        if (event.player.field_70173_aa >= 200 && !quitChecking && isUpdateCheckFinished) {
            Logger.error("Et Futurum Requiem version check failed.");
            Logger.error("Check for new versions at the following websites:");
            Logger.error("https://modrinth.com/mod/etfuturum");
            Logger.error("https://www.curseforge.com/minecraft/mc-mods/et-futurum-requiem");
            Logger.error("https://github.com/Roadhog360/Et-Futurum-Requiem");
            quitChecking = true;
        }
        if (event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END && event.player.field_70173_aa >= 40 && isUpdateCheckFinished && !quitChecking && !latestVersion.equals(null) && !latestVersion.equals("")) {
            quitChecking = true;
            if (!instance.isLatestVersion()) {
                String text = String.format(StatCollector.func_74838_a((String)"gui.chat.update"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.ITALIC.toString() + "Et Futurum Requiem" + EnumChatFormatting.RESET.toString(), EnumChatFormatting.YELLOW.toString() + latestVersion + EnumChatFormatting.RESET.toString());
                event.player.func_146105_b((IChatComponent)new ChatComponentText(text));
                ChatComponentText updateLinks = new ChatComponentText("");
                for (int i = 0; i < downloadURLs.size(); ++i) {
                    String url = downloadURLs.get(i);
                    Logger.debug(event);
                    ChatComponentText urlComponent = new ChatComponentText("[" + url.split("\\|")[0] + "]");
                    urlComponent.func_150256_b().func_150238_a(EnumChatFormatting.func_96300_b((String)url.split("\\|")[1]));
                    urlComponent.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    urlComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url.split("\\|")[2]));
                    ChatComponentText hoverComponent = new ChatComponentText(String.format(StatCollector.func_74838_a((String)"gui.chat.update.download"), url.split("\\|")[0]));
                    hoverComponent.func_150256_b().func_150238_a(urlComponent.func_150256_b().func_150215_a());
                    urlComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hoverComponent));
                    updateLinks.func_150257_a((IChatComponent)urlComponent);
                    if (downloadURLs.size() <= i) continue;
                    updateLinks.func_150258_a(" ");
                }
                event.player.func_146105_b((IChatComponent)updateLinks);
            }
        }
        if (quitChecking) {
            FMLCommonHandler.instance().bus().unregister((Object)instance);
            return;
        }
    }
}

