/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.helpers;

import com.google.common.collect.AbstractIterator;
import ganymedes01.etfuturum.core.utils.helpers.Vec3i;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos
extends Vec3i {
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockPos(double x, double y, double z) {
        super(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public BlockPos(Entity source) {
        this(source.field_70165_t, source.field_70163_u, source.field_70161_v);
    }

    public BlockPos(Vec3 source) {
        this(source.field_72450_a, source.field_72448_b, source.field_72449_c);
    }

    public BlockPos(Vec3i source) {
        this(source.getX(), source.getY(), source.getZ());
    }

    public BlockPos add(double x, double y, double z) {
        return new BlockPos((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public BlockPos add(int x, int y, int z) {
        return new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos add(Vec3i vec) {
        return new BlockPos(this.getX() + vec.getX(), this.getY() + vec.getY(), this.getZ() + vec.getZ());
    }

    public BlockPos multiply(int factor) {
        return new BlockPos(this.getX() * factor, this.getY() * factor, this.getZ() * factor);
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos subtract(Vec3i vec) {
        return new BlockPos(this.getX() - vec.getX(), this.getY() - vec.getY(), this.getZ() - vec.getZ());
    }

    public BlockPos up(int n) {
        return this.offset(EnumFacing.UP, n);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int n) {
        return this.offset(EnumFacing.DOWN, n);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos north(int n) {
        return this.offset(EnumFacing.NORTH, n);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos south(int n) {
        return this.offset(EnumFacing.SOUTH, n);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos west(int n) {
        return this.offset(EnumFacing.WEST, n);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos east(int n) {
        return this.offset(EnumFacing.EAST, n);
    }

    public BlockPos offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(EnumFacing facing, int n) {
        return new BlockPos(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
    }

    public BlockPos offset(ForgeDirection facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(ForgeDirection facing, int n) {
        return new BlockPos(this.getX() + facing.offsetX * n, this.getY() + facing.offsetY * n, this.getZ() + facing.offsetZ * n);
    }

    public BlockPos crossProductBP(Vec3i vec) {
        return new BlockPos(this.getY() * vec.getZ() - this.getZ() * vec.getY(), this.getZ() * vec.getX() - this.getX() * vec.getZ(), this.getX() * vec.getY() - this.getY() * vec.getX());
    }

    public long toLong() {
        return ((long)this.getX() & 0x3FFFFFFL) << 38 | ((long)this.getY() & 0xFFFL) << 26 | ((long)this.getZ() & 0x3FFFFFFL) << 0;
    }

    public static BlockPos fromLong(long serialized) {
        int j = (int)(serialized << 0 >> 38);
        int k = (int)(serialized << 26 >> 52);
        int l = (int)(serialized << 38 >> 38);
        return new BlockPos(j, k, l);
    }

    @Override
    public Vec3i crossProduct(Vec3i vec) {
        return this.crossProductBP(vec);
    }

    public static AxisAlignedBB getBB(BlockPos pos1, BlockPos pos2) {
        return AxisAlignedBB.func_72330_a((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ(), (double)pos2.getX(), (double)pos2.getY(), (double)pos2.getZ());
    }

    public static Iterable<BlockPos> iterate(BlockPos start, BlockPos end) {
        return BlockPos.iterate(Math.min(start.getX(), end.getX()), Math.min(start.getY(), end.getY()), Math.min(start.getZ(), end.getZ()), Math.max(start.getX(), end.getX()), Math.max(start.getY(), end.getY()), Math.max(start.getZ(), end.getZ()));
    }

    public static Iterable<BlockPos> iterate(final int startX, final int startY, final int startZ, final int endX, final int endY, final int endZ) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private boolean field_191534_b = true;
                    private int field_191535_c;
                    private int field_191536_d;
                    private int field_191537_e;

                    protected BlockPos computeNext() {
                        if (this.field_191534_b) {
                            this.field_191534_b = false;
                            this.field_191535_c = startX;
                            this.field_191536_d = startY;
                            this.field_191537_e = startZ;
                            return new BlockPos(startX, startY, startZ);
                        }
                        if (this.field_191535_c == endX && this.field_191536_d == endY && this.field_191537_e == endZ) {
                            return (BlockPos)this.endOfData();
                        }
                        if (this.field_191535_c < endX) {
                            ++this.field_191535_c;
                        } else if (this.field_191536_d < endY) {
                            this.field_191535_c = startX;
                            ++this.field_191536_d;
                        } else if (this.field_191537_e < endZ) {
                            this.field_191535_c = startX;
                            this.field_191536_d = startY;
                            ++this.field_191537_e;
                        }
                        return new BlockPos(this.field_191535_c, this.field_191536_d, this.field_191537_e);
                    }
                };
            }
        };
    }
}

