/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.helpers;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class BlockState {
    private final Object theObject;
    private final NBTTagCompound theCompound;
    private final BlockStateType type;
    private int theMeta;
    private Object[] entityContructorArgs;
    private ChestGenHooks lootTable;

    public BlockState(Block block, int meta, NBTTagCompound compound) {
        if (!(block instanceof ITileEntityProvider)) {
            throw new IllegalArgumentException("Tried to create a BlockState NBT with a block that isn't a block entity!");
        }
        this.theObject = block;
        this.theMeta = meta;
        this.type = BlockStateType.BLOCK_ENTITY;
        this.theCompound = compound;
    }

    public BlockState(Block block, int meta, NBTTagCompound compound, ChestGenHooks info) {
        if (!(block instanceof ITileEntityProvider)) {
            throw new IllegalArgumentException("Tried to create a BlockState NBT with a block that isn't a block entity!");
        }
        this.theObject = block;
        this.theMeta = meta;
        this.type = BlockStateType.BLOCK_ENTITY;
        this.theCompound = compound;
        this.lootTable = info;
    }

    public BlockState(Block block, int meta) {
        this.theObject = block;
        this.theMeta = meta;
        this.type = block instanceof ITileEntityProvider ? BlockStateType.BLOCK_ENTITY : BlockStateType.BLOCK;
        this.theCompound = block instanceof ITileEntityProvider ? new NBTTagCompound() : null;
    }

    public BlockState(Class<? extends Entity> entity, NBTTagCompound compound) {
        this.theObject = entity;
        this.theCompound = compound;
        this.type = BlockStateType.ENTITY;
    }

    public Block getBlock() {
        if (this.type == BlockStateType.ENTITY) {
            throw new IllegalArgumentException("Tried to get block instance from ENTITY in a BlockState object!");
        }
        return (Block)this.theObject;
    }

    public int getMeta() {
        if (this.type == BlockStateType.ENTITY) {
            throw new IllegalArgumentException("Tried to get metadata from ENTITY in a BlockState object!");
        }
        return this.theMeta;
    }

    public NBTTagCompound getCompound() {
        return this.theCompound;
    }

    public Entity createNewEntity(World world) {
        if (this.type != BlockStateType.ENTITY) {
            throw new IllegalArgumentException("Tried to get entity instance from a block in a BlockState object!");
        }
        return EntityList.func_75620_a((String)((String)EntityList.field_75626_c.get(this.theObject)), (World)world);
    }

    public ChestGenHooks getLootTable() {
        if (this.type != BlockStateType.BLOCK_ENTITY) {
            throw new IllegalArgumentException("Tried to get a loot table from a non-entity block!");
        }
        return this.lootTable;
    }

    public BlockStateType getType() {
        return this.type;
    }

    public static enum BlockStateType {
        BLOCK,
        BLOCK_ENTITY,
        ENTITY;

    }
}

