/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.helpers;

import ganymedes01.etfuturum.core.utils.helpers.OctavePerlinNoiseSampler;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Random;

public class DoublePerlinNoiseSampler {
    private static final double DOMAIN_SCALE = 1.0181268882175227;
    private static final double field_31703 = 0.3333333333333333;
    private final double amplitude;
    private final OctavePerlinNoiseSampler firstSampler;
    private final OctavePerlinNoiseSampler secondSampler;

    public static DoublePerlinNoiseSampler create(Random random, int offset, double ... octaves) {
        return new DoublePerlinNoiseSampler(random, offset, (TDoubleList)new TDoubleArrayList(octaves));
    }

    public static DoublePerlinNoiseSampler create(Random random, int offset, TDoubleList octaves) {
        return new DoublePerlinNoiseSampler(random, offset, octaves);
    }

    private DoublePerlinNoiseSampler(Random random, int offset, TDoubleList octaves) {
        this.firstSampler = OctavePerlinNoiseSampler.create(random, offset, octaves);
        this.secondSampler = OctavePerlinNoiseSampler.create(random, offset, octaves);
        int i = Integer.MAX_VALUE;
        int j = Integer.MIN_VALUE;
        for (double d : octaves) {
            int k = octaves.indexOf(d);
            if (d == 0.0) continue;
            i = Math.min(i, k);
            j = Math.max(j, k);
        }
        this.amplitude = 0.16666666666666666 / DoublePerlinNoiseSampler.createAmplitude(j - i);
    }

    private static double createAmplitude(int octaves) {
        return 0.1 * (1.0 + 1.0 / (double)(octaves + 1));
    }

    public double sample(double x, double y, double z) {
        double d = x * 1.0181268882175227;
        double e = y * 1.0181268882175227;
        double f = z * 1.0181268882175227;
        return (this.firstSampler.sample(x, y, z) + this.secondSampler.sample(d, e, f)) * this.amplitude;
    }
}

