/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.helpers;

import java.util.Random;
import net.minecraft.util.MathHelper;

public class SimplexNoiseSampler {
    protected static final int[][] GRADIENTS = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {0, -1, 1}, {-1, 1, 0}, {0, -1, -1}};
    private static final double SQRT_3 = Math.sqrt(3.0);
    private static final double SKEW_FACTOR_2D = 0.5 * (SQRT_3 - 1.0);
    private static final double UNSKEW_FACTOR_2D = (3.0 - SQRT_3) / 6.0;
    private final int[] permutations = new int[512];
    public final double originX;
    public final double originY;
    public final double originZ;

    public SimplexNoiseSampler(Random random) {
        this.originX = random.nextDouble() * 256.0;
        this.originY = random.nextDouble() * 256.0;
        this.originZ = random.nextDouble() * 256.0;
        int j = 0;
        while (j < 256) {
            this.permutations[j] = j++;
        }
        for (j = 0; j < 256; ++j) {
            int k = random.nextInt(256 - j);
            int l = this.permutations[j];
            this.permutations[j] = this.permutations[k + j];
            this.permutations[k + j] = l;
        }
    }

    private int getGradient(int hash) {
        return this.permutations[hash & 0xFF];
    }

    protected static double dot(int[] gArr, double x, double y, double z) {
        return (double)gArr[0] * x + (double)gArr[1] * y + (double)gArr[2] * z;
    }

    private double grad(int hash, double x, double y, double z, double distance) {
        double f;
        double d = distance - x * x - y * y - z * z;
        if (d < 0.0) {
            f = 0.0;
        } else {
            d *= d;
            f = d * d * SimplexNoiseSampler.dot(GRADIENTS[hash], x, y, z);
        }
        return f;
    }

    public double sample(double x, double y) {
        int o;
        int n;
        double g;
        double k;
        int j;
        double e;
        double d = (x + y) * SKEW_FACTOR_2D;
        int i = MathHelper.func_76128_c((double)(x + d));
        double f = (double)i - (e = (double)(i + (j = MathHelper.func_76128_c((double)(y + d)))) * UNSKEW_FACTOR_2D);
        double h = x - f;
        if (h > (k = y - (g = (double)j - e))) {
            n = 1;
            o = 0;
        } else {
            n = 0;
            o = 1;
        }
        double p = h - (double)n + UNSKEW_FACTOR_2D;
        double q = k - (double)o + UNSKEW_FACTOR_2D;
        double r = h - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
        double s = k - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
        int t = i & 0xFF;
        int u = j & 0xFF;
        int v = this.getGradient(t + this.getGradient(u)) % 12;
        int w = this.getGradient(t + n + this.getGradient(u + o)) % 12;
        int z = this.getGradient(t + 1 + this.getGradient(u + 1)) % 12;
        double aa = this.grad(v, h, k, 0.0, 0.5);
        double ab = this.grad(w, p, q, 0.0, 0.5);
        double ac = this.grad(z, r, s, 0.0, 0.5);
        return 70.0 * (aa + ab + ac);
    }

    public double sample(double x, double y, double z) {
        int bc;
        int ad;
        int ac;
        int ab;
        int aa;
        int w;
        double d = 0.3333333333333333;
        double e = (x + y + z) * 0.3333333333333333;
        int i = MathHelper.func_76128_c((double)(x + e));
        int j = MathHelper.func_76128_c((double)(y + e));
        int k = MathHelper.func_76128_c((double)(z + e));
        double f = 0.16666666666666666;
        double g = (double)(i + j + k) * 0.16666666666666666;
        double h = (double)i - g;
        double l = (double)j - g;
        double m = (double)k - g;
        double n = x - h;
        double o = y - l;
        double p = z - m;
        if (n >= o) {
            if (o >= p) {
                w = 1;
                aa = 0;
                ab = 0;
                ac = 1;
                ad = 1;
                bc = 0;
            } else if (n >= p) {
                w = 1;
                aa = 0;
                ab = 0;
                ac = 1;
                ad = 0;
                bc = 1;
            } else {
                w = 0;
                aa = 0;
                ab = 1;
                ac = 1;
                ad = 0;
                bc = 1;
            }
        } else if (o < p) {
            w = 0;
            aa = 0;
            ab = 1;
            ac = 0;
            ad = 1;
            bc = 1;
        } else if (n < p) {
            w = 0;
            aa = 1;
            ab = 0;
            ac = 0;
            ad = 1;
            bc = 1;
        } else {
            w = 0;
            aa = 1;
            ab = 0;
            ac = 1;
            ad = 1;
            bc = 0;
        }
        double bd = n - (double)w + 0.16666666666666666;
        double be = o - (double)aa + 0.16666666666666666;
        double bf = p - (double)ab + 0.16666666666666666;
        double bg = n - (double)ac + 0.3333333333333333;
        double bh = o - (double)ad + 0.3333333333333333;
        double bi = p - (double)bc + 0.3333333333333333;
        double bj = n - 1.0 + 0.5;
        double bk = o - 1.0 + 0.5;
        double bl = p - 1.0 + 0.5;
        int bm = i & 0xFF;
        int bn = j & 0xFF;
        int bo = k & 0xFF;
        int bp = this.getGradient(bm + this.getGradient(bn + this.getGradient(bo))) % 12;
        int bq = this.getGradient(bm + w + this.getGradient(bn + aa + this.getGradient(bo + ab))) % 12;
        int br = this.getGradient(bm + ac + this.getGradient(bn + ad + this.getGradient(bo + bc))) % 12;
        int bs = this.getGradient(bm + 1 + this.getGradient(bn + 1 + this.getGradient(bo + 1))) % 12;
        double bt = this.grad(bp, n, o, p, 0.6);
        double bu = this.grad(bq, bd, be, bf, 0.6);
        double bv = this.grad(br, bg, bh, bi, 0.6);
        double bw = this.grad(bs, bj, bk, bl, 0.6);
        return 32.0 * (bt + bu + bv + bw);
    }
}

