/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.entities.EntityNewBoatSeat;
import ganymedes01.etfuturum.entities.EntityNewBoatWithChest;
import ganymedes01.etfuturum.network.BoatMoveMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class EntityNewBoat
extends Entity {
    private static final int[] DATA_ID_PADDLE = new int[]{21, 22};
    private float[] paddlePositions = new float[2];
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    public int lerpSteps;
    private double boatPitch;
    private double lerpY;
    private double lerpZ;
    public double boatYaw;
    private double lerpXRot;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private double waterLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;
    private EntityNewBoatSeat seat;
    private EntityNewBoatSeat seatToSpawn;
    private String entityName;

    public EntityNewBoat(World p_i1704_1_) {
        super(p_i1704_1_);
        this.field_70156_m = true;
        this.func_70105_a(1.375f, 0.5625f);
    }

    public EntityNewBoat(World p_i1705_1_, double p_i1705_2_, double p_i1705_4_, double p_i1705_6_) {
        this(p_i1705_1_);
        this.func_70107_b(p_i1705_2_, p_i1705_4_, p_i1705_6_);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = p_i1705_2_;
        this.field_70167_r = p_i1705_4_;
        this.field_70166_s = p_i1705_6_;
    }

    public EntityNewBoatSeat getSeat() {
        return this.seat;
    }

    public void setSeat(EntityNewBoatSeat seatIn) {
        this.seat = seatIn;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
        for (int i = 0; i < DATA_ID_PADDLE.length; ++i) {
            this.field_70180_af.func_75682_a(DATA_ID_PADDLE[i], (Object)new Byte(0));
        }
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn instanceof EntityNewBoatSeat ? null : entityIn.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public boolean isPassenger(Entity entity) {
        return this.getPassengers().contains(entity);
    }

    public void removePassengers() {
        if (this.getPassengers().isEmpty()) {
            return;
        }
        for (EntityLivingBase passenger : this.getPassengers()) {
            passenger.func_70078_a(null);
        }
    }

    public List<EntityLivingBase> getPassengers() {
        ArrayList<EntityLivingBase> list = new ArrayList<EntityLivingBase>();
        if (this.field_70153_n instanceof EntityLivingBase) {
            list.add((EntityLivingBase)this.field_70153_n);
            if (this.seat != null && this.seat.field_70153_n != null) {
                list.add((EntityLivingBase)this.seat.field_70153_n);
            }
        }
        return list;
    }

    public void sitEntity(Entity entity) {
        entity.func_70078_a((Entity)this);
    }

    private void addToSeat(Entity entity) {
        this.seat.sitEntity(entity);
    }

    public void addToBoat(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase oldDriver = (EntityLivingBase)this.getControllingPassenger();
        if (this.getPassengers().isEmpty()) {
            this.sitEntity(entity);
        } else if (this.getPassengers().size() == 1) {
            if (this.seat == null) {
                return;
            }
            if (entity instanceof EntityPlayer && !(oldDriver instanceof EntityPlayer)) {
                this.addToSeat((Entity)oldDriver);
                entity.func_70078_a((Entity)this);
            } else {
                this.addToSeat(entity);
            }
        }
        entity.field_70126_B = this.field_70177_z;
        entity.field_70177_z = this.field_70177_z;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!player.func_70093_af() && this.outOfControlTicks < 60.0f) {
            this.addToBoat((Entity)player);
        }
        return true;
    }

    public boolean isBeingRidden() {
        return !this.getPassengers().isEmpty();
    }

    public boolean canPassengerSteer() {
        return !this.field_70170_p.field_72995_K || this.getControllingPassenger() instanceof EntityPlayer && this.field_70153_n == this.getControllingPassenger();
    }

    protected boolean canFitPassenger(Entity passenger) {
        return this.getPassengers().size() < 2;
    }

    public Entity getControllingPassenger() {
        List<EntityLivingBase> list = this.getPassengers();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.isPassenger(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    ItemStack boat = new ItemStack(this.getItemBoat());
                    if (this.entityName != null) {
                        boat.func_151001_c(this.entityName);
                    }
                    this.func_70099_a(boat, 0.0f);
                    if (this instanceof EntityNewBoatWithChest && !ConfigFunctions.dropVehiclesTogether) {
                        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150486_ae), 1);
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_70106_y() {
        if (this.field_70153_n instanceof EntityLivingBase) {
            ((EntityLivingBase)this.field_70153_n).func_110145_l((Entity)this);
            ((EntityLivingBase)this.field_70153_n).field_70154_o = null;
        }
        super.func_70106_y();
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityNewBoat && entityIn.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            super.func_70108_f(entityIn);
        }
        if (entityIn instanceof EntityNewBoatSeat || this.getPassengers().contains(entityIn) || entityIn.field_70154_o instanceof EntityNewBoat || entityIn.field_70154_o instanceof EntityNewBoatSeat) {
            return;
        }
        if (entityIn.field_70121_D.field_72338_b <= this.field_70121_D.field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public Item getItemBoat() {
        if (this.getBoatType() == Type.OAK) {
            return ConfigBlocksItems.replaceOldBoats ? Items.field_151124_az : ModItems.boats[0];
        }
        return ModItems.boats[this.getBoatType().ordinal()];
    }

    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.boatPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpXRot = pitch;
        this.lerpSteps = 5;
        this.boatYaw = yaw;
    }

    public EnumFacing getAdjustedHorizontalFacing() {
        return this.getAdjustedHorizontalFacing();
    }

    public boolean hasSeat() {
        return this.seat != null && !this.seat.field_70128_L;
    }

    protected boolean shouldHaveSeat() {
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && !this.hasSeat() && ConfigBlocksItems.newBoatPassengerSeat && this.shouldHaveSeat()) {
            EntityNewBoatSeat newSeat;
            if (this.seatToSpawn == null) {
                newSeat = new EntityNewBoatSeat(this.field_70170_p, this);
                newSeat.setBoat(this);
            } else {
                newSeat = this.seatToSpawn;
                this.seatToSpawn = null;
            }
            newSeat.field_98038_p = true;
            newSeat.func_82149_j(this);
            this.field_70170_p.func_72838_d((Entity)newSeat);
            this.setSeat(newSeat);
            newSeat.field_98038_p = false;
        }
        if (this.getSeat() != null && this.getSeat().field_70153_n != null && this.field_70153_n == null) {
            this.sitEntity(this.getSeat().field_70153_n);
        }
    }

    private void collideWithSurfaceBlocks() {
        AxisAlignedBB box = this.field_70121_D;
        int minX = MathHelper.func_76128_c((double)(box.field_72340_a - 0.2));
        int minY = MathHelper.func_76128_c((double)(box.field_72338_b - 0.2));
        int minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 0.2));
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 0.2));
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 0.2));
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 0.2));
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (block == Blocks.field_150431_aC) {
                        this.field_70170_p.func_147468_f(x, y, z);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_147480_a(x, y, z, true);
                    this.field_70123_F = false;
                }
            }
        }
    }

    public void func_70071_h_() {
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
            this.removePassengers();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        if (this.canPassengerSteer()) {
            this.collideWithSurfaceBlocks();
            if (this.getPassengers().size() == 0) {
                this.setPaddleState(false, false);
            }
            this.updateMotion();
            if (this.getPassengers().size() > 0 && this.getControllingPassenger() instanceof EntityPlayer) {
                EntityPlayer living = (EntityPlayer)this.getControllingPassenger();
                boolean left = living.field_70702_br > 0.0f;
                boolean right = living.field_70702_br < 0.0f;
                boolean forward = living.field_70701_bs > 0.0f;
                boolean back = living.field_70701_bs < 0.0f;
                this.updateInputs(left, right, forward, back);
            } else {
                this.updateInputs(false, false, false, false);
            }
            this.controlBoat();
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.deltaRotation = 0.0f;
        }
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                if ((double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981633974483 && ((double)this.paddlePositions[i] + (double)0.3926991f) % (Math.PI * 2) >= 0.7853981633974483 && this.getPaddleSound() != null) {
                    this.func_85030_a(this.getPaddleSound(), 1.0f, 1.0f);
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.getControllingPassenger() instanceof EntityPlayer);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.field_70154_o == this) continue;
                if (flag && this.getPassengers().size() < 2 && !entity.func_70115_ae() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityPlayer)) {
                    if (!this.canEntitySit(entity)) continue;
                    this.addToBoat(entity);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
        if (this.field_70170_p.field_72995_K && this.canPassengerSteer() && this.getControllingPassenger() instanceof EntityClientPlayerMP) {
            EtFuturum.networkWrapper.sendToServer((IMessage)new BoatMoveMessage(this));
        }
    }

    private boolean canEntitySit(Entity entity) {
        if (ConfigBlocksItems.newBoatEntityBlacklist.length == 0) {
            return !ConfigBlocksItems.newBoatEntityBlacklistAsWhitelist;
        }
        if (ArrayUtils.contains((Object[])ConfigBlocksItems.newBoatEntityBlacklist, (Object)EntityList.func_75621_b((Entity)entity))) {
            return ConfigBlocksItems.newBoatEntityBlacklistAsWhitelist;
        }
        for (int i = 0; i < ConfigBlocksItems.newBoatEntityBlacklist.length; ++i) {
            String blacklistEntry = ConfigBlocksItems.newBoatEntityBlacklist[i];
            if (!blacklistEntry.startsWith("classpath:") || !entity.getClass().getName().contains(blacklistEntry.replace("classpath:", ""))) continue;
            return ConfigBlocksItems.newBoatEntityBlacklistAsWhitelist;
        }
        return !ConfigBlocksItems.newBoatEntityBlacklistAsWhitelist;
    }

    protected String getPaddleSound() {
        switch (this.status) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return "minecraft_1.19.3:entity.boat.paddle_water";
            }
            case ON_LAND: {
                return "minecraft_1.19.3:entity.boat.paddle_land";
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.field_70170_p.field_72995_K && this.lerpSteps > 0) {
            if (this.field_70170_p.field_72995_K && this.getSeat() != null && this.getSeat().field_70153_n instanceof EntityClientPlayerMP) {
                double i = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.getSeat().field_70153_n.field_70177_z = (float)((double)this.getSeat().field_70153_n.field_70177_z + i / (double)this.lerpSteps);
                i = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70126_B));
                this.getSeat().field_70153_n.field_70126_B = (float)((double)this.getSeat().field_70153_n.field_70126_B + i / (double)this.lerpSteps);
            }
            if (!(this.getControllingPassenger() instanceof EntityClientPlayerMP)) {
                double d0 = this.field_70165_t + (this.boatPitch - this.field_70165_t) / (double)this.lerpSteps;
                double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
                double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
                double d3 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
                --this.lerpSteps;
                this.func_70107_b(d0, d1, d2);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        }
    }

    public void setPaddleState(boolean p_184445_1_, boolean p_184445_2_) {
        this.field_70180_af.func_75692_b(DATA_ID_PADDLE[0], (Object)new Byte((byte)(p_184445_1_ ? 1 : 0)));
        this.field_70180_af.func_75692_b(DATA_ID_PADDLE[1], (Object)new Byte((byte)(p_184445_2_ ? 1 : 0)));
    }

    @SideOnly(value=Side.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    private Status getBoatStatus() {
        Status EntityNewBoat$status = this.getUnderwaterStatus();
        if (EntityNewBoat$status != null) {
            this.waterLevel = this.field_70121_D.field_72337_e;
            return EntityNewBoat$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = Math.min(this.getBoatGlide(), ConfigBlocksItems.newBoatMaxLandSpeed);
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.field_70121_D;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            int l1 = i;
            while (true) {
                if (l1 >= j) {
                    if (!(f < 1.0f)) continue block0;
                    float f2 = (float)k1 + f;
                    return f2;
                }
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block iblockstate = this.field_70170_p.func_147439_a(l1, k1, i2);
                    if (iblockstate.func_149688_o() == Material.field_151586_h) {
                        f = Math.max(f, EntityNewBoat.getBlockLiquidHeight(this.field_70170_p, l1, k1, i2));
                    }
                    if (f >= 1.0f) continue block0;
                }
                ++l1;
            }
        }
        float f1 = l + 1;
        return f1;
    }

    public float getBoatGlide() {
        AxisAlignedBB axisalignedbb = this.field_70121_D;
        AxisAlignedBB axisalignedbb1 = AxisAlignedBB.func_72330_a((double)axisalignedbb.field_72340_a, (double)(axisalignedbb.field_72338_b - 0.001), (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        ArrayList list = Lists.newArrayList();
        float f = 0.0f;
        int k1 = 0;
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    Block iblockstate = this.field_70170_p.func_147439_a(l1, k2, i2);
                    iblockstate.func_149743_a(this.field_70170_p, l1, k2, i2, axisalignedbb1, (List)list, (Entity)this);
                    if (!list.isEmpty()) {
                        f += iblockstate.field_149765_K;
                        ++k1;
                    }
                    list.clear();
                }
            }
        }
        return f == 0.0f || k1 == 0 ? 0.0f : f / (float)k1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.field_70121_D;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block iblockstate = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (iblockstate.func_149688_o() != Material.field_151586_h) continue;
                    float f = EntityNewBoat.getLiquidHeight(this.field_70170_p, k1, l1, i2);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    if (!(flag |= axisalignedbb.field_72338_b < (double)f)) continue;
                    return true;
                }
            }
        }
        return flag;
    }

    private Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.field_70121_D;
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block iblockstate = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (iblockstate.func_149688_o() != Material.field_151586_h || !(d0 < (double)EntityNewBoat.getLiquidHeight(this.field_70170_p, k1, l1, i2))) continue;
                    if (this.field_70170_p.func_72805_g(k1, l1, i2) != 0) {
                        Status EntityNewBoat$status = Status.UNDER_FLOWING_WATER;
                        return EntityNewBoat$status;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    public static float getBlockLiquidHeight(World world, int x, int y, int z) {
        int i = world.func_72805_g(x, y, z);
        return i % 8 == 0 && world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151586_h ? 1.0f : 1.0f - BlockLiquid.func_149801_b((int)i);
    }

    public static float getLiquidHeight(World world, int x, int y, int z) {
        return (float)y + EntityNewBoat.getBlockLiquidHeight(world, x, y, z);
    }

    private void updateMotion() {
        double d0;
        double d1 = d0 = (double)-0.04f;
        double d2 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.func_70046_E().field_72338_b + (double)this.field_70131_O;
            this.func_70107_b(this.field_70165_t, (double)(this.getWaterLevelAbove() - this.field_70131_O) + 0.101, this.field_70161_v);
            this.field_70181_x = 0.0;
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_70046_E().field_72338_b) / (double)this.field_70131_O;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.momentum = this.boatGlide;
                if (this.getControllingPassenger() instanceof EntityPlayer) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.field_70159_w *= (double)this.momentum;
            this.field_70179_y *= (double)this.momentum;
            this.deltaRotation *= this.momentum;
            this.field_70181_x += d1;
            if (d2 > 0.0) {
                double d3 = 0.65;
                this.field_70181_x += d2 * (-d0 / 0.65);
                double d4 = 0.75;
                this.field_70181_x *= 0.75;
            }
        }
    }

    private void controlBoat() {
        if (this.isBeingRidden()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation += -1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                f += 0.04f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * (f *= ConfigBlocksItems.newBoatSpeed));
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
            if (!this.field_70170_p.field_72995_K) {
                this.setPaddleState(this.rightInputDown || this.forwardInputDown, this.leftInputDown || this.forwardInputDown);
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.updatePassenger(this.field_70153_n);
        }
    }

    protected float getDefaultRiderOffset() {
        return 0.0f;
    }

    public void updatePassenger(Entity passenger) {
        float f = this.getDefaultRiderOffset();
        float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
        if (this.getPassengers().size() > 1) {
            int i = this.getPassengers().indexOf(passenger);
            f = i == 0 ? 0.2f : -0.6f;
            if (passenger instanceof EntityAnimal) {
                f = (float)((double)f + 0.2);
            }
        }
        Vec3 vec3d = Vec3.func_72443_a((double)f, (double)0.0, (double)0.0);
        vec3d.func_72442_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
        passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
        passenger.field_70177_z += this.deltaRotation;
        this.applyYawToEntity(passenger);
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        int j = 0;
        if (entityToUpdate instanceof EntityAnimal && this.getPassengers().size() > 1) {
            j = entityToUpdate.func_145782_y() % 2 == 0 ? 90 : 270;
        }
        float f = MathHelper.func_76142_g((float)(((EntityLivingBase)entityToUpdate).field_70759_as - this.field_70177_z)) + (float)j;
        float f1 = MathHelper.func_76131_a((float)f, (float)(-105.0f + (float)j), (float)(105.0f + (float)(j % 360)));
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        if (entityToUpdate instanceof EntityLivingBase) {
            ((EntityLivingBase)entityToUpdate).field_70759_as += f1 - f;
            ((EntityLivingBase)entityToUpdate).field_70758_at += f1 - f;
            ((EntityLivingBase)entityToUpdate).field_70761_aq = this.field_70177_z + (float)j;
            ((EntityLivingBase)entityToUpdate).field_70760_ar = this.field_70177_z + (float)j;
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        Entity entity;
        if (compound.func_150297_b("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
        if (compound.func_74764_b("Seat") && !this.field_70170_p.field_72995_K && ConfigBlocksItems.newBoatPassengerSeat && this.shouldHaveSeat() && (entity = EntityList.func_75615_a((NBTTagCompound)compound.func_74775_l("Seat"), (World)this.field_70170_p)) instanceof EntityNewBoatSeat && entity.field_70153_n == null) {
            ((EntityNewBoatSeat)entity).setBoat(this);
            this.seatToSpawn = (EntityNewBoatSeat)entity;
        }
        if (compound.func_150297_b("CustomName", 9) && compound.func_74779_i("CustomName").length() > 0) {
            this.entityName = compound.func_74779_i("CustomName");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Type", this.getBoatType().getName());
        if (this.hasSeat() && ConfigBlocksItems.newBoatPassengerSeat && this.shouldHaveSeat()) {
            String s = EntityList.func_75621_b((Entity)this.seat);
            NBTTagCompound seatData = new NBTTagCompound();
            if (!this.seat.field_70128_L && !this.field_70128_L && s != null && this.seat.field_70153_n == null) {
                seatData.func_74778_a("id", s);
                this.seat.func_70109_d(seatData);
                compound.func_74782_a("Seat", (NBTBase)seatData);
            }
        }
        if (this.entityName != null && this.entityName.length() > 0) {
            compound.func_74778_a("CustomName", this.entityName);
        }
    }

    protected void func_70064_a(double y, boolean onGroundIn) {
        this.lastYd = this.field_70181_x;
        if (!this.func_70115_ae()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND && this.getControllingPassenger() instanceof EntityPlayer) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_70069_a(this.field_70143_R);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1, this.getBoatType().getMetadata()), 0.0f);
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_70099_a(new ItemStack(Items.field_151055_y), 0.0f);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)(this.field_70163_u - 1.0), (int)this.field_70161_v).func_149688_o() != Material.field_151586_h && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean getPaddleState(int p_184457_1_) {
        return this.field_70180_af.func_75683_a(DATA_ID_PADDLE[p_184457_1_]) == 1 && this.getControllingPassenger() != null;
    }

    public void setDamageTaken(float p_70266_1_) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(p_70266_1_));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int p_70265_1_) {
        this.field_70180_af.func_75692_b(17, (Object)p_70265_1_);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int p_70269_1_) {
        this.field_70180_af.func_75692_b(18, (Object)p_70269_1_);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void setBoatType(Type boatType) {
        this.func_70096_w().func_75692_b(20, (Object)boatType.ordinal());
    }

    public Type getBoatType() {
        return Type.byId(this.func_70096_w().func_75679_c(20));
    }

    public void updateInputs(boolean p_184442_1_, boolean p_184442_2_, boolean p_184442_3_, boolean p_184442_4_) {
        this.leftInputDown = p_184442_1_;
        this.rightInputDown = p_184442_2_;
        this.forwardInputDown = p_184442_3_;
        this.backInputDown = p_184442_4_;
    }

    public String getBoatName() {
        return this.entityName;
    }

    public void setBoatName(String p_96094_1_) {
        this.entityName = p_96094_1_;
    }

    public static enum Type {
        OAK(0, "oak"),
        SPRUCE(1, "spruce"),
        BIRCH(2, "birch"),
        JUNGLE(3, "jungle"),
        ACACIA(4, "acacia"),
        DARK_OAK(5, "dark_oak");

        private final String name;
        private final int metadata;

        private Type(int metadataIn, String nameIn) {
            this.name = nameIn;
            this.metadata = metadataIn;
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            return Type.values()[MathHelper.func_76125_a((int)id, (int)0, (int)(Type.values().length - 1))];
        }

        public static Type getTypeFromString(String nameIn) {
            for (int i = 0; i < Type.values().length; ++i) {
                if (!Type.values()[i].getName().equals(nameIn)) continue;
                return Type.values()[i];
            }
            return Type.values()[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

