/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.mc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.AssetDirector;
import ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.AssetFetcher;
import ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.ResourcePackUtil;
import ganymedes01.etfuturum.repackage.makamys.mclib.ext.assetdirector.mc.MCUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class MultiVersionDefaultResourcePack
implements IResourcePack {
    private static final MCUtil.Version v1_7_10 = new MCUtil.Version("1.7.10");
    private static final MCUtil.Version v1_13 = new MCUtil.Version("1.13");
    private AssetDirector assetDirector;
    private AssetFetcher fetcher;
    private NameParserScratch scratch = new NameParserScratch();

    public MultiVersionDefaultResourcePack(AssetDirector assetDirector) {
        this.assetDirector = assetDirector;
        this.fetcher = assetDirector.getFetcher();
    }

    public Set func_110587_b() {
        return this.fetcher.versionIndexes.keySet().stream().map(v -> "minecraft_" + v).collect(Collectors.toSet());
    }

    public InputStream func_110590_a(ResourceLocation resLoc) throws IOException {
        JsonObject obj;
        this.parseName(resLoc);
        if (this.scratch.mcResPack != null) {
            return this.scratch.mcResPack.func_110590_a(this.scratch.mcResLoc);
        }
        InputStream is = null;
        is = !this.scratch.isInJar ? this.fetcher.getAssetInputStream(this.scratch.hash) : this.scratch.vi.getJarFileStream("assets/minecraft/" + this.scratch.name);
        if (this.scratch.namespace.equals("minecraft") && this.scratch.name.equals("sounds.json") && (obj = this.assetDirector.getMassagedSoundJson(this.scratch.version)) != null) {
            this.stripUnusedSounds(obj, this.fetcher.assetIndexes.get(this.scratch.version));
            return IOUtils.toInputStream((String)new Gson().toJson((JsonElement)obj));
        }
        return is;
    }

    public boolean func_110589_b(ResourceLocation resLoc) {
        if (!resLoc.func_110624_b().startsWith("minecraft_")) {
            return false;
        }
        this.parseName(resLoc);
        return this.scratch.isInJar ? true : this.fetcher.hashExists(this.scratch.hash) || this.scratch.mcResPack != null;
    }

    private void parseName(ResourceLocation resLoc) {
        if (resLoc.equals((Object)this.scratch.resLoc)) {
            return;
        }
        String fullDomain = resLoc.func_110624_b();
        int firstUnderscore = fullDomain.indexOf(95);
        this.scratch.resLoc = resLoc;
        this.scratch.namespace = fullDomain.substring(0, firstUnderscore);
        this.scratch.version = fullDomain.substring(firstUnderscore + 1);
        this.scratch.vi = this.fetcher.versionIndexes.get(this.scratch.version);
        this.scratch.name = this.convertPath(resLoc.func_110623_a(), this.scratch.vi.version);
        if (this.scratch.vi.jarContainsFile("assets/minecraft/" + this.scratch.name)) {
            this.scratch.isInJar = true;
        } else {
            this.scratch.isInJar = false;
            this.scratch.hash = this.fetcher.assetIndexes.get((Object)this.scratch.vi.assetsId).nameToHash.get(this.scratch.namespace + "/" + this.scratch.name);
        }
        this.scratch.mcResPack = null;
        if (!resLoc.func_110623_a().equals("sounds.json")) {
            ResourceLocation mcResLocOld = new ResourceLocation("minecraft", this.convertPath(resLoc.func_110623_a(), v1_7_10));
            ResourceLocation mcResLocNew = new ResourceLocation("minecraft", this.convertPath(resLoc.func_110623_a(), v1_13));
            List<IResourcePack> mcResPacks = ResourcePackUtil.getMinecraftResourcePackList();
            for (int i = mcResPacks.size() - 1; i >= 0; --i) {
                IResourcePack resPack = mcResPacks.get(i);
                if (ResourcePackUtil.isBuiltIn(resPack)) continue;
                if (resPack.func_110589_b(mcResLocOld)) {
                    this.scratch.mcResPack = resPack;
                    this.scratch.mcResLoc = mcResLocOld;
                    break;
                }
                if (mcResLocOld.equals((Object)mcResLocNew) || !resPack.func_110589_b(mcResLocNew)) continue;
                this.scratch.mcResPack = resPack;
                this.scratch.mcResLoc = mcResLocNew;
                break;
            }
        }
    }

    private String convertPath(String path, MCUtil.Version version) {
        if (version.compareTo(v1_13) >= 0) {
            path = path.replaceFirst("^textures/blocks/", "textures/block/");
            path = path.replaceFirst("^textures/items/", "textures/item/");
        }
        return path;
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "AssetDirector";
    }

    public static void inject(AssetDirector assetDirector) {
        MultiVersionDefaultResourcePack multiDefaultPack = new MultiVersionDefaultResourcePack(assetDirector);
        List defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        defaultResourcePacks.add(multiDefaultPack);
        IResourceManager resMan = Minecraft.func_71410_x().func_110442_L();
        if (resMan instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resMan).func_110545_a((IResourcePack)multiDefaultPack);
        }
    }

    private void stripUnusedSounds(JsonObject soundsJSON, AssetFetcher.AssetIndex index) {
        if (soundsJSON.has(":tmp:requested")) {
            Set requested = StreamSupport.stream(soundsJSON.getAsJsonArray(":tmp:requested").spliterator(), false).map(e -> e.getAsString()).collect(Collectors.toSet());
            soundsJSON.remove(":tmp:requested");
            soundsJSON.entrySet().removeIf(sound -> !requested.contains(sound.getKey()));
        }
    }

    private static class NameParserScratch {
        ResourceLocation resLoc;
        String namespace;
        String version;
        String name;
        AssetFetcher.VersionIndex vi;
        boolean isInJar;
        String hash;
        ResourceLocation mcResLoc;
        IResourcePack mcResPack;

        private NameParserScratch() {
        }
    }
}

