/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.spectator;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.core.utils.helpers.SafeEnumHelperClient;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class SpectatorMode {
    public static final SpectatorMode INSTANCE = new SpectatorMode();
    public static final IEntitySelector EXCEPT_SPECTATING = new IEntitySelector(){

        public boolean func_82704_a(Entity p_82704_1_) {
            return !(p_82704_1_ instanceof EntityPlayer) || !SpectatorMode.isSpectator((EntityPlayer)p_82704_1_);
        }
    };
    public static WorldSettings.GameType SPECTATOR_GAMETYPE = null;

    SpectatorMode() {
    }

    public static void init() {
        if (ConfigMixins.enableSpectatorMode) {
            SPECTATOR_GAMETYPE = SafeEnumHelperClient.addGameType("spectator", 3, "Spectator");
        }
    }

    public static boolean isSpectator(EntityPlayer player) {
        if (player == null || player instanceof FakePlayer || player.field_70170_p == null) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            if (player == FMLClientHandler.instance().getClient().field_71439_g && FMLClientHandler.instance().getClient().field_71442_b != null) {
                return FMLClientHandler.instance().getClient().field_71442_b.field_78779_k == SPECTATOR_GAMETYPE;
            }
            return false;
        }
        return player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71134_c.func_73081_b() == SPECTATOR_GAMETYPE;
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                event.setCanceled(true);
            } else {
                int meta;
                if (!event.world.func_72899_e(event.x, event.y, event.z)) {
                    return;
                }
                Block block = event.world.func_147439_a(event.x, event.y, event.z);
                if (!block.hasTileEntity(meta = event.world.func_72805_g(event.x, event.y, event.z)) || !(event.world.func_147438_o(event.x, event.y, event.z) instanceof IInventory)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onInteract(BlockEvent.PlaceEvent event) {
        if (SpectatorMode.isSpectator(event.player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteract(AttackEntityEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            boolean isSpec = SpectatorMode.isSpectator(event.player);
            if (!isSpec && event.player.field_70145_X) {
                event.player.func_82142_c(false);
            }
            event.player.field_70145_X = isSpec;
            if (isSpec) {
                event.player.field_70122_E = false;
                event.player.func_82142_c(true);
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.newSpeed = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void itemToss(ItemTossEvent event) {
        if (SpectatorMode.isSpectator(event.player)) {
            event.setCanceled(true);
            ItemStack item = event.entityItem.func_92059_d();
            event.player.field_71071_by.func_70441_a(item);
        }
    }
}

