/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.tileentities;

import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.helpers.Vec3i;
import ganymedes01.etfuturum.world.end.gen.WorldGenEndGateway;
import ganymedes01.etfuturum.world.end.gen.WorldGenEndIsland;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileEntityGateway
extends TileEntity {
    private static final Logger LOG = LogManager.getLogger();
    private long age = 0L;
    private int teleportCooldown = 0;
    private BlockPos exitPortal;
    private boolean exactTeleport;

    public void func_145841_b(NBTTagCompound p_189515_1_) {
        super.func_145841_b(p_189515_1_);
        this.write(p_189515_1_);
    }

    private NBTTagCompound write(NBTTagCompound p_189515_1_) {
        super.func_145841_b(p_189515_1_);
        p_189515_1_.func_74772_a("Age", this.age);
        if (this.exitPortal != null) {
            NBTTagCompound coords = new NBTTagCompound();
            coords.func_74768_a("X", this.exitPortal.getX());
            coords.func_74768_a("Y", this.exitPortal.getY());
            coords.func_74768_a("Z", this.exitPortal.getZ());
            p_189515_1_.func_74782_a("ExitPortal", (NBTBase)coords);
        }
        if (this.exactTeleport) {
            p_189515_1_.func_74757_a("ExactTeleport", this.exactTeleport);
        }
        return p_189515_1_;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.age = compound.func_74763_f("Age");
        if (compound.func_74764_b("ExitPortal")) {
            NBTTagCompound coords = compound.func_74775_l("ExitPortal");
            this.exitPortal = new BlockPos(coords.func_74762_e("X"), coords.func_74762_e("Y"), coords.func_74762_e("Z"));
        }
        this.exactTeleport = compound.func_74767_n("ExactTeleport");
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public void func_145845_h() {
        List list;
        boolean flag = this.isSpawning();
        boolean flag1 = this.isCoolingDown();
        ++this.age;
        if (flag1) {
            --this.teleportCooldown;
        } else if (!this.field_145850_b.field_72995_K && !(list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)))).isEmpty()) {
            Entity entity = (Entity)list.get(0);
            if (entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                entity = pearl.func_85052_h();
                pearl.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                pearl.func_70106_y();
            }
            this.teleportEntity(entity);
        }
        if (flag != this.isSpawning() || flag1 != this.isCoolingDown()) {
            this.func_70296_d();
        }
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    public float getSpawnPercent() {
        return MathHelper.func_76131_a((float)((float)this.age / 200.0f), (float)0.0f, (float)1.0f);
    }

    public float getCooldownPercent() {
        return 1.0f - MathHelper.func_76131_a((float)((float)this.teleportCooldown / 20.0f), (float)0.0f, (float)1.0f);
    }

    public Packet func_145844_m() {
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 8, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.write(new NBTTagCompound());
    }

    public void triggerCooldown() {
        if (!this.field_145850_b.field_72995_K) {
            this.teleportCooldown = 20;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 0);
            this.func_70296_d();
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.teleportCooldown = 20;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void teleportEntity(Entity entityIn) {
        if (!this.field_145850_b.field_72995_K && !this.isCoolingDown()) {
            this.teleportCooldown = 100;
            if (this.exitPortal == null && this.field_145850_b.field_73011_w instanceof WorldProviderEnd) {
                this.findExitPortal();
            }
            if (this.exitPortal != null) {
                BlockPos blockpos;
                BlockPos blockPos = blockpos = this.exactTeleport ? this.exitPortal : this.findExitPosition();
                if (entityIn instanceof EntityLivingBase) {
                    ((EntityLivingBase)entityIn).func_70634_a((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                } else {
                    entityIn.func_70107_b((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                }
                entityIn.field_70170_p.func_72866_a(entityIn, false);
            }
            this.triggerCooldown();
        }
    }

    private BlockPos findExitPosition() {
        BlockPos blockpos = TileEntityGateway.findHighestBlock(this.field_145850_b, this.exitPortal, 5, false);
        LOG.debug("Best exit position for portal at " + this.exitPortal + " is " + blockpos);
        return blockpos.up();
    }

    private void findExitPortal() {
        Vec3 vec3d = Vec3.func_72443_a((double)this.field_145851_c, (double)0.0, (double)this.field_145849_e).func_72432_b();
        Vec3 vec3d1 = Vec3.func_72443_a((double)(vec3d.field_72450_a * 1024.0), (double)(vec3d.field_72448_b * 1024.0), (double)(vec3d.field_72449_c * 1024.0));
        int i = 16;
        while (TileEntityGateway.getChunk(this.field_145850_b, vec3d1).func_76625_h() > 0 && i-- > 0) {
            LOG.debug("Skipping backwards past nonempty chunk at " + vec3d1);
            vec3d1 = vec3d1.func_72441_c(vec3d.field_72450_a * -16.0, vec3d.field_72448_b * -16.0, vec3d.field_72449_c * -16.0);
        }
        int j = 16;
        while (TileEntityGateway.getChunk(this.field_145850_b, vec3d1).func_76625_h() == 0 && j-- > 0) {
            LOG.debug("Skipping forward past empty chunk at " + vec3d1);
            vec3d1 = vec3d1.func_72441_c(vec3d.field_72450_a * 16.0, vec3d.field_72448_b * 16.0, vec3d.field_72449_c * 16.0);
        }
        LOG.debug("Found chunk at " + vec3d1);
        Chunk chunk = TileEntityGateway.getChunk(this.field_145850_b, vec3d1);
        this.exitPortal = TileEntityGateway.findSpawnpointInChunk(chunk);
        if (this.exitPortal == null) {
            this.exitPortal = new BlockPos(vec3d1.field_72450_a + 0.5, 75.0, vec3d1.field_72449_c + 0.5);
            LOG.debug("Failed to find suitable block, settling on " + this.exitPortal);
            new WorldGenEndIsland().func_76484_a(this.field_145850_b, new Random(this.exitPortal.toLong()), this.exitPortal.getX(), this.exitPortal.getY(), this.exitPortal.getZ());
        } else {
            LOG.debug("Found block at " + this.exitPortal);
        }
        this.exitPortal = TileEntityGateway.findHighestBlock(this.field_145850_b, this.exitPortal, 16, true);
        LOG.debug("Creating portal at " + this.exitPortal);
        this.exitPortal = this.exitPortal.up(10);
        this.createExitPortal(this.exitPortal);
        this.func_70296_d();
    }

    private static BlockPos findHighestBlock(World p_184308_0_, BlockPos p_184308_1_, int p_184308_2_, boolean p_184308_3_) {
        Vec3i blockpos = null;
        for (int i = -p_184308_2_; i <= p_184308_2_; ++i) {
            block1: for (int j = -p_184308_2_; j <= p_184308_2_; ++j) {
                if (i == 0 && j == 0 && !p_184308_3_) continue;
                for (int k = 255; k > (blockpos == null ? 0 : blockpos.getY()); --k) {
                    Block iblockstate = p_184308_0_.func_147439_a(p_184308_1_.getX() + i, k, p_184308_1_.getZ() + j);
                    if (!iblockstate.func_149637_q() || !p_184308_3_ && iblockstate == Blocks.field_150357_h) continue;
                    blockpos = new BlockPos(p_184308_1_.getX() + i, k, p_184308_1_.getZ() + j);
                    continue block1;
                }
            }
        }
        return blockpos == null ? p_184308_1_ : blockpos;
    }

    private static Chunk getChunk(World worldIn, Vec3 vec3) {
        return worldIn.func_72964_e(MathHelper.func_76128_c((double)(vec3.field_72450_a / 16.0)), MathHelper.func_76128_c((double)(vec3.field_72449_c / 16.0)));
    }

    @Nullable
    private static BlockPos findSpawnpointInChunk(Chunk chunkIn) {
        int i = chunkIn.func_76625_h() + 16 - 1;
        int xfrom = chunkIn.field_76635_g * 16;
        int yfrom = 30;
        int zfrom = chunkIn.field_76647_h * 16;
        int xto = chunkIn.field_76635_g * 16 + 16 - 1;
        int yto = i;
        int zto = chunkIn.field_76647_h * 16 + 16 - 1;
        BlockPos blockpos2 = null;
        double d0 = 0.0;
        for (int x = xfrom; x <= xto; ++x) {
            for (int y = yfrom; y <= yto; ++y) {
                for (int z = zfrom; z <= zto; ++z) {
                    if (chunkIn.field_76637_e.func_147439_a(x, y, z) != Blocks.field_150377_bs || chunkIn.field_76637_e.func_147439_a(x, y + 1, z).func_149721_r() || chunkIn.field_76637_e.func_147439_a(x, y + 2, z).func_149721_r()) continue;
                    double dis1 = (double)x + 0.5;
                    double dis2 = (double)y + 0.5;
                    double dis3 = (double)z + 0.5;
                    double d1 = dis1 * dis1 + dis1 * dis2 + dis3 * dis3;
                    if (blockpos2 != null && !(d1 < d0)) continue;
                    blockpos2 = new BlockPos(x, y, z);
                    d0 = d1;
                }
            }
        }
        return blockpos2;
    }

    private void createExitPortal(BlockPos posIn) {
        new WorldGenEndGateway().func_76484_a(this.field_145850_b, new Random(), posIn.getX(), posIn.getY(), posIn.getZ());
        TileEntity tileentity = this.field_145850_b.func_147438_o(posIn.getX(), posIn.getY(), posIn.getZ());
        if (tileentity instanceof TileEntityGateway) {
            TileEntityGateway tileentityendgateway = (TileEntityGateway)tileentity;
            tileentityendgateway.exitPortal = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            tileentityendgateway.func_70296_d();
        } else {
            LOG.warn("Couldn't save exit portal at " + posIn);
        }
    }

    public boolean shouldRenderFace(EnumFacing p_184313_1_) {
        return this.func_145838_q().func_149646_a((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, p_184313_1_.ordinal());
    }

    public int getParticleAmount() {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.shouldRenderFace(enumfacing)) continue;
            ++i;
        }
        return i;
    }
}

