/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.tileentities;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockShulkerBox;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.inventory.ContainerChestGeneric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class TileEntityShulkerBox
extends TileEntity
implements IInventory {
    private int ticksSinceSync;
    private String customName;
    public ItemStack[] chestContents;
    public int numPlayersUsing;
    protected boolean brokenInCreative = false;
    public boolean destroyed = false;
    public byte color = 0;
    public byte facing = 0;
    public ShulkerBoxType type;
    private boolean firstTick = true;
    public static final List<ItemStack> bannedItems = new ArrayList<ItemStack>();
    private float field_190600_j;
    private float field_190601_k;
    private AnimationStatus field_190599_i = AnimationStatus.CLOSED;
    private ItemStack[] topStacks = new ItemStack[8];
    private boolean hadStuff;
    private boolean inventoryTouched;
    public static final String[] tiers = new String[]{"iron", "gold", "diamond", "copper", "silver", "crystal", "obsidian"};

    public TileEntityShulkerBox() {
        this.type = ShulkerBoxType.VANILLA;
    }

    public void touch() {
        this.inventoryTouched = true;
    }

    public int func_70302_i_() {
        return this.type.getSize();
    }

    public int getRowSize() {
        return this.type.getRowSize();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p_70300_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagList nbttaglist;
        super.func_145839_a(nbt);
        ShulkerBoxType shulkerBoxType = this.type = ConfigBlocksItems.enableShulkerBoxesIronChest ? ShulkerBoxType.values()[nbt.func_74771_c("Type")] : ShulkerBoxType.VANILLA;
        if (this.chestContents == null || this.chestContents.length != this.func_70302_i_()) {
            this.chestContents = new ItemStack[this.func_70302_i_()];
        }
        if ((nbttaglist = nbt.func_150295_c("Items", 10)).func_74745_c() > 0) {
            Utils.loadItemStacksFromNBT(nbttaglist, this.chestContents);
        }
        if (this.type.getIsClear()) {
            NBTTagList displaynbt = nbt.func_150295_c("Display", 10);
            this.topStacks = new ItemStack[8];
            for (int i = 0; i < displaynbt.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = displaynbt.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.topStacks.length) continue;
                this.topStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
        if (ConfigBlocksItems.enableDyedShulkerBoxes) {
            this.color = nbt.func_74771_c("Color");
        }
        if (nbt.func_74764_b("Facing")) {
            this.facing = nbt.func_74771_c("Facing");
        }
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.sortTopStacks();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("Type", (byte)this.type.ordinal());
        if (this.chestContents != null) {
            nbt.func_74782_a("Items", (NBTBase)Utils.writeItemStacksToNBT(this.chestContents));
        }
        nbt.func_74774_a("Color", this.color);
        nbt.func_74774_a("Facing", this.facing);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        this.inventoryTouched = true;
        return this.chestContents[p_70301_1_];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.chestContents[p_70298_1_] != null) {
            if (this.chestContents[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.chestContents[p_70298_1_];
                this.chestContents[p_70298_1_] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.chestContents[p_70298_1_].field_77994_a == 0) {
                this.chestContents[p_70298_1_] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.chestContents[p_70304_1_] != null) {
            ItemStack itemstack = this.chestContents[p_70304_1_];
            this.chestContents[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.chestContents[p_70299_1_] = p_70299_2_;
        if (p_70299_2_ != null && p_70299_2_.field_77994_a > this.func_70297_j_()) {
            p_70299_2_.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_145845_h() {
        this.func_190583_o();
        if (this.field_190599_i == AnimationStatus.OPENING || this.field_190599_i == AnimationStatus.CLOSING) {
            this.func_190589_G();
        }
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                if (!(entityplayer.field_71070_bA instanceof ContainerChestGeneric)) continue;
                ++this.numPlayersUsing;
            }
        }
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
        if (this.firstTick) {
            this.func_70296_d();
            this.firstTick = false;
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.etfuturum.shulker_box";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_145976_a(String p_145976_1_) {
        this.customName = p_145976_1_;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            if (type == 0) {
                this.field_190599_i = AnimationStatus.CLOSING;
            }
            if (type == 1) {
                this.field_190599_i = AnimationStatus.OPENING;
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_70295_k_() {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        ++this.numPlayersUsing;
        if (this.numPlayersUsing == 1) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "minecraft_1.19.3:block.shulker_box.open", 1.0f, 1.0f);
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        if (this.func_145838_q() instanceof BlockShulkerBox) {
            --this.numPlayersUsing;
            if (this.numPlayersUsing <= 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "minecraft_1.19.3:block.shulker_box.close", 1.0f, 1.0f);
            }
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return p_94041_2_ == null || !ConfigFunctions.shulkerBans.contains(p_94041_2_.func_77973_b());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean onBlockBreak(EntityPlayer player) {
        this.brokenInCreative = player.field_71075_bZ.field_75098_d;
        return true;
    }

    public void onBlockDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        boolean empty = true;
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            empty = false;
            break;
        }
        if (!(empty && this.brokenInCreative || !this.field_145850_b.func_82736_K().func_82766_b("doTileDrops"))) {
            ItemStack stack = new ItemStack(ModBlocks.shulker_box, 1);
            this.writeToStack(stack);
            EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, stack);
            item.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f;
            item.field_70181_x = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f;
            item.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.05f;
            item.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    public ItemStack writeToStack(ItemStack stack) {
        byte typeOrd;
        NBTTagList nbttaglist = new NBTTagList();
        for (int l = 0; l < this.chestContents.length; ++l) {
            if (this.chestContents[l] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)l);
            this.chestContents[l].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        stack.func_77982_d(new NBTTagCompound());
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77978_p().func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if ((typeOrd = (byte)this.type.ordinal()) > 0) {
            stack.func_77978_p().func_74774_a("Type", typeOrd);
        }
        if (this.color > 0) {
            stack.func_77978_p().func_74774_a("Color", this.color);
        }
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_145825_b());
        }
        return stack;
    }

    public float func_190585_a(float p_190585_1_) {
        return this.field_190601_k + (this.field_190600_j - this.field_190601_k) * p_190585_1_;
    }

    protected void func_190583_o() {
        this.field_190601_k = this.field_190600_j;
        switch (this.field_190599_i) {
            case CLOSED: {
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENING: {
                this.field_190600_j += 0.1f;
                if (!(this.field_190600_j >= 1.0f)) break;
                this.func_190589_G();
                this.field_190599_i = AnimationStatus.OPENED;
                this.field_190600_j = 1.0f;
                break;
            }
            case CLOSING: {
                this.field_190600_j -= 0.1f;
                if (!(this.field_190600_j <= 0.0f)) break;
                this.field_190599_i = AnimationStatus.CLOSED;
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENED: {
                this.field_190600_j = 1.0f;
            }
        }
    }

    public AnimationStatus func_190591_p() {
        return this.field_190599_i;
    }

    public AxisAlignedBB func_190584_a(int facing) {
        return this.func_190587_b(EnumFacing.func_82600_a((int)facing));
    }

    public AxisAlignedBB func_190587_b(EnumFacing p_190587_1_) {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72321_a((double)(0.5f * this.func_190585_a(1.0f) * (float)p_190587_1_.func_82601_c()), (double)(0.5f * this.func_190585_a(1.0f) * (float)p_190587_1_.func_96559_d()), (double)(0.5f * this.func_190585_a(1.0f) * (float)p_190587_1_.func_82599_e()));
    }

    private AxisAlignedBB func_190588_c(EnumFacing p_190588_1_) {
        int ordinal = p_190588_1_.ordinal();
        ordinal = ordinal % 2 == 0 ? ordinal + 1 : ordinal - 1;
        int opposite = ordinal;
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)opposite);
        return this.func_191195_a(this.func_190587_b(p_190588_1_), enumfacing.func_82601_c(), enumfacing.func_96559_d(), enumfacing.func_82599_e());
    }

    private void func_190589_G() {
        EnumFacing enumfacing;
        AxisAlignedBB axisalignedbb;
        List list;
        if (this.func_145838_q() instanceof BlockShulkerBox && !(list = this.field_145850_b.func_72839_b((Entity)null, axisalignedbb = this.func_190588_c(enumfacing = EnumFacing.func_82600_a((int)this.facing)).func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.func_70104_M()) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.field_70121_D;
                if (enumfacing.func_82601_c() != 0) {
                    d0 = enumfacing.func_82601_c() > 0 ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                    d0 += 0.01;
                } else if (enumfacing.func_96559_d() != 0) {
                    d1 = enumfacing.func_96559_d() > 0 ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                    d1 += 0.01;
                } else if (enumfacing.func_82599_e() != 0) {
                    d2 = enumfacing.func_82599_e() > 0 ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                    d2 += 0.01;
                }
                entity.func_70091_d(d0 * (double)enumfacing.func_82601_c(), d1 * (double)enumfacing.func_96559_d(), d2 * (double)enumfacing.func_82599_e());
            }
        }
    }

    public AxisAlignedBB func_191195_a(AxisAlignedBB bb, double p_191195_1_, double p_191195_3_, double p_191195_5_) {
        double d0 = bb.field_72340_a;
        double d1 = bb.field_72338_b;
        double d2 = bb.field_72339_c;
        double d3 = bb.field_72336_d;
        double d4 = bb.field_72337_e;
        double d5 = bb.field_72334_f;
        if (p_191195_1_ < 0.0) {
            d0 -= p_191195_1_;
        } else if (p_191195_1_ > 0.0) {
            d3 -= p_191195_1_;
        }
        if (p_191195_3_ < 0.0) {
            d1 -= p_191195_3_;
        } else if (p_191195_3_ > 0.0) {
            d4 -= p_191195_3_;
        }
        if (p_191195_5_ < 0.0) {
            d2 -= p_191195_5_;
        } else if (p_191195_5_ > 0.0) {
            d5 -= p_191195_5_;
        }
        return AxisAlignedBB.func_72330_a((double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        super.func_145841_b(nbt);
        nbt.func_74774_a("Type", (byte)this.type.ordinal());
        if (this.type.getIsClear()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.topStacks.length; ++i) {
                if (this.topStacks[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.topStacks[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbt.func_74782_a("Display", (NBTBase)nbttaglist);
        }
        nbt.func_74774_a("Color", this.color);
        nbt.func_74774_a("Facing", this.facing);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock || oldMeta != newMeta;
    }

    public int func_145832_p() {
        if (this.field_145847_g == -1) {
            this.field_145847_g = ConfigBlocksItems.enableShulkerBoxesIronChest ? this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) : 0;
        }
        return this.field_145847_g;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sortTopStacks();
    }

    public ItemStack[] getTopItemStacks() {
        return this.topStacks;
    }

    protected void sortTopStacks() {
        int i;
        int i2;
        if (!this.type.getIsClear() || this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack[] tempCopy = new ItemStack[this.func_70302_i_()];
        ItemStack[] contents = (ItemStack[])this.chestContents.clone();
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i2 = 0; i2 < this.func_70302_i_(); ++i2) {
            if (contents[i2] == null) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                if (!tempCopy[j].func_77969_a(contents[i2])) continue;
                if ((tempCopy[j].field_77994_a += contents[i2].field_77994_a) <= 96) continue block0;
                tempCopy[j].field_77994_a = 96;
                continue block0;
            }
            tempCopy[compressedIdx++] = contents[i2].func_77946_l();
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i2 = 0; i2 < this.topStacks.length; ++i2) {
                this.topStacks[i2] = null;
            }
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return;
        }
        this.hadStuff = true;
        Arrays.sort(tempCopy, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o2.field_77994_a - o1.field_77994_a;
            }
        });
        int p = 0;
        for (i = 0; i < tempCopy.length; ++i) {
            if (tempCopy[i] == null || tempCopy[i].field_77994_a <= 0) continue;
            this.topStacks[p++] = tempCopy[i];
            if (p == this.topStacks.length) break;
        }
        for (i = p; i < this.topStacks.length; ++i) {
            this.topStacks[i] = null;
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void handlePacketData(int typeData, ItemStack[] intData) {
        TileEntityShulkerBox chest = this;
        if (this.field_145847_g != typeData) {
            chest = this.updateFromMetadata(typeData);
        }
        if (this.field_145847_g == 6 && intData != null) {
            int pos = 0;
            for (int i = 0; i < chest.topStacks.length; ++i) {
                chest.topStacks[i] = intData[pos] != null ? intData[pos] : null;
                ++pos;
            }
        }
    }

    public TileEntityShulkerBox updateFromMetadata(int l) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && l != this.field_145847_g) {
            return (TileEntityShulkerBox)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this;
    }

    public static enum ShulkerBoxType {
        VANILLA(27, 9, false, 184, 168, null),
        IRON(54, 9, false, 184, 202, "ironcontainer"),
        GOLD(81, 9, false, 184, 256, "goldcontainer"),
        DIAMOND(108, 12, false, 238, 256, "diamondcontainer"),
        COPPER(45, 9, false, 184, 184, "coppercontainer"),
        SILVER(72, 9, false, 184, 238, "silvercontainer"),
        CRYSTAL(108, 12, true, 238, 256, "diamondcontainer"),
        OBSIDIAN(108, 12, false, 238, 256, "diamondcontainer");

        private int size;
        private int rowSize;
        private boolean isClear;
        private int xSize;
        private int ySize;
        private String guiTextureName;

        private ShulkerBoxType(int size, int rowSize, boolean isClear, int xSize, int ySize, String guiTextureName) {
            this.size = size;
            this.rowSize = rowSize;
            this.isClear = isClear;
            this.xSize = xSize;
            this.ySize = ySize;
            this.guiTextureName = guiTextureName;
        }

        public int getSize() {
            return this.size;
        }

        public int getRowSize() {
            return this.rowSize;
        }

        public boolean getIsClear() {
            return this.isClear;
        }

        public int getXSize() {
            return this.xSize;
        }

        public int getYSize() {
            return this.ySize;
        }

        public String getGuiTextureName() {
            return this.guiTextureName;
        }
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

