/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate;

import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.helpers.BlockState;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class NBTStructure {
    private final NBTTagCompound compound;
    private final Map<Integer, BlockState>[] palettes;
    private final Set<Pair<BlockPos, BlockState>>[] blocksInStructure;
    private final BlockPos[] sizes;
    private final float theIntegrity;

    public NBTStructure(String loc) {
        this(loc, 1.0f);
    }

    public NBTStructure(String loc, float integrity) {
        InputStream file = EtFuturum.class.getResourceAsStream(loc);
        NBTTagCompound tempCompound = null;
        try {
            tempCompound = CompressedStreamTools.func_74796_a((InputStream)file);
            file.close();
        }
        catch (IOException e) {
            Logger.error("Failed to find or read structure NBT file for " + loc);
            e.printStackTrace();
        }
        this.theIntegrity = MathHelper.func_76131_a((float)integrity, (float)0.0f, (float)1.0f);
        this.compound = tempCompound;
        BlockPos size = this.getPosFromTagList(this.compound.func_150295_c("size", 3));
        this.sizes = new BlockPos[]{size, new BlockPos(size.getZ(), size.getY(), size.getX())};
        this.palettes = this.createPalettes();
        this.blocksInStructure = this.buildStructureMaps();
    }

    private Set<Pair<BlockPos, BlockState>>[] buildStructureMaps() {
        Set[] sets = new Set[]{null, null, null, null};
        for (int facing = 0; facing < 4; ++facing) {
            HashSet<ImmutablePair> set = new HashSet<ImmutablePair>();
            NBTTagList list = this.getCompound().func_150295_c("blocks", 10);
            BlockPos size = this.getSize(this.getFacingFromInt(facing));
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound comp = list.func_150305_b(i);
                BlockPos pos = this.getPosFromTagList(comp.func_150295_c("pos", 3));
                if (facing == 1) {
                    pos = new BlockPos(size.getX() - pos.getX(), pos.getY(), size.getZ() - pos.getZ());
                } else if (facing == 2) {
                    pos = new BlockPos(pos.getZ(), pos.getY(), pos.getX());
                } else if (facing == 3) {
                    pos = new BlockPos(size.getX() - pos.getZ(), pos.getY(), size.getZ() - pos.getX());
                }
                set.add(new ImmutablePair((Object)pos, (Object)this.getPalettes()[facing].get(comp.func_74762_e("state"))));
            }
            sets[facing] = set;
        }
        return sets;
    }

    public NBTTagCompound getCompound() {
        return this.compound;
    }

    public Map<Integer, BlockState>[] getPalettes() {
        return this.palettes;
    }

    public void buildStructure(World world, Random rand, int x, int y, int z) {
        this.buildStructure(world, rand, x, y, z, this.getFacingFromInt(rand.nextInt(4)));
    }

    public void buildStructure(World world, Random rand, int x, int y, int z, ForgeDirection facing) {
        Set<Pair<BlockPos, BlockState>> blockSet = this.blocksInStructure[this.getIntFromFacing(facing)];
        HashSet<Pair<BlockPos, BlockState>> entitySet = new HashSet<Pair<BlockPos, BlockState>>();
        for (Pair<BlockPos, BlockState> pair : blockSet) {
            if (((BlockState)pair.getRight()).getType() == BlockState.BlockStateType.ENTITY) {
                entitySet.add(pair);
                continue;
            }
            if (this.getIntegrity() != 1.0f && !(rand.nextFloat() < this.getIntegrity())) continue;
            BlockPos pos = (BlockPos)pair.getLeft();
            this.setBlockState(world, rand, pos.getX() + x, pos.getY() + y, pos.getZ() + z, facing, (BlockState)pair.getRight());
        }
        for (Pair pair : entitySet) {
            Entity entity = ((BlockState)pair.getRight()).createNewEntity(world);
            entity.func_70020_e(((BlockState)pair.getRight()).getCompound());
            entity.func_70012_b((double)(((BlockPos)pair.getLeft()).getX() + x), (double)(((BlockPos)pair.getLeft()).getY() + y), (double)(((BlockPos)pair.getLeft()).getZ() + z), 0.0f, 0.0f);
            world.func_72838_d(entity);
        }
    }

    public void setBlockState(World world, Random rand, int x, int y, int z, ForgeDirection facing, BlockState state) {
        TileEntity te;
        world.func_147465_d(x, y, z, state.getBlock(), state.getMeta(), 3);
        world.func_147471_g(x, y, z);
        if (state.getType() == BlockState.BlockStateType.BLOCK_ENTITY && (te = world.func_147438_o(x, y, z)) != null) {
            if (state.getCompound() != null) {
                state.getCompound().func_74768_a("x", x);
                state.getCompound().func_74768_a("y", y);
                state.getCompound().func_74768_a("z", z);
                te.func_145839_a(state.getCompound());
            }
            if (te instanceof IInventory && state.getLootTable() != null) {
                WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])state.getLootTable().getItems(world.field_73012_v), (IInventory)((IInventory)te), (int)state.getLootTable().getCount(world.field_73012_v));
            }
        }
    }

    public float getIntegrity() {
        return this.theIntegrity;
    }

    public BlockPos getSize(ForgeDirection facing) {
        if (facing.ordinal() < 2 || facing.ordinal() > 5) {
            throw new IllegalArgumentException("ForgeDirection object must be NORTH, SOUTH, EAST or WEST!");
        }
        return facing == ForgeDirection.NORTH || facing == ForgeDirection.SOUTH ? this.sizes[0] : this.sizes[1];
    }

    public NBTTagCompound getPaletteFromIndex(int i) {
        return this.getCompound().func_150295_c("palette", 10).func_150305_b(i);
    }

    public String getBlockNamespaceFromPaletteEntry(int i) {
        return this.getPaletteFromIndex(i).func_74779_i("Name");
    }

    public int getPaletteCount() {
        return this.getCompound().func_150295_c("palette", 10).func_74745_c();
    }

    public Set<Pair<Integer, NBTTagCompound>> getPaletteNBT() {
        HashSet<Pair<Integer, NBTTagCompound>> set = new HashSet<Pair<Integer, NBTTagCompound>>();
        for (int i = 0; i < this.getPaletteCount(); ++i) {
            set.add((Pair<Integer, NBTTagCompound>)new ImmutablePair((Object)i, (Object)this.getPaletteFromIndex(i)));
        }
        return set;
    }

    public String getBlockProperty(NBTTagCompound nbt, String property) {
        if (!nbt.func_74764_b("properties")) {
            return null;
        }
        return nbt.func_74775_l("properties").func_74779_i(property);
    }

    public BlockPos getPosFromTagList(NBTTagList list) {
        if (list.func_74745_c() != 3 && list.func_74732_a() != 3) {
            throw new IllegalArgumentException("This is not a BlockPos taglist!");
        }
        return new BlockPos(this.getIntFromTagList(list, 0), this.getIntFromTagList(list, 1), this.getIntFromTagList(list, 2));
    }

    protected int getIntFromTagList(NBTTagList list, int index) {
        if (index >= 0 && index < list.func_74745_c()) {
            NBTBase nbtbase = (NBTBase)list.field_74747_a.get(index);
            return nbtbase.func_74732_a() == 3 ? ((NBTTagInt)nbtbase).func_150287_d() : 0;
        }
        return 0;
    }

    public ForgeDirection getFacingFromInt(int i) {
        if (i < 0 || i > 3) {
            throw new IllegalArgumentException("Facing int must be at least 0 and at most 3!");
        }
        return ForgeDirection.values()[i + 2];
    }

    public int getIntFromFacing(ForgeDirection dir) {
        if (dir.ordinal() < 2 || dir.ordinal() > 5) {
            throw new IllegalArgumentException("ForgeDirection object must be NORTH, SOUTH, EAST or WEST!");
        }
        return dir.ordinal() - 2;
    }

    private Map<Integer, BlockState>[] createPalettes() {
        return new Map[]{this.createPalette(ForgeDirection.NORTH), this.createPalette(ForgeDirection.SOUTH), this.createPalette(ForgeDirection.WEST), this.createPalette(ForgeDirection.EAST)};
    }

    public abstract Map<Integer, BlockState> createPalette(ForgeDirection var1);
}

