/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.ExternalContent;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.helpers.DoublePerlinNoiseSampler;
import ganymedes01.etfuturum.core.utils.helpers.Vec3i;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenAmethystGeode
extends WorldGenerator {
    private final int outerMeta = ConfigWorld.amethystOuterBlock == ExternalContent.netherlicious_basalt_bricks ? 6 : 0;
    private final List<Block> budBlocks = ImmutableList.of((Object)ModBlocks.amethyst_cluster_1, (Object)ModBlocks.amethyst_cluster_2);
    private final int minGenOffset;
    private final int maxGenOffset;
    private final int invalidBlocksThreshold;
    private final int[] distributionPoints;
    private final int[] outerWallDistance;
    private final double filling;
    private final double innerLayer;
    private final double middleLayer;
    private final double outerLayer;
    private final int[] pointOffset;
    private final double generateCrackChance;
    private final double baseCrackSize;
    private final int crackPointOffset;
    private final double noiseMultiplier;
    private final double buddingAmethystChance;
    private final double usePotentialPlacementsChance;

    public WorldGenAmethystGeode() {
        this(-16, 16, 1, new int[]{3, 4}, new int[]{4, 5, 6}, 1.7, 2.2, 3.2, 4.2, new int[]{1, 2}, 0.95, 2.0, 2, 0.05, 0.083, 0.35);
    }

    public WorldGenAmethystGeode(int minOffset, int maxOffset, int invalidMax, int[] distPoints, int[] outerWallDist, double fill, double inner, double middle, double outer, int[] pointOff, double crackChance, double baseCrack, int crackPointOff, double noiseAmp, double budChance, double potentialPlaceChance) {
        this.minGenOffset = minOffset;
        this.maxGenOffset = maxOffset;
        this.invalidBlocksThreshold = invalidMax;
        this.distributionPoints = distPoints;
        this.outerWallDistance = outerWallDist;
        this.filling = fill;
        this.innerLayer = inner;
        this.middleLayer = middle;
        this.outerLayer = outer;
        this.pointOffset = pointOff;
        this.generateCrackChance = crackChance;
        this.baseCrackSize = baseCrack;
        this.crackPointOffset = crackPointOff;
        this.noiseMultiplier = noiseAmp;
        this.buddingAmethystChance = budChance;
        this.usePotentialPlacementsChance = potentialPlaceChance;
    }

    private boolean isInvalidCorner(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || !block.func_149662_c() || world.func_72937_j(x, y, z);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int s;
        int r;
        BlockPos blockPos = new BlockPos(x, y, z);
        LinkedList list = Lists.newLinkedList();
        int distPoint = WorldGenAmethystGeode.getRandom(this.distributionPoints, random);
        DoublePerlinNoiseSampler doublePerlinNoiseSampler = DoublePerlinNoiseSampler.create(random, -4, 1.0);
        LinkedList list2 = Lists.newLinkedList();
        double outerWallMaxDiv = (double)distPoint / (double)this.outerWallDistance[this.outerWallDistance.length - 1];
        double fillingSqrt = 1.0 / Math.sqrt(this.filling);
        double innerLayerSqrt = 1.0 / Math.sqrt(this.innerLayer + outerWallMaxDiv);
        double middleLayerSqrt = 1.0 / Math.sqrt(this.middleLayer + outerWallMaxDiv);
        double outerLayerSqrt = 1.0 / Math.sqrt(this.outerLayer + outerWallMaxDiv);
        double l = 1.0 / Math.sqrt(this.baseCrackSize + random.nextDouble() / 2.0 + (distPoint > 3 ? outerWallMaxDiv : 0.0));
        boolean bl = (double)random.nextFloat() < this.generateCrackChance;
        int m = 0;
        for (r = 0; r < distPoint; ++r) {
            int q;
            int p;
            s = WorldGenAmethystGeode.getRandom(this.outerWallDistance, random);
            BlockPos blockPos6 = blockPos.add(s, p = WorldGenAmethystGeode.getRandom(this.outerWallDistance, random), q = WorldGenAmethystGeode.getRandom(this.outerWallDistance, random));
            if (this.isInvalidCorner(world, blockPos6.getX(), blockPos6.getY(), blockPos6.getZ()) && ++m > this.invalidBlocksThreshold) {
                return false;
            }
            list.add(Pair.of((Object)blockPos6, (Object)WorldGenAmethystGeode.getRandom(this.pointOffset, random)));
        }
        if (bl) {
            r = random.nextInt(4);
            s = distPoint * 2 + 1;
            if (r == 0) {
                list2.add(blockPos.add(s, 7, 0));
                list2.add(blockPos.add(s, 5, 0));
                list2.add(blockPos.add(s, 1, 0));
            } else if (r == 1) {
                list2.add(blockPos.add(0, 7, s));
                list2.add(blockPos.add(0, 5, s));
                list2.add(blockPos.add(0, 1, s));
            } else if (r == 2) {
                list2.add(blockPos.add(s, 7, s));
                list2.add(blockPos.add(s, 5, s));
                list2.add(blockPos.add(s, 1, s));
            } else {
                list2.add(blockPos.add(0, 7, 0));
                list2.add(blockPos.add(0, 5, 0));
                list2.add(blockPos.add(0, 1, 0));
            }
        }
        ArrayList list3 = Lists.newArrayList();
        Iterator<BlockPos> var48 = BlockPos.iterate(blockPos.add(this.minGenOffset, this.minGenOffset, this.minGenOffset), blockPos.add(this.maxGenOffset, this.maxGenOffset, this.maxGenOffset)).iterator();
        while (true) {
            if (!var48.hasNext()) {
                block2: for (BlockPos blockPos6 : list3) {
                    Block block2 = Utils.getRandom(this.budBlocks, random);
                    for (EnumFacing direction2 : EnumFacing.values()) {
                        BlockPos blockPos7 = blockPos6.offset(direction2);
                        if (!world.func_147437_c(blockPos7.getX(), blockPos7.getY(), blockPos7.getZ())) continue;
                        world.func_147465_d(blockPos7.getX(), blockPos7.getY(), blockPos7.getZ(), block2, (random.nextBoolean() ? 0 : 6) + direction2.ordinal(), 2);
                        continue block2;
                    }
                }
                return true;
            }
            BlockPos blockPos3 = var48.next();
            double t = doublePerlinNoiseSampler.sample(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ()) * this.noiseMultiplier;
            double u = 0.0;
            double v = 0.0;
            for (Pair pair : list) {
                u += Utils.fastInverseSqrt(blockPos3.getSquaredDistance((Vec3i)pair.getLeft()) + (double)((Integer)pair.getRight()).intValue()) + t;
            }
            for (BlockPos blockPos4 : list2) {
                v += Utils.fastInverseSqrt(blockPos3.getSquaredDistance(blockPos4) + (double)this.crackPointOffset) + t;
            }
            if (u < outerLayerSqrt || world.func_147439_a(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ()).func_149712_f(world, blockPos3.getX(), blockPos3.getY(), blockPos3.getZ()) == -1.0f) continue;
            if (bl && v >= l && u < fillingSqrt) {
                world.func_147468_f(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ());
                continue;
            }
            if (u >= fillingSqrt) {
                world.func_147468_f(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ());
                continue;
            }
            if (u >= innerLayerSqrt) {
                boolean bl2;
                boolean bl3 = bl2 = (double)random.nextFloat() < this.buddingAmethystChance;
                if (bl2) {
                    world.func_147449_b(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), ModBlocks.budding_amethyst);
                } else {
                    world.func_147449_b(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), ModBlocks.amethyst_block);
                }
                if (!bl2 || !((double)random.nextFloat() < this.usePotentialPlacementsChance)) continue;
                list3.add(new BlockPos(blockPos3));
                continue;
            }
            if (u >= middleLayerSqrt) {
                world.func_147465_d(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), ModBlocks.calcite, 0, 2);
                continue;
            }
            if (!(u >= outerLayerSqrt)) continue;
            world.func_147465_d(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), ConfigWorld.amethystOuterBlock, this.outerMeta, 2);
        }
    }

    private static int getRandom(int[] list, Random rand) {
        return list[rand.nextInt(list.length)];
    }
}

