/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.helpers.BlockState;
import ganymedes01.etfuturum.core.utils.helpers.BlockStateUtils;
import ganymedes01.etfuturum.world.generate.NBTStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenFossil
extends WorldGenerator {
    private final List<Pair<Fossil, Fossil>> fossils;

    public WorldGenFossil() {
        Fossil fossilSkull1 = new Fossil("/data/structure/fossil/skull_1.nbt", false);
        Fossil fossilSkullCoal1 = new Fossil("/data/structure/fossil/skull_1_coal.nbt", true);
        Fossil fossilSkull2 = new Fossil("/data/structure/fossil/skull_2.nbt", false);
        Fossil fossilSkullCoal2 = new Fossil("/data/structure/fossil/skull_2_coal.nbt", true);
        Fossil fossilSkull3 = new Fossil("/data/structure/fossil/skull_3.nbt", false);
        Fossil fossilSkullCoal3 = new Fossil("/data/structure/fossil/skull_3_coal.nbt", true);
        Fossil fossilSkull4 = new Fossil("/data/structure/fossil/skull_4.nbt", false);
        Fossil fossilSkullCoal4 = new Fossil("/data/structure/fossil/skull_4_coal.nbt", true);
        Fossil fossilSpine1 = new Fossil("/data/structure/fossil/spine_1.nbt", false);
        Fossil fossilSpineCoal1 = new Fossil("/data/structure/fossil/spine_1_coal.nbt", true);
        Fossil fossilSpine2 = new Fossil("/data/structure/fossil/spine_2.nbt", false);
        Fossil fossilSpineCoal2 = new Fossil("/data/structure/fossil/spine_2_coal.nbt", true);
        Fossil fossilSpine3 = new Fossil("/data/structure/fossil/spine_3.nbt", false);
        Fossil fossilSpineCoal3 = new Fossil("/data/structure/fossil/spine_3_coal.nbt", true);
        Fossil fossilSpine4 = new Fossil("/data/structure/fossil/spine_4.nbt", false);
        Fossil fossilSpineCoal4 = new Fossil("/data/structure/fossil/spine_4_coal.nbt", true);
        this.fossils = new ArrayList<Pair<Fossil, Fossil>>();
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSkull1, (Object)fossilSkullCoal1));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSkull2, (Object)fossilSkullCoal2));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSkull3, (Object)fossilSkullCoal3));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSkull4, (Object)fossilSkullCoal4));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSpine1, (Object)fossilSpineCoal1));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSpine2, (Object)fossilSpineCoal2));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSpine3, (Object)fossilSpineCoal3));
        this.fossils.add((Pair<Fossil, Fossil>)new ImmutablePair((Object)fossilSpine4, (Object)fossilSpineCoal4));
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Pair<Fossil, Fossil> fossilPair = this.fossils.get(rand.nextInt(this.fossils.size()));
        ForgeDirection dir = ForgeDirection.getOrientation((int)(rand.nextInt(4) + 2));
        if (!this.canFossilGenerateHere(world, x, y, z, ((Fossil)fossilPair.getLeft()).getSize(dir), dir)) {
            return false;
        }
        ((Fossil)fossilPair.getLeft()).buildStructure(world, rand, x, y, z, dir);
        ((Fossil)fossilPair.getRight()).buildStructure(world, rand, x, y, z, dir);
        return true;
    }

    private boolean canFossilGenerateHere(World world, int x, int y, int z, BlockPos corners, ForgeDirection dir) {
        int air = 0;
        if (this.isInvalidCorner(world, x, y, z)) {
            ++air;
        }
        if (this.isInvalidCorner(world, x + corners.getX(), y, z)) {
            ++air;
        }
        if (this.isInvalidCorner(world, x, y, z + corners.getZ())) {
            ++air;
        }
        if (this.isInvalidCorner(world, x + corners.getX(), y, z + corners.getZ())) {
            ++air;
        }
        if (this.isInvalidCorner(world, x, y + corners.getY(), z)) {
            ++air;
        }
        if (this.isInvalidCorner(world, x + corners.getX(), y + corners.getY(), z) && air++ >= 5) {
            return false;
        }
        if (this.isInvalidCorner(world, x, y + corners.getY(), z + corners.getZ()) && air++ >= 5) {
            return false;
        }
        if (this.isInvalidCorner(world, x + corners.getX(), y + corners.getY(), z + corners.getZ()) && air++ >= 5) {
            return false;
        }
        return air < 5;
    }

    private boolean isInvalidCorner(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150350_a || !block.func_149662_c();
    }

    public class Fossil
    extends NBTStructure {
        private boolean coal;

        public Fossil(String loc, boolean isCoal) {
            super(loc, isCoal ? 0.1f : 0.9f);
        }

        @Override
        public Map<Integer, BlockState> createPalette(ForgeDirection facing) {
            HashMap<Integer, BlockState> map = new HashMap<Integer, BlockState>();
            if (this.getIntegrity() == 0.1f) {
                map.put(0, new BlockState(Blocks.field_150365_q, 0));
            } else {
                for (Pair<Integer, NBTTagCompound> pair : this.getPaletteNBT()) {
                    String axis = ((NBTTagCompound)pair.getRight()).func_74775_l("Properties").func_74779_i("axis");
                    map.put((Integer)pair.getLeft(), new BlockState(ModBlocks.bone_block, BlockStateUtils.getMetaFromState("axis", axis, facing)));
                }
            }
            return map;
        }
    }
}

