/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.relauncher.Side;
import java.net.URLClassLoader;
import java.util.Arrays;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.LaunchWrapperRuntimeFix;
import pl.asie.foamfix.bugfixmod.coremod.BugfixModClassTransformer;
import pl.asie.foamfix.bugfixmod.mod.ArrowDingTweakEventHandler;
import pl.asie.foamfix.bugfixmod.mod.ToolDesyncFixEventHandler;
import pl.asie.foamfix.ghostbuster.CommandGhostBuster;
import pl.asie.foamfix.ghostbuster.GhostBusterLogger;

@Mod(name="FoamFix", modid="foamfix", version="@VERSION@", acceptableRemoteVersions="*")
public class FoamFixMod {
    @Mod.Instance
    public static FoamFixMod instance;
    public static Logger logger;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent evt) {
        Object handler;
        logger = evt.getModLog();
        System.out.println(System.getProperty("sun.boot.class.path"));
        System.out.println(Arrays.toString(((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()));
        if (BugfixModClassTransformer.instance.settings.ArrowDingTweakEnabled) {
            handler = new ArrowDingTweakEventHandler();
            FMLCommonHandler.instance().bus().register(handler);
            MinecraftForge.EVENT_BUS.register(handler);
        }
        if (evt.getSide() == Side.CLIENT && BugfixModClassTransformer.instance.settings.ToolDesyncFixEnabled) {
            handler = new ToolDesyncFixEventHandler();
            FMLCommonHandler.instance().bus().register(handler);
            MinecraftForge.EVENT_BUS.register(handler);
        }
        if (BugfixModClassTransformer.instance.settings.lwRemovePackageManifestMap) {
            logger.info("Removing LaunchWrapper package manifest map...");
            LaunchWrapperRuntimeFix.removePackageManifestMap();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        if (BugfixModClassTransformer.instance.settings.lwWeakenResourceCache) {
            logger.info("Weakening LaunchWrapper resource cache...");
            LaunchWrapperRuntimeFix.weakenResourceCache();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (BugfixModClassTransformer.instance.settings.gbEnableDebugger) {
            event.registerServerCommand((ICommand)new CommandGhostBuster());
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        GhostBusterLogger.saveLogFile();
    }
}

