/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class EventHandlerApiculture {
    @SubscribeEvent
    public void addFrameTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.itemStack;
        if (itemStack != null && itemStack.func_77973_b() instanceof IHiveFrame) {
            IHiveFrame frame = (IHiveFrame)itemStack.func_77973_b();
            IBeeModifier modifier = frame.getBeeModifier();
            List tooltip = event.toolTip;
            if (!Proxies.common.isShiftDown()) {
                tooltip.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
            } else if (frame.getFrameTooltip() != null) {
                tooltip.addAll(frame.getFrameTooltip());
            } else {
                int durability = itemStack.func_77958_k();
                tooltip.add(StringUtil.localize("frame.tooltip.durability") + EventHandlerApiculture.getDurabilityFormatted(durability));
                float territory = modifier.getTerritoryModifier(null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.territory") + EventHandlerApiculture.getColorFormatted(territory));
                float mutation = modifier.getMutationModifier(null, null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.mutationRate") + EventHandlerApiculture.getColorFormatted(mutation));
                float lifespan = modifier.getLifespanModifier(null, null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.lifespan") + EventHandlerApiculture.getColorFormatted(lifespan));
                float production = modifier.getProductionModifier(null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.production") + EventHandlerApiculture.getColorFormatted(production, true));
                float decay = modifier.getGeneticDecay(null, 1.0f);
                tooltip.add(StringUtil.localize("frame.tooltip.geneticDecay") + EventHandlerApiculture.getColorFormatted(decay));
            }
        }
    }

    private static String getDurabilityFormatted(int durability) {
        EnumChatFormatting color = durability < 100 ? EnumChatFormatting.DARK_RED : (durability < 200 ? EnumChatFormatting.RED : (durability < 250 ? EnumChatFormatting.GOLD : (durability < 750 ? EnumChatFormatting.GREEN : EnumChatFormatting.AQUA)));
        return color + " " + durability;
    }

    private static String getColorFormatted(float value, boolean additive) {
        EnumChatFormatting color = value <= 0.5f ? EnumChatFormatting.DARK_RED : (value < 1.0f ? EnumChatFormatting.RED : (value == 1.0f ? EnumChatFormatting.GOLD : (value <= 2.0f ? EnumChatFormatting.GREEN : EnumChatFormatting.AQUA)));
        String formatted = color.toString();
        formatted = !additive ? formatted + " x" : (value >= 0.0f ? formatted + " +" : formatted + " ");
        if (value == (float)((long)value)) {
            return formatted + (long)value;
        }
        return formatted + value;
    }

    private static String getColorFormatted(float value) {
        return EventHandlerApiculture.getColorFormatted(value, false);
    }
}

