/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.vect.Vect;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial() {
        super("glacial", false, 200, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr);
        Vect offset = area.multiply(-0.5f);
        Vect housingCoords = new Vect(housing.getCoordinates());
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(world.field_73012_v, area);
            Vect posBlock = Vect.add(randomPos, housingCoords, offset);
            Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
            if (block != Blocks.field_150355_j || !world.func_147437_c(posBlock.x, posBlock.y + 1, posBlock.z)) continue;
            world.func_147465_d(posBlock.x, posBlock.y, posBlock.z, Blocks.field_150432_aD, 0, 3);
        }
        return storedData;
    }
}

