/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.Vect;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AlleleEffectSnowing
extends AlleleEffectThrottled {
    public AlleleEffectSnowing() {
        super("snowing", false, 20, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vect area = this.getModifiedArea(genome, housing);
        Vect offset = area.multiply(-0.5f);
        for (int i = 0; i < 1; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(world.field_73012_v, area);
            Vect posBlock = randomPos.add(new Vect(housing.getCoordinates()));
            posBlock = posBlock.add(offset);
            if (!world.isSideSolid(posBlock.x, posBlock.y - 1, posBlock.z, ForgeDirection.UP, false)) continue;
            Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
            if (block == Blocks.field_150431_aC) {
                int meta = world.func_72805_g(posBlock.x, posBlock.y, posBlock.z);
                if (meta >= 7) continue;
                world.func_72921_c(posBlock.x, posBlock.y, posBlock.z, meta + 1, 3);
                continue;
            }
            if (!block.isReplaceable((IBlockAccess)world, posBlock.x, posBlock.y, posBlock.z)) continue;
            world.func_147465_d(posBlock.x, posBlock.y, posBlock.z, Blocks.field_150431_aC, 0, 3);
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (housing.getWorld().field_73012_v.nextInt(3) == 0) {
            Vect area = this.getModifiedArea(genome, housing);
            Vect offset = area.multiply(-0.5f);
            ChunkCoordinates coordinates = housing.getCoordinates();
            World world = housing.getWorld();
            Vect spawn = Vect.getRandomPositionInArea(world.field_73012_v, area).add(coordinates).add(offset);
            Proxies.render.addEntitySnowFX(world, spawn.x, spawn.y, spawn.z);
            return storedData;
        }
        return super.doFX(genome, storedData, housing);
    }
}

