/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids.tanks;

import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FilteredTank
extends StandardTank {
    private final Set<String> filters = new HashSet<String>();

    public FilteredTank(int capacity, Fluid ... filters) {
        this(capacity, Arrays.asList(filters), null);
    }

    public FilteredTank(int capacity, Collection<Fluid> filters) {
        this(capacity, filters, null);
    }

    public FilteredTank(int capacity, Collection<Fluid> filters, TileEntity tile) {
        super(capacity, tile);
        this.setFilters(filters);
    }

    public void setFilters(Collection<Fluid> filters) {
        this.filters.clear();
        for (Fluid fluid : filters) {
            this.filters.add(fluid.getName());
        }
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.liquidMatchesFilter(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public boolean accepts(Fluid fluid) {
        return this.filters.contains(fluid.getName());
    }

    private boolean liquidMatchesFilter(FluidStack resource) {
        if (resource == null || this.filters == null) {
            return false;
        }
        return this.filters.contains(resource.getFluid().getName());
    }

    @Override
    protected void refreshTooltip() {
        if (this.hasFluid()) {
            super.refreshTooltip();
            return;
        }
        this.toolTip.clear();
        if (Proxies.common.isShiftDown() || this.filters.size() < 5) {
            for (String filterName : this.filters) {
                Fluid fluidFilter = FluidRegistry.getFluid((String)filterName);
                EnumRarity rarity = fluidFilter.getRarity();
                if (rarity == null) {
                    rarity = EnumRarity.common;
                }
                FluidStack filterFluidStack = FluidRegistry.getFluidStack((String)fluidFilter.getName(), (int)0);
                ToolTipLine name = new ToolTipLine(fluidFilter.getLocalizedName(filterFluidStack), rarity.field_77937_e, 2);
                this.toolTip.add(name);
            }
        } else {
            this.toolTip.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
        }
        this.toolTip.add(String.format("%,d", this.getFluidAmount()) + " / " + String.format("%,d", this.getCapacity()));
    }
}

