/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IIconProvider;
import forestry.api.core.ITextureManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements ITextureManager {
    private static final TextureManager instance = new TextureManager();
    private static final Map<String, IIcon> defaultIcons = new HashMap<String, IIcon>();
    private static final DefaultIconProvider defaultIconProvider = new DefaultIconProvider();
    private static final List<IIconProvider> iconProviders = new ArrayList<IIconProvider>();

    public static TextureManager getInstance() {
        return instance;
    }

    private TextureManager() {
    }

    public static void initDefaultIcons(IIconRegister register) {
        String[] defaultIconNames;
        for (String str : defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.private", "misc/access.viewable", "misc/access.shared", "misc/energy", "misc/hint", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "particles/swarm_bee", "errors/errored", "errors/unknown", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "mail/carrier.player", "mail/carrier.trader"}) {
            IIcon icon = TextureManager.registerTex(register, str);
            defaultIcons.put(str, icon);
        }
    }

    public static IIcon registerTex(IIconRegister register, String identifier) {
        return register.func_94245_a("forestry:" + identifier);
    }

    public static IIcon registerTexUID(IIconRegister register, short uid, String identifier) {
        IIcon texture = TextureManager.registerTex(register, identifier);
        defaultIconProvider.addTexture(uid, texture);
        return texture;
    }

    @Override
    public IIcon getDefault(String ident) {
        return defaultIcons.get(ident);
    }

    @Override
    public void registerIconProvider(IIconProvider provider) {
        iconProviders.add(provider);
    }

    @Override
    public IIcon getIcon(short texUID) {
        if (texUID < 0) {
            return null;
        }
        for (IIconProvider provider : iconProviders) {
            IIcon icon = provider.getIcon(texUID);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    static {
        ForestryAPI.textureManager = instance;
        instance.registerIconProvider(defaultIconProvider);
    }

    private static class DefaultIconProvider
    implements IIconProvider {
        private final Map<Short, IIcon> textures = new HashMap<Short, IIcon>();

        private DefaultIconProvider() {
        }

        public void addTexture(short texUID, IIcon texture) {
            this.textures.put(texUID, texture);
        }

        @Override
        public IIcon getIcon(short texUID) {
            return this.textures.get(texUID);
        }

        @Override
        public void registerIcons(IIconRegister register) {
        }
    }
}

